/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Operation;
import com.ontotext.models.Selectable;
import com.ontotext.models.SelectableConstraints;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.query.Variables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class BaseOperation
implements Operation {
    protected String requestOperationName;
    protected String name;
    protected String returnType;
    protected Arguments arguments;
    protected Variables variables;
    protected String alias;
    protected Shape returnTypeInstance;
    protected boolean returnTypeAsList;
    protected List<Selection> selections;
    protected List<Selection> whereSelections;
    protected SourceLocation location;
    protected boolean rangeCheck = true;
    protected boolean isValid = true;
    private SelectableConstraints constraints;
    private List<Shape> domainConstraints;
    private SomlSchema somlSchema;
    private String service;

    @Override
    public String getRequestOperationName() {
        return this.requestOperationName;
    }

    public void setRequestOperationName(String requestOperationName) {
        this.requestOperationName = requestOperationName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getType() {
        return this.getReturnType();
    }

    @Override
    public String getDefinedIn() {
        return this.returnType;
    }

    @Override
    public Shape getDefinedInType() {
        return this.returnTypeInstance;
    }

    public void setDomainConstraints(Collection<Shape> domainConstraints) {
        if (this.domainConstraints == null) {
            this.domainConstraints = new ArrayList<Shape>();
        } else {
            this.domainConstraints.clear();
        }
        this.domainConstraints.addAll(domainConstraints);
    }

    @Override
    public List<Shape> getDomainConstraints() {
        if (this.domainConstraints == null) {
            return Collections.emptyList();
        }
        return this.domainConstraints;
    }

    @Override
    public Optional<Shape> getShapeType() {
        return Optional.ofNullable(this.getReturnTypeInstance());
    }

    @Override
    public boolean isCollection() {
        return this.isReturnTypeAsList();
    }

    @Override
    public boolean isNonNullable() {
        return false;
    }

    @Override
    public boolean isNonNullableElements() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public boolean isReturnTypeAsList() {
        return this.returnTypeAsList;
    }

    public void setReturnTypeAsList(boolean returnTypeAsList) {
        this.returnTypeAsList = returnTypeAsList;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public List<Selection> getWhereSelections() {
        if (this.whereSelections == null) {
            this.whereSelections = new LinkedList<Selection>();
        }
        return this.whereSelections;
    }

    @Override
    public Selectable getParent() {
        return null;
    }

    public void setSelections(List<Selection> selections) {
        this.selections = selections;
        if (selections != null) {
            selections.forEach(selection -> selection.setParent(this));
        }
    }

    @Override
    public Arguments getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(Arguments arguments) {
        this.arguments = arguments;
    }

    @Override
    public Variables getVariables() {
        return this.variables;
    }

    public void setVariables(Variables variables) {
        this.variables = variables;
    }

    @Override
    public boolean isComplexType() {
        return this.selections != null && !this.selections.isEmpty();
    }

    @Override
    public SourceLocation getLocation() {
        return this.location;
    }

    @Override
    public boolean isRangeCheck() {
        return this.rangeCheck;
    }

    @Override
    public boolean isRequestedByUser() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void invalidate() {
        this.isValid = false;
    }

    @Override
    public boolean isInFragment() {
        return false;
    }

    public void setRangeCheck(boolean rangeCheck) {
        this.rangeCheck = rangeCheck;
    }

    public void setLocation(SourceLocation location) {
        this.location = location;
    }

    public Shape getReturnTypeInstance() {
        return this.returnTypeInstance;
    }

    public void setReturnTypeInstance(Shape returnTypeInstance) {
        this.returnTypeInstance = returnTypeInstance;
    }

    @Override
    public SelectableConstraints getConstraints() {
        return this.constraints;
    }

    @Override
    public void setConstraints(SelectableConstraints constraints) {
        this.constraints = constraints;
    }

    @Override
    public SomlSchema getSchema() {
        return this.somlSchema != null ? this.somlSchema : this.getDefinedInType().getContainedIn().getContainedIn();
    }

    public void setSchema(SomlSchema somlSchema) {
        this.somlSchema = somlSchema;
    }

    @Override
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("{\n\t").append(this.getName());
        if (!this.getArguments().isEmpty()) {
            builder.append(this.getArguments().entrySet().stream().map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining(", ", "(", ")")));
        }
        builder.append(" : ");
        if (this.isReturnTypeAsList()) {
            builder.append("[");
        }
        builder.append(this.getReturnType());
        if (this.isReturnTypeAsList()) {
            builder.append("]");
        }
        builder.append("}");
        builder.append(" @from(").append(this.getDefinedIn()).append(") ");
        if (this.getSelections() != null && !this.getSelections().isEmpty()) {
            builder.append(" {\n");
            this.getSelections().forEach(selection -> builder.append("\t\t").append(selection).append("\n"));
            builder.append("\t}");
        }
        return builder.toString();
    }
}

