/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ExtensionOptions;
import com.ontotext.models.ServiceExtensionOptions;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractServiceExtensionOptions<O extends ExtensionOptions, S extends ServiceExtensionOptions<O>>
implements ServiceExtensionOptions<O> {
    private boolean enabled = true;
    private Map<String, O> options;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    @Override
    public Map<String, O> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, O> options) {
        this.options = options;
    }

    public S configure(Class<?> target, O options) {
        if (this.getOptions() == null) {
            this.setOptions(new HashMap());
        }
        if (options == null) {
            this.getOptions().remove(target.getSimpleName());
        } else {
            this.getOptions().put(target.getSimpleName(), options);
        }
        return (S)this;
    }

    public S enable(Class<?> target) {
        if (this.getOptions() == null) {
            this.setOptions(new HashMap());
        }
        this.getOptions().computeIfAbsent(target.getSimpleName(), key -> this.createEmptyOptions()).setEnabled(true);
        return (S)this;
    }

    public S disable(Class<?> target) {
        if (this.getOptions() == null) {
            this.setOptions(new HashMap());
        }
        this.getOptions().computeIfAbsent(target.getSimpleName(), key -> this.createEmptyOptions()).setEnabled(false);
        return (S)this;
    }

    protected abstract O createEmptyOptions();
}

