/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame.handler;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.graphdb.repository.http.RequestHeaderAware;
import com.ontotext.trree.HTTPAwareConnection;
import jakarta.servlet.http.HttpServletRequest;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.resolver.RepositoryResolver;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public class GraphDBRepositoryResolver
implements RepositoryResolver {
    private final SemanticDataManagement dataManagement;

    public GraphDBRepositoryResolver(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }

    public RepositoryManager getRepositoryManager() {
        return this.getCurrentLocation().sesameManager();
    }

    public String getRepositoryID(HttpServletRequest request) {
        return RepositoryInterceptor.getRepositoryID((HttpServletRequest)request);
    }

    public RepositoryConfig getRepositoryConfig(String repId, Model model) {
        return RepositoryConfigUtil.getRepositoryConfig((Model)model, (String)repId);
    }

    public RepositoryConnection getRepositoryConnection(HttpServletRequest request, Repository repository) {
        String catchHeader;
        RepositoryConnection conn = repository.getConnection();
        conn.getParserConfig().addNonFatalError((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES);
        conn.getParserConfig().addNonFatalError((RioSetting)BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        if (conn instanceof RequestHeaderAware && (catchHeader = request.getHeader("X-GraphDB-Catch")) != null) {
            ((RequestHeaderAware)conn).addHeader("X-GraphDB-Catch", catchHeader);
        }
        if (conn instanceof HTTPAwareConnection) {
            ((HTTPAwareConnection)conn).setHttp(true);
        }
        return conn;
    }

    public Repository getRepository(HttpServletRequest request) {
        return RepositoryInterceptor.getRepository((HttpServletRequest)request);
    }

    private SemanticLocation getCurrentLocation() {
        return this.dataManagement.getLocationFromHeaderOrThrow();
    }
}

