/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame.cluster;

import com.ontotext.graphdb.sesame.cluster.ClusterQueryResultView;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterResultUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClusterQueryResultView.class);

    public static void handleStatusRuntimeException(StatusRuntimeException exception, HttpServletResponse response) throws IOException {
        ClusterResultUtil.handleStatusRuntimeException(exception, response, false, true);
    }

    public static boolean handleStatusRuntimeException(StatusRuntimeException exception, HttpServletResponse response, boolean onlyIfKnown, boolean isQueryEvaluationError) throws IOException {
        StatusHandlingResult result = ClusterResultUtil.mapGrpcExceptionToHttpResponseDetails(exception, onlyIfKnown);
        if (result.handled) {
            Object errorMessage = result.errorMessage;
            if (isQueryEvaluationError) {
                errorMessage = "Query evaluation error: " + result.errorMessage;
            }
            logger.error("Query evaluation error: ", (Throwable)exception);
            response.sendError(result.httpStatus, (String)errorMessage);
        }
        return result.handled;
    }

    public static StatusHandlingResult mapGrpcExceptionToHttpResponseDetails(StatusRuntimeException exception, boolean onlyIfKnown) {
        boolean handled = true;
        int httpStatus = switch (exception.getStatus().getCode()) {
            case Status.Code.INVALID_ARGUMENT -> 400;
            case Status.Code.ABORTED -> 503;
            case Status.Code.NOT_FOUND -> 404;
            case Status.Code.PERMISSION_DENIED -> 403;
            default -> {
                handled = !onlyIfKnown;
                yield 500;
            }
        };
        return new StatusHandlingResult(httpStatus, handled, exception.getStatus().getDescription());
    }

    public static class StatusHandlingResult {
        final int httpStatus;
        final boolean handled;
        String errorMessage;

        StatusHandlingResult(int httpStatus, boolean handled, String errorMessage) {
            this.httpStatus = httpStatus;
            this.handled = handled;
            this.errorMessage = errorMessage;
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

