/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame.cluster;

import com.ontotext.graphdb.raft.grpc.Data;
import com.ontotext.graphdb.sesame.QueryResultViewBase;
import com.ontotext.graphdb.sesame.cluster.ClusterResultUtil;
import com.ontotext.raft.evaluate.ClosableClusterQueryIterator;
import io.grpc.StatusRuntimeException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.rdf4j.common.lang.FileFormat;

public abstract class ClusterQueryResultView<FACTORY, FORMAT extends FileFormat>
extends QueryResultViewBase<FACTORY, FORMAT> {
    @Override
    protected void handleGenericException(Throwable exception, HttpServletResponse response) throws IOException {
        if (exception instanceof StatusRuntimeException) {
            ClusterResultUtil.handleStatusRuntimeException((StatusRuntimeException)exception, response);
        } else if (exception.getCause() instanceof StatusRuntimeException) {
            StatusRuntimeException sre = (StatusRuntimeException)exception.getCause();
            ClusterResultUtil.handleStatusRuntimeException(sre, response);
        } else {
            super.handleGenericException(exception, response);
        }
    }

    @Override
    protected void renderQueryResult(Map model, HttpServletRequest request, HttpServletResponse response, FACTORY writerFactory, FORMAT format, OutputStream out) throws Exception {
        Iterator resultIterator = (Iterator)model.get("queryResult");
        if (resultIterator instanceof ClosableClusterQueryIterator) {
            try (ClosableClusterQueryIterator closableResultIterator = (ClosableClusterQueryIterator)resultIterator;){
                this.iterateQueryResult((Iterator<Data>)closableResultIterator, response, out);
            }
        } else {
            this.iterateQueryResult(resultIterator, response, out);
        }
        out.flush();
    }

    private void iterateQueryResult(Iterator<Data> resultIterator, HttpServletResponse response, OutputStream out) throws IOException {
        while (resultIterator.hasNext()) {
            Data data = resultIterator.next();
            if (!data.getError().isEmpty()) {
                response.addHeader("X-GraphDB-Error", data.getError());
            }
            if (!data.getWarn().isEmpty()) {
                response.addHeader("X-GraphDB-Warning", data.getWarn());
            }
            out.write(data.getData().toByteArray());
        }
    }
}

