/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame.cluster;

import com.ontotext.graphdb.federation.AutoClosingGraphQueryResult;
import com.ontotext.graphdb.federation.AutoClosingTupleQueryResult;
import com.ontotext.graphdb.raft.grpc.Binding;
import com.ontotext.graphdb.raft.grpc.Header;
import com.ontotext.graphdb.raft.grpc.Query;
import com.ontotext.graphdb.replicationcluster.LocalConsistency;
import com.ontotext.graphdb.sesame.cluster.ClusterGraphResultView;
import com.ontotext.graphdb.sesame.cluster.ClusterResultUtil;
import com.ontotext.graphdb.sesame.cluster.ClusterTupleResultView;
import com.ontotext.graphdb.sesame.handler.GraphDBQueryResultHandler;
import com.ontotext.graphdb.sesame.sos.SOSSplitQuery;
import com.ontotext.raft.GraphDBLoadBalancer;
import io.grpc.StatusRuntimeException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.BooleanQueryResultView;
import org.eclipse.rdf4j.http.server.repository.resolver.RepositoryResolver;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ClusterQueryResultHandler
extends GraphDBQueryResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClusterQueryResultHandler.class);
    private final RepositoryResolver repositoryResolver;
    private GraphDBLoadBalancer loadBalancer;

    public ClusterQueryResultHandler(RepositoryResolver repositoryResolver, GraphDBLoadBalancer loadBalancer) {
        super(repositoryResolver);
        this.repositoryResolver = repositoryResolver;
        this.loadBalancer = loadBalancer;
    }

    public ModelAndView handleQueryRequest(HttpServletRequest request, RequestMethod requestMethod, HttpServletResponse response) throws HTTPException, IOException {
        RepositoryConnection repositoryCon = null;
        boolean leaderEvaluation = false;
        String queryString = null;
        try {
            Repository repository = this.repositoryResolver.getRepository(request);
            repositoryCon = this.repositoryResolver.getRepositoryConnection(request, repository);
            queryString = this.getQueryString(request, requestMethod);
            Query query = this.getQuery(request, repositoryCon, queryString);
            boolean headersOnly = requestMethod == RequestMethod.HEAD;
            try {
                Object queryResponse = null;
                FileFormatServiceRegistry registry = this.getResultWriterFor(query);
                if (registry == null) {
                    throw new UnsupportedOperationException("Unknown result writer for query of type: " + query.getClass().getName());
                }
                if (!headersOnly) {
                    queryResponse = this.evaluateQuery(queryString, request, response, query, repositoryCon);
                }
                if (queryResponse == null) {
                    if (repositoryCon != null) {
                        repositoryCon.close();
                    }
                    leaderEvaluation = true;
                    return super.handleQueryRequest((HttpServletRequest)new CachedQueryRequest(request, queryString), requestMethod, response);
                }
                View view = this.getClusterViewFor(query);
                if (view == null) {
                    throw new UnsupportedOperationException("Unknown view for query of type: " + query.getClass().getName());
                }
                return this.getModelAndView(request, response, headersOnly, repositoryCon, view, queryResponse, registry);
            }
            catch (QueryInterruptedException e) {
                logger.error("Query interrupted", (Throwable)e);
                throw new ServerHTTPException(503, "Query evaluation took too long");
            }
            catch (QueryEvaluationException e) {
                logger.error("Query evaluation error", (Throwable)e);
                if (e.getCause() instanceof HTTPException) {
                    throw (HTTPException)e.getCause();
                }
                throw new ServerHTTPException("Query evaluation error: " + e.getMessage());
            }
        }
        catch (Exception e) {
            boolean evaluateLocally;
            boolean bl = evaluateLocally = !leaderEvaluation;
            if (e instanceof StatusRuntimeException) {
                boolean bl2 = evaluateLocally = !ClusterResultUtil.handleStatusRuntimeException((StatusRuntimeException)e, response, evaluateLocally, false);
            }
            if (evaluateLocally) {
                logger.error("An error occurred during query load balancing. Attempting to evaluate it on leader node", (Throwable)e);
                return super.handleQueryRequest((HttpServletRequest)new CachedQueryRequest(request, queryString), requestMethod, response);
            }
            if (repositoryCon != null) {
                repositoryCon.close();
            }
            throw e;
        }
    }

    protected Object evaluateQuery(String queryString, HttpServletRequest request, HttpServletResponse response, Query query, RepositoryConnection repositoryCon) throws ClientHTTPException {
        long limit = this.getLimit(request);
        long offset = this.getOffset(request);
        boolean distinct = this.isDistinct(request);
        LocalConsistency consistency = LocalConsistency.fromHeaderValue((String)request.getHeader("X-GraphDB-Local-Consistency"));
        Query.Builder queryBuilder = com.ontotext.graphdb.raft.grpc.Query.newBuilder().setQuery(queryString).setLimit(limit).setOffset(offset).setDistinct(distinct).setRepository(this.repositoryResolver.getRepositoryID(request));
        if (query instanceof SOSSplitQuery) {
            queryBuilder.setIsSOSSplitQuery(true).setSplitQueryLimit(this.getSplitQueryLimit(request));
        }
        this.setQueryParams(queryBuilder, request, query);
        String locationHeaderValue = request.getHeader("X-GraphDB-Repository-Location");
        if (StringUtils.isNotEmpty((CharSequence)locationHeaderValue)) {
            queryBuilder.addHeader(Header.newBuilder().setHeaderKey("X-GraphDB-Repository-Location").setHeaderValue(locationHeaderValue));
        }
        Object service = ProtocolUtil.getAcceptableService((HttpServletRequest)request, (HttpServletResponse)response, (FileFormatServiceRegistry)this.getResultWriterFor(query));
        if (query instanceof TupleQuery && service instanceof TupleQueryResultWriterFactory) {
            String fileFormat = ((TupleQueryResultWriterFactory)service).getTupleQueryResultFormat().getDefaultMIMEType();
            return this.loadBalancer.evaluateTupleQuery(queryBuilder.setMime(fileFormat).build(), consistency, repositoryCon);
        }
        if (query instanceof GraphQuery && service instanceof RDFWriterFactory) {
            String acceptHeader;
            RDFFormat rdfFormat = ((RDFWriterFactory)service).getRDFFormat();
            String fileFormat = rdfFormat.getDefaultMIMEType();
            if ((rdfFormat == RDFFormat.JSONLD || rdfFormat == RDFFormat.NDJSONLD) && StringUtils.isNotEmpty((CharSequence)(acceptHeader = request.getHeader("Accept")))) {
                queryBuilder.addHeader(Header.newBuilder().setHeaderKey("Accept").setHeaderValue(acceptHeader));
                String linkHeader = request.getHeader("Link");
                if (StringUtils.isNotEmpty((CharSequence)linkHeader)) {
                    queryBuilder.addHeader(Header.newBuilder().setHeaderKey("Link").setHeaderValue(linkHeader));
                }
            }
            return this.loadBalancer.evaluateGraphQuery(queryBuilder.setMime(fileFormat).build(), consistency, repositoryCon);
        }
        if (query instanceof BooleanQuery && service instanceof BooleanQueryResultWriterFactory) {
            BooleanQueryResultWriterFactory booleanWriter = (BooleanQueryResultWriterFactory)service;
            String fileFormat = booleanWriter.getBooleanQueryResultFormat().getDefaultMIMEType();
            return this.loadBalancer.evaluateBooleanQuery(queryBuilder.setMime(fileFormat).build(), consistency, repositoryCon);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean evaluateQuery(BooleanQuery query, long limit, long offset, boolean distinct) {
        this.loadBalancer.incrementQueryCount();
        try {
            Boolean bl = super.evaluateQuery(query, limit, offset, distinct);
            return bl;
        }
        finally {
            this.loadBalancer.decrementQueryCount();
        }
    }

    protected GraphQueryResult evaluateQuery(GraphQuery query, long limit, long offset, boolean distinct) {
        this.loadBalancer.incrementQueryCount();
        GraphQueryResult queryResult = null;
        try {
            queryResult = super.evaluateQuery(query, limit, offset, distinct);
        }
        catch (RuntimeException re) {
            this.loadBalancer.decrementQueryCount();
            throw re;
        }
        return new AutoClosingGraphQueryResult(queryResult, ClusterQueryResultHandler.onlyOnce(result -> this.loadBalancer.decrementQueryCount()));
    }

    protected TupleQueryResult evaluateQuery(TupleQuery query, long limit, long offset, boolean distinct) {
        this.loadBalancer.incrementQueryCount();
        TupleQueryResult queryResult = null;
        try {
            queryResult = super.evaluateQuery(query, limit, offset, distinct);
        }
        catch (RuntimeException re) {
            this.loadBalancer.decrementQueryCount();
            throw re;
        }
        return new AutoClosingTupleQueryResult(queryResult, ClusterQueryResultHandler.onlyOnce(result -> this.loadBalancer.decrementQueryCount()));
    }

    @Override
    protected TupleQueryResult evaluateSoSplitQuery(SOSSplitQuery query) {
        this.loadBalancer.incrementQueryCount();
        TupleQueryResult queryResult = null;
        try {
            queryResult = super.evaluateSoSplitQuery(query);
        }
        catch (RuntimeException re) {
            this.loadBalancer.decrementQueryCount();
            throw re;
        }
        return new AutoClosingTupleQueryResult(queryResult, ClusterQueryResultHandler.onlyOnce(result -> this.loadBalancer.decrementQueryCount()));
    }

    private static <E> Consumer<E> onlyOnce(Consumer<E> consumer) {
        boolean[] flag = new boolean[]{true};
        return value -> {
            if (flag[0]) {
                flag[0] = false;
                consumer.accept(value);
            }
        };
    }

    protected View getClusterViewFor(Query query) {
        if (query instanceof TupleQuery) {
            return ClusterTupleResultView.getInstance();
        }
        if (query instanceof GraphQuery) {
            return ClusterGraphResultView.getInstance();
        }
        if (query instanceof BooleanQuery) {
            return BooleanQueryResultView.getInstance();
        }
        return null;
    }

    private void setQueryParams(Query.Builder builder, HttpServletRequest request, Query query) {
        builder.setIncludeInferred(query.getIncludeInferred());
        String baseUri = request.getParameter("baseURI");
        if (baseUri != null) {
            builder.setBase(baseUri);
        }
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
            String name = parameterName.substring("$".length());
            String value = request.getParameter(parameterName);
            builder.addParameters(Binding.newBuilder().setName(name).setEncodedValue(value).build());
        }
        if (query.getDataset() != null) {
            for (IRI defaultGraph : query.getDataset().getDefaultGraphs()) {
                builder.addDefaultGraphs(defaultGraph.stringValue());
            }
            for (IRI namedGraph : query.getDataset().getNamedGraphs()) {
                builder.addNamedGraphs(namedGraph.stringValue());
            }
        }
    }

    private int getSplitQueryLimit(HttpServletRequest request) {
        String limit = request.getHeader("X-GraphDB-SplitQueryLimit");
        return StringUtils.isNotEmpty((CharSequence)limit) ? Integer.parseInt(limit) : Integer.MAX_VALUE;
    }

    public GraphDBLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(GraphDBLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    private static class CachedQueryRequest
    extends HttpServletRequestWrapper {
        private final String query;

        public CachedQueryRequest(HttpServletRequest request, String query) {
            super(request);
            this.query = query;
        }

        public BufferedReader getReader() throws IOException {
            if (this.query == null) {
                return super.getReader();
            }
            return new BufferedReader(new StringReader(this.query));
        }
    }
}

