/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.graphdb.sesame.ControllerUtil;
import com.ontotext.graphdb.sesame.ExportStatementsView;
import com.ontotext.license.LicenseValidationException;
import com.ontotext.raft.GraphDBLoadBalancer;
import com.ontotext.raft.repository.ClusterRepositoryManager;
import com.ontotext.raft.repository.ClusterSailException;
import com.ontotext.trree.ParallelImport;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.common.webapp.util.HttpServerUtil;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Controller
public class StatementsController
extends org.eclipse.rdf4j.http.server.repository.statements.StatementsController {
    private SemanticDataManagement dataManagement;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reqMethod;
        Repository repository = RepositoryInterceptor.getRepository((HttpServletRequest)request);
        if (ControllerUtil.isGraphDBRepository(repository)) {
            this.setParallelModeForRawFiles(request);
            if (!ControllerUtil.parseBoolean(request.getParameter("sameAs"), true)) {
                request = ControllerUtil.addParameterValues(request, "using-graph-uri", ControllerUtil.getDisableSameAsUri());
            }
        }
        if ("GET".equals(reqMethod = request.getMethod())) {
            return this.getExportStatementsResult(repository, request, response);
        }
        if ("HEAD".equals(reqMethod)) {
            return this.getExportStatementsResult(repository, request, response);
        }
        try {
            return super.handleRequestInternal(request, response);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof ClusterSailException) {
                throw new ServerHTTPException(rootCause.getMessage(), rootCause);
            }
            if (rootCause != null && rootCause.getMessage() != null && rootCause.getMessage().contains("Could not parse the query result")) {
                throw new GraphDBWorkbenchException(rootCause.getMessage() + " Check GraphDB logs for detailed reason.");
            }
            if (rootCause instanceof LicenseValidationException) {
                throw new GraphDBWorkbenchException(rootCause.getMessage());
            }
            throw e;
        }
    }

    @VisibleForTesting
    void setParallelModeForRawFiles(HttpServletRequest request) {
        String mimeType;
        boolean useParallel = false;
        if ("POST".equals(request.getMethod()) && !this.isTransactionOperations(mimeType = HttpServerUtil.getMIMEType((String)request.getContentType())) && !ControllerUtil.isUpdateQuery(request, mimeType)) {
            useParallel = true;
        }
        ParallelImport.setNextConnectionUseParallel((boolean)useParallel);
    }

    private boolean isTransactionOperations(String mimeType) {
        return "application/x-rdftransaction".equals(mimeType);
    }

    private ModelAndView getExportStatementsResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        ProtocolUtil.logRequestParameters((HttpServletRequest)request);
        ValueFactory vf = repository.getValueFactory();
        Resource subj = ProtocolUtil.parseResourceParam((HttpServletRequest)request, (String)"subj", (ValueFactory)vf);
        IRI pred = ProtocolUtil.parseURIParam((HttpServletRequest)request, (String)"pred", (ValueFactory)vf);
        Value obj = ProtocolUtil.parseValueParam((HttpServletRequest)request, (String)"obj", (ValueFactory)vf);
        Resource[] contexts = ProtocolUtil.parseContextParam((HttpServletRequest)request, (String)"context", (ValueFactory)vf);
        boolean useInferencing = ProtocolUtil.parseBooleanParam((HttpServletRequest)request, (String)"infer", (boolean)true);
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)ProtocolUtil.getAcceptableService((HttpServletRequest)request, (HttpServletResponse)response, (FileFormatServiceRegistry)RDFWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subject", subj);
        model.put("predicate", pred);
        model.put("object", obj);
        model.put("contexts", contexts);
        model.put("useInferencing", useInferencing);
        model.put("factory", rdfWriterFactory);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        model.put("loadBalancer", this.getLoadBalancer());
        return new ModelAndView((View)ExportStatementsView.getInstance(), model);
    }

    private GraphDBLoadBalancer getLoadBalancer() {
        RepositoryManager manager = this.dataManagement.getCurrentLocationOrThrow().sesameManager();
        if (manager instanceof ClusterRepositoryManager && ExportStatementsView.enableBalancer) {
            ClusterRepositoryManager clusterManager = (ClusterRepositoryManager)manager;
            return clusterManager.getLoadBalancer();
        }
        return null;
    }

    public void setDataManagement(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }
}

