/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.ontotext.trree.SystemGraphs;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.repository.DelegatingRepository;
import org.eclipse.rdf4j.repository.Repository;

public class ControllerUtil {
    public static final String SAMEAS_PARAM_NAME = "sameAs";

    static HttpServletRequest addParameterValues(HttpServletRequest request, final String parameterName, String ... addValues) {
        String[] overriddenValues;
        String[] requestValues = request.getParameterValues(parameterName);
        if (requestValues != null && requestValues.length > 0) {
            overriddenValues = new String[requestValues.length + addValues.length];
            System.arraycopy(requestValues, 0, overriddenValues, 0, requestValues.length);
            System.arraycopy(addValues, 0, overriddenValues, requestValues.length, addValues.length);
            overriddenValues[requestValues.length] = ControllerUtil.getDisableSameAsUri();
        } else {
            overriddenValues = addValues;
        }
        return new HttpServletRequestWrapper(request){

            public String[] getParameterValues(String name) {
                if (parameterName.equals(name)) {
                    return overriddenValues;
                }
                return super.getParameterValues(name);
            }
        };
    }

    public static boolean parseBoolean(String string, boolean defaultValue) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(string) || "1".equals(string);
    }

    public static boolean isGraphDBRepository(Repository repository) {
        if (repository == null) {
            return false;
        }
        while (repository instanceof DelegatingRepository) {
            repository = ((DelegatingRepository)repository).getDelegate();
        }
        return repository instanceof MonitorRepository;
    }

    public static boolean isUpdateQuery(HttpServletRequest request, String mimeType) {
        return "application/sparql-update".equals(mimeType) || request.getParameterMap().containsKey("update");
    }

    public static String getDisableSameAsUri() {
        IRI uri = SystemGraphs.DISABLE_SAMEAS_GRAPH.getUri();
        assert (uri != null);
        return uri.stringValue();
    }
}

