/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.ontotext.forest.core.ForestErrorController;
import com.ontotext.graphdb.CatchAction;
import com.ontotext.graphdb.repository.http.ResponseHeaderAware;
import com.ontotext.trree.QueryTimeoutWarningException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(CatchHandler.class);
    static final CatchAction DEFAULT_ACTION = CatchAction.THROW;
    static final CatchHandlerParam NO_ACTION_PARAM = new CatchHandlerParam(0, CatchAction.THROW);

    public static CatchHandlerParam parseCatchParam(HttpServletRequest request) throws ClientHTTPException {
        return CatchHandlerParam.fromHeaderValue(request.getHeader("X-GraphDB-Catch"));
    }

    static int parseMaxResults(String value, String headerValue) throws ClientHTTPException {
        try {
            return Integer.parseInt(value);
        }
        catch (IllegalArgumentException e) {
            throw new ClientHTTPException(400, "Invalid value for max results buffer in X-GraphDB-Catch header: '" + headerValue + "': " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processWithBuffer(TupleQueryResult tqr, QueryResultHandler handler, HttpServletResponse response, CatchHandlerParam catchParam) throws TupleQueryResultHandlerException, QueryEvaluationException {
        handler.startQueryResult(tqr.getBindingNames());
        try {
            boolean processRemainder = true;
            if (tqr instanceof ResponseHeaderAware) {
                String warning;
                String error = ((ResponseHeaderAware)tqr).getError();
                if (error != null) {
                    response.addHeader("X-GraphDB-Error", error);
                }
                if ((warning = ((ResponseHeaderAware)tqr).getWarning()) != null) {
                    response.addHeader("X-GraphDB-Warning", warning);
                }
            } else if (catchParam.maxBufferResults > 0) {
                LinkedList<BindingSet> bufferedBindingSets;
                block20: {
                    bufferedBindingSets = new LinkedList<BindingSet>();
                    try {
                        for (int i = 0; i < catchParam.maxBufferResults && tqr.hasNext(); ++i) {
                            bufferedBindingSets.add((BindingSet)tqr.next());
                        }
                    }
                    catch (QueryTimeoutWarningException e) {
                        response.addHeader("X-GraphDB-Warning", e.getMessage());
                    }
                    catch (Exception e) {
                        if (catchParam.action == CatchAction.THROW) {
                            throw e;
                        }
                        if (catchParam.action != CatchAction.REPORT) break block20;
                        LOGGER.error("Caught error to be reported as header", (Throwable)e);
                        response.addHeader("X-GraphDB-Error", e.getMessage());
                        processRemainder = false;
                    }
                }
                for (BindingSet bindingSet : bufferedBindingSets) {
                    handler.handleSolution(bindingSet);
                }
            }
            try {
                while (processRemainder && tqr.hasNext()) {
                    BindingSet bindingSet = (BindingSet)tqr.next();
                    handler.handleSolution(bindingSet);
                }
            }
            catch (QueryTimeoutWarningException e) {
                if (!response.isCommitted()) {
                    response.setHeader("X-GraphDB-Warning", e.getMessage());
                }
            }
            catch (Throwable e) {
                if (response.isCommitted()) {
                    handler.endQueryResult();
                    ForestErrorController.forceCloseSocketIfCommitted((HttpServletResponse)response, (Throwable)e, (Logger)LOGGER);
                }
                throw e;
            }
        }
        finally {
            tqr.close();
        }
        handler.endQueryResult();
    }

    static class CatchHandlerParam {
        int maxBufferResults;
        CatchAction action;

        CatchHandlerParam(int maxBufferResults, CatchAction action) {
            this.maxBufferResults = maxBufferResults;
            this.action = action;
        }

        static CatchHandlerParam fromHeaderValue(String headerValue) throws ClientHTTPException {
            if (StringUtils.isEmpty((CharSequence)headerValue)) {
                return NO_ACTION_PARAM;
            }
            int semicolonPos = headerValue.indexOf(59);
            if (semicolonPos > 0) {
                String maxBufferString = headerValue.substring(0, semicolonPos).trim();
                int maxBuffer = CatchHandler.parseMaxResults(maxBufferString, headerValue);
                String actionString = headerValue.substring(semicolonPos + 1).trim().toUpperCase();
                try {
                    CatchAction action = CatchAction.valueOf((String)actionString);
                    return new CatchHandlerParam(maxBuffer, action);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Invalid value for action in X-GraphDB-Catch header: '" + headerValue + "': " + e.getMessage());
                }
            }
            int maxBuffer = CatchHandler.parseMaxResults(headerValue.trim(), headerValue);
            return new CatchHandlerParam(maxBuffer, DEFAULT_ACTION);
        }
    }
}

