/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sesame;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class RepositoryListController
extends org.eclipse.rdf4j.http.server.repository.RepositoryListController {
    private SemanticDataManagement dataManagement;

    public void setDataManagement(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if ("GET".equals(request.getMethod())) {
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            try {
                StringBuffer requestURL;
                ArrayList<String> bindingNames = new ArrayList<String>();
                ArrayList bindingSets = new ArrayList();
                if (!StringUtils.isEmpty((CharSequence)request.getHeader("X-Forwarded-Host"))) {
                    String protocol = request.getHeader("X-Forwarded-Proto");
                    if (StringUtils.isEmpty((CharSequence)protocol)) {
                        protocol = request.isSecure() ? "https" : "http";
                    }
                    requestURL = new StringBuffer(protocol);
                    requestURL.append("://");
                    requestURL.append(request.getHeader("X-Forwarded-Host"));
                    requestURL.append(request.getRequestURI());
                } else {
                    requestURL = request.getRequestURL();
                }
                if (requestURL.charAt(requestURL.length() - 1) != '/') {
                    requestURL.append('/');
                }
                String namespace = requestURL.toString();
                this.dataManagement.getCurrentLocationOrThrow().sesameManager().getAllRepositoryInfos(false).forEach(arg_0 -> RepositoryListController.lambda$handleRequestInternal$0((ValueFactory)vf, namespace, bindingSets, arg_0));
                bindingNames.add("uri");
                bindingNames.add("id");
                bindingNames.add("title");
                bindingNames.add("readable");
                bindingNames.add("writable");
                model.put("queryResult", new IteratingTupleQueryResult(bindingNames, bindingSets));
            }
            catch (RepositoryException ex) {
                throw new ServerHTTPException(ex.getMessage(), (Throwable)ex);
            }
        }
        TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)ProtocolUtil.getAcceptableService((HttpServletRequest)request, (HttpServletResponse)response, (FileFormatServiceRegistry)TupleQueryResultWriterRegistry.getInstance());
        model.put("filenameHint", "repositories");
        model.put("factory", factory);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        return new ModelAndView((View)TupleQueryResultView.getInstance(), model);
    }

    private static /* synthetic */ void lambda$handleRequestInternal$0(ValueFactory vf, String namespace, ArrayList bindingSets, RepositoryInfo info) {
        QueryBindingSet bindings = new QueryBindingSet();
        bindings.addBinding("uri", (Value)vf.createIRI(namespace, info.getId()));
        bindings.addBinding("id", (Value)vf.createLiteral(info.getId()));
        if (info.getDescription() != null) {
            bindings.addBinding("title", (Value)vf.createLiteral(info.getDescription()));
        }
        bindings.addBinding("readable", (Value)vf.createLiteral(info.isReadable()));
        bindings.addBinding("writable", (Value)vf.createLiteral(info.isWritable()));
        bindingSets.add(bindings);
    }
}

