/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sesame;

import com.ontotext.graphdb.security.acl.AccessControlException;
import com.ontotext.raft.repository.ClusterSailException;
import com.ontotext.trree.util.ErrorUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.rdf4j.common.exception.ValidationException;
import org.eclipse.rdf4j.common.webapp.views.SimpleCustomResponseView;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.shacl.GraphDBShaclSailValidationException;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class GraphDBProtocolExceptionResolver
implements HandlerExceptionResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        int statusCode = this.mapExceptionToStatusCode(exception);
        if (exception instanceof HTTPException) {
            if (exception instanceof ClientHTTPException) {
                this.logger.error("Client sent bad request (" + statusCode + ")", (Throwable)exception);
            } else if (exception.getCause() instanceof ClusterSailException) {
                this.logger.error("Error while handling request (" + statusCode + ") with exception type {} and message {}", ClusterSailException.class, (Object)exception.getMessage());
            } else {
                this.logger.error("Error while handling request (" + statusCode + ")", (Throwable)exception);
            }
        } else if (exception instanceof MalformedQueryException) {
            statusCode = 400;
        } else if (exception instanceof AccessDeniedException) {
            statusCode = 403;
        } else {
            this.logger.error("Error while handling request", (Throwable)exception);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        Throwable cause = this.getRootCause(exception);
        if (cause instanceof ValidationException) {
            model.put("sc", statusCode);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            RDFWriter writer = ErrorUtil.createValidationExceptionRDFWriter((HttpServletRequest)request, (OutputStream)byteArrayOutputStream);
            GraphDBShaclSailValidationException graphDBShaclSailValidationException = GraphDBProtocolExceptionResolver.getGraphDBShaclSailValidationException(exception);
            if (graphDBShaclSailValidationException != null) {
                Rio.write((Iterable)graphDBShaclSailValidationException.getModelForUseOutsideTransaction(), (RDFHandler)writer);
            } else {
                Rio.write((Iterable)((ValidationException)cause).validationReportAsModel(), (RDFHandler)writer);
            }
            model.put("content", new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            model.put("contentType", "application/shacl-validation-report+n-quads");
            model.put("contentLength", byteArrayOutputStream.size());
            return new ModelAndView((View)SimpleCustomResponseView.getInstance(), model);
        }
        String message = exception.getMessage();
        String errMsg = message != null ? ErrorUtil.getSimpleMessage((String)message) : "Unknown error (see server log)";
        model.put("sc", statusCode);
        model.put("content", errMsg);
        return new ModelAndView((View)SimpleResponseView.getInstance(), model);
    }

    private static GraphDBShaclSailValidationException getGraphDBShaclSailValidationException(Exception exception) {
        GraphDBShaclSailValidationException graphDBShaclSailValidationException = null;
        for (Exception e = exception; graphDBShaclSailValidationException == null && e != null; e = (Exception)e.getCause()) {
            if (!(e instanceof GraphDBShaclSailValidationException)) continue;
            graphDBShaclSailValidationException = (GraphDBShaclSailValidationException)e;
        }
        return graphDBShaclSailValidationException;
    }

    private Throwable getRootCause(Exception exception) {
        Throwable cause;
        for (cause = exception.getCause(); cause != null && !(cause instanceof ShaclSailValidationException); cause = cause.getCause()) {
        }
        return cause;
    }

    private int mapExceptionToStatusCode(Exception exception) {
        Throwable cause = exception;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof AccessControlException) {
            return 403;
        }
        if (exception instanceof HTTPException) {
            return ((HTTPException)exception).getStatusCode();
        }
        return 500;
    }
}

