/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.general.aggregation;

import com.github.tkurz.media.ontology.function.SpatialFunction;
import com.github.tkurz.media.ontology.function.TemporalFunction;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.media.ontology.type.SpatialTemporalEntity;
import com.github.tkurz.media.ontology.type.TemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import com.google.common.base.Joiner;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="boundingBox", properties={SpatialTemporalEntity.class, SpatialTemporalEntity.class}, reference=FunctionDoc.Reference.combined, description="returns new MediaFragment / MediaFragmentURI with spatial and temporal fragment. It it works like spatialFunction:boundingBox, temporalFunction:boundingBox or both together.", type=FunctionDoc.Type.extensionAggregate)
public class BoundingBoxFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#boundingBox";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        SpatialEntity[] entities2;
        if (values.length < 2 || !FunctionHelper.isComparable(values)) {
            return null;
        }
        Object[] res = new String[2];
        try {
            entities2 = FunctionHelper.toSpatialEntities(values);
            res[0] = SpatialFunction.getBoundingBox((SpatialEntity[])entities2).stringValue();
        }
        catch (IllegalArgumentException entities2) {
            // empty catch block
        }
        try {
            entities2 = FunctionHelper.toTemporalEntities(values);
            res[1] = TemporalFunction.getBoundingBox((TemporalEntity[])entities2).stringValue();
        }
        catch (IllegalArgumentException entities3) {
            // empty catch block
        }
        if (values[0] instanceof IRI) {
            String uri = FunctionHelper.getCleanURI(values[0]);
            return valueFactory.createIRI(uri + "#" + Joiner.on((String)"&").skipNulls().join(res));
        }
        return valueFactory.createLiteral(Joiner.on((String)"&").skipNulls().join(res));
    }
}

