/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.general.accessor;

import com.github.tkurz.media.fragments.base.MediaFragment;
import com.github.tkurz.media.fragments.base.MediaFragmentURI;
import com.github.tkurz.media.ontology.type.SpatialTemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="toPercent Transformer", properties={SpatialTemporalEntity.class, Double.class}, reference=FunctionDoc.Reference.combined, description="returns a string representation of a media fragment (uri) transformed to percent using a double parameter.", type=FunctionDoc.Type.accessorFunction)
public class ToPercentTransformer
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#toPercent";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        if (values.length == 3) {
            if (values[0] instanceof IRI && values[1] instanceof Literal && values[2] instanceof Literal) {
                try {
                    MediaFragmentURI uri = FunctionHelper.toMediaFragmentURI(values[0]);
                    double width = Double.parseDouble(values[1].stringValue());
                    double height = Double.parseDouble(values[2].stringValue());
                    if (uri != null) {
                        return valueFactory.createIRI(uri.toPercent(width, height).stringValue());
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (values[0] instanceof Literal && values[1] instanceof Literal && values[2] instanceof Literal) {
                try {
                    MediaFragment entity = FunctionHelper.toMediaFragment(values[0]);
                    double width = Double.parseDouble(values[1].stringValue());
                    double height = Double.parseDouble(values[2].stringValue());
                    if (entity != null) {
                        return valueFactory.createIRI(entity.toPercent(width, height).stringValue());
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }
}

