/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.doc;

import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.vocabularies.SCHEMA;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionSet {
    private static Logger logger = LoggerFactory.getLogger(FunctionSet.class);
    public static String URL = "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#".substring(0, "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#".length() - 1);
    public static String TITLE = "SPARQL-MM Function Library for Media Fragments";
    public static String DESCRIPTION = "SPARQL Function Library for handling Media Fragments IRI like they are recommended from W3C at http://www.w3.org/TR/media-frags/ Media Fragments IRI 1.0 (basic) recommendation.";
    public static String CREATOR = "http://github.com/tkurz";
    public static String PUBLISHER = "http://mico-project.eu";
    public static String LICENSE = "http://www.apache.org/licenses/LICENSE-2.0";
    public static String HOMEPAGE = "http://github.com/tkurz/sparql-mm";
    public static String LINK_TURTLE = "index.ttl";
    public static String LINK_XML = "index.rdf";
    public static String STYLE_URL = "style.css";
    private List<Function> functions = new ArrayList<Function>();
    private Model model = new LinkedHashModel();

    public FunctionSet(List<String> functionNames) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (String functionName : functionNames) {
            this.functions.add(new Function(functionName));
        }
        Collections.sort(this.functions, new Comparator<Function>(){

            @Override
            public int compare(Function o1, Function o2) {
                return o1.title.compareTo(o2.title);
            }
        });
        SimpleValueFactory f = SimpleValueFactory.getInstance();
        IRI vocabulary = f.createIRI(URL);
        this.model.add((Resource)vocabulary, RDF.TYPE, (Value)SimpleValueFactory.getInstance().createIRI("http://purl.org/net/schemas/sparql-extension-description#FunctionLibrary"), new Resource[0]);
        this.model.add((Resource)vocabulary, SCHEMA.name, (Value)f.createLiteral(TITLE), new Resource[0]);
        this.model.add((Resource)vocabulary, SCHEMA.description, (Value)f.createLiteral(DESCRIPTION), new Resource[0]);
        this.model.add((Resource)vocabulary, SCHEMA.version, (Value)f.createLiteral("2.0.0"), new Resource[0]);
        this.model.add((Resource)vocabulary, SCHEMA.creator, (Value)f.createIRI(CREATOR), new Resource[0]);
        this.model.add((Resource)vocabulary, SCHEMA.provider, (Value)f.createIRI(PUBLISHER), new Resource[0]);
        this.model.add((Resource)vocabulary, f.createIRI("http://schema.org/license"), (Value)f.createIRI(LICENSE), new Resource[0]);
        this.model.add((Resource)vocabulary, SCHEMA.url, (Value)f.createIRI(HOMEPAGE), new Resource[0]);
        for (Function function : this.functions) {
            this.model.add((Resource)function.uri, RDF.TYPE, (Value)function.type, new Resource[0]);
            this.model.add((Resource)function.uri, SCHEMA.name, (Value)f.createLiteral(function.title), new Resource[0]);
            this.model.add((Resource)function.uri, SCHEMA.description, (Value)f.createLiteral(function.description), new Resource[0]);
            this.model.add((Resource)function.uri, SimpleValueFactory.getInstance().createIRI("http://purl.org/net/schemas/sparql-extension-description#includedIn"), (Value)vocabulary, new Resource[0]);
            this.model.add((Resource)vocabulary, SimpleValueFactory.getInstance().createIRI("http://purl.org/net/schemas/sparql-extension-description#includes"), (Value)function.uri, new Resource[0]);
        }
    }

    public void toRDF(File file, RDFFormat format) throws RDFHandlerException, IOException {
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charset.forName("UTF-8"));
        Rio.write((Iterable)this.model, (Writer)writer, (RDFFormat)format);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void toMD(File file) throws IOException {
        PrintWriter out = new PrintWriter(file);
        out.printf("# %s%n", TITLE);
        out.println();
        out.println("The IRI for this vocabulary is");
        out.println();
        out.println("```");
        out.println("http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#");
        out.println("```");
        out.println();
        out.printf("When abbreviating terms the suggested prefix is `%s`%n", "mm");
        out.println();
        out.println("Each function in this function set has a IRI constructed by appending a term name to the vocabulary IRI. For example:");
        out.println();
        out.println("```");
        out.println(this.functions.get((int)0).uri.stringValue());
        out.println("```");
        out.println();
        out.print("There are machine readable function description using [SPARQL Extension Description Vocabulary](http://www.ldodds.com/schemas/sparql-extension-description/) in ");
        out.printf("[RDF/XML](%s) and [TURTLE](%s).%n", LINK_XML, LINK_TURTLE);
        out.println();
        for (FunctionDoc.Reference reference : FunctionDoc.Reference.values()) {
            for (FunctionDoc.Type type : FunctionDoc.Type.values()) {
                boolean show = false;
                for (Function function : this.functions) {
                    if (function.reference != reference || !function.typeName.equals(type.getName()) || !function.type.equals((Object)type.getUri())) continue;
                    show = true;
                    break;
                }
                if (!show) continue;
                out.printf("## %s %ss", reference.getName(), type.getName());
                out.println();
                out.println("| Relation name | Description |");
                out.println("| :------------ |:------------|");
                for (Function function : this.functions) {
                    if (function.reference != reference || !function.typeName.equals(type.getName()) || !function.type.equals((Object)type.getUri())) continue;
                    out.printf("| %s:%s( %s ) | %s |%n", "mm", function.uri.stringValue().substring("http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#".length()), function.getPropertyString(", ", "*", "*"), function.description);
                }
                out.println();
            }
        }
        out.flush();
        out.close();
    }

    public void toLatex(File file) throws IOException {
        PrintWriter out = new PrintWriter(file);
        out.printf("The id number follow the scheme described in D4.2.1-SPEC (Table 3)", new Object[0]);
        out.println("The base IRI for the SPARQL-MM vocabulary is");
        out.print("\\texttt{");
        out.print("http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#");
        out.println("}.");
        out.printf("When abbreviating terms the suggested prefix is \\texttt{%s}.%n", "mm");
        out.println("Each function in this function set has a IRI constructed by appending a term name to the vocabulary IRI. For example:");
        out.print("\\texttt{");
        out.print(this.functions.get((int)0).uri.stringValue());
        out.println("}.");
        out.print("There are machine readable function description using \\textit{SPARQL Extension Description Vocabulary}\\footurl{http://www.ldodds.com/schemas/sparql-extension-description/} e.g. in ");
        out.printf("RDF/XML\\footurl{https://raw.githubusercontent.com/tkurz/sparql-mm/master/ns/1.0.0/function/%s}.%n", LINK_XML);
        out.println("%");
        for (FunctionDoc.Reference reference : FunctionDoc.Reference.values()) {
            for (FunctionDoc.Type type : FunctionDoc.Type.values()) {
                boolean show = false;
                for (Function function : this.functions) {
                    if (function.reference != reference || !function.typeName.equals(type.getName()) || !function.type.equals((Object)type.getUri())) continue;
                    show = true;
                    break;
                }
                if (!show) continue;
                out.printf("\\subsubsection*{%s %ss}\n", reference.getName(), type.getName());
                for (Function function : this.functions) {
                    if (function.reference != reference || !function.typeName.equals(type.getName()) || !function.type.equals((Object)type.getUri())) continue;
                    out.println("\\begin{tabular}{|p{3cm}|p{10cm}|}");
                    out.printf("\\hline Name & %s:%s\\\\\n\\hline Properties & %s \\\\\n\\hline Description & %s\\\\\n\\hline\n", "mm", function.uri.stringValue().substring("http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#".length()), function.getPropertyString(", ", "\\textit{", "}"), function.description);
                    out.println("\\end{tabular}");
                    out.println("\\vspace{0.3cm}");
                    out.println("\\newline");
                }
            }
        }
        out.flush();
        out.close();
    }

    public void toHTML(File file) throws IOException {
        PrintWriter out = new PrintWriter(file);
        out.printf("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"%s\"></head><body>\n", STYLE_URL);
        out.printf("<h1>%s</h1>%n", TITLE);
        out.println();
        out.println("<p>");
        out.printf("The IRI for this vocabulary is <code>%s</code>. ", "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#");
        out.printf("When abbreviating terms the suggested prefix is <code>%s</code>. ", "mm");
        out.printf("Each function in this function set has a IRI constructed by appending a term name to the vocabulary IRI. For example <code>%s</code>. ", this.functions.get((int)0).uri.stringValue());
        out.print("There are machine readable function description using <a href=\"http://www.ldodds.com/schemas/sparql-extension-description/\">SPARQL Extension Description Vocabulary]</a> in ");
        out.printf("<a href=\"%s\">RDF/XML</a> and <a href=\"%s\">TURTLE</a>.", LINK_XML, LINK_TURTLE);
        out.println("</p>");
        for (FunctionDoc.Reference reference : FunctionDoc.Reference.values()) {
            for (FunctionDoc.Type type : FunctionDoc.Type.values()) {
                boolean show = false;
                for (Function function : this.functions) {
                    if (function.reference != reference || !function.typeName.equals(type.getName()) || !function.type.equals((Object)type.getUri())) continue;
                    show = true;
                    break;
                }
                if (!show) continue;
                out.printf("<h2>%s %ss</h2>", reference.getName(), type.getName());
                out.println("<table>");
                out.println("<tr><th>Relation name</th><th>Description</th>");
                for (Function function : this.functions) {
                    if (function.reference != reference || !function.typeName.equals(type.getName()) || !function.type.equals((Object)type.getUri())) continue;
                    out.printf("<tr><td>%s:%s( %s )</td><td>%s</td>\n", "mm", function.uri.stringValue().substring("http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#".length()), function.getPropertyString(", ", "<i>", "</i>"), function.description);
                }
                out.println("</table>");
            }
        }
        out.flush();
        out.close();
    }

    class Function {
        String title;
        String description;
        IRI type;
        String typeName;
        IRI uri;
        FunctionDoc.Reference reference;
        Class[] properties;

        public Function(String className) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
            Class<?> clazz = Class.forName(className);
            if (clazz.getAnnotation(FunctionDoc.class) == null) {
                throw new IOException("Class " + className + " is not properly annotated for documentation.");
            }
            FunctionDoc doc = clazz.getAnnotation(FunctionDoc.class);
            org.eclipse.rdf4j.query.algebra.evaluation.function.Function function = (org.eclipse.rdf4j.query.algebra.evaluation.function.Function)clazz.newInstance();
            this.title = doc.title();
            this.description = doc.description();
            this.type = doc.type().getUri();
            this.uri = SimpleValueFactory.getInstance().createIRI(function.getURI());
            this.typeName = doc.type().getName();
            this.reference = doc.reference();
            this.properties = doc.properties();
            logger.debug("read doc for {}: uri:{}, title:{}, description:{}", new Object[]{className, this.uri.stringValue(), this.title, this.description});
        }

        public String getPropertyString(String join, final String wrapStart, final String wrapEnd) {
            return Joiner.on((String)join).join((Iterable)FluentIterable.from(Arrays.asList(this.properties)).transform((com.google.common.base.Function)new com.google.common.base.Function<Class, String>(){

                public String apply(Class aClass) {
                    return wrapStart + aClass.getSimpleName() + wrapEnd;
                }
            }));
        }
    }
}

