/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.OntopKGQuerySettings;
import it.unibz.inf.ontop.injection.OntopReformulationConfiguration;
import it.unibz.inf.ontop.injection.OntopReformulationSettings;
import it.unibz.inf.ontop.injection.ReformulationFactory;
import it.unibz.inf.ontop.injection.impl.OntopKGQueryConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopTranslationModule;
import it.unibz.inf.ontop.injection.impl.SpecificationLoader;
import it.unibz.inf.ontop.query.KGQueryFactory;
import it.unibz.inf.ontop.spec.OBDASpecification;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class OntopReformulationConfigurationImpl
extends OntopKGQueryConfigurationImpl
implements OntopReformulationConfiguration {
    private final OntopReformulationSettings settings;
    private final @Nullable SpecificationLoader specificationLoader;

    OntopReformulationConfigurationImpl(OntopReformulationSettings settings, OntopReformulationOptions options, SpecificationLoader specificationLoader) {
        super((OntopKGQuerySettings)settings, options.queryOptions);
        this.settings = settings;
        this.specificationLoader = specificationLoader;
    }

    OntopReformulationConfigurationImpl(OntopReformulationSettings settings, OntopReformulationOptions options, SpecificationLoader specificationLoader, Supplier<Injector> injectorSupplier) {
        super((OntopKGQuerySettings)settings, options.queryOptions, injectorSupplier);
        this.settings = settings;
        this.specificationLoader = specificationLoader;
    }

    OntopReformulationConfigurationImpl(OntopReformulationSettings settings, OntopReformulationOptions options) {
        super((OntopKGQuerySettings)settings, options.queryOptions);
        this.settings = settings;
        this.specificationLoader = null;
    }

    OntopReformulationConfigurationImpl(OntopReformulationSettings settings, OntopReformulationOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopKGQuerySettings)settings, options.queryOptions, injectorSupplier);
        this.settings = settings;
        this.specificationLoader = null;
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopTranslationModule(this)));
    }

    @Override
    public OntopReformulationSettings getSettings() {
        return this.settings;
    }

    protected final OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        if (this.specificationLoader == null) {
            throw new MissingOBDASpecificationObjectException();
        }
        return this.specificationLoader.load();
    }

    @Override
    public QueryReformulator loadQueryReformulator() throws OBDASpecificationException {
        ReformulationFactory reformulationFactory = (ReformulationFactory)this.getInjector().getInstance(ReformulationFactory.class);
        OBDASpecification obdaSpecification = this.loadSpecification();
        return reformulationFactory.create(obdaSpecification);
    }

    @Override
    public KGQueryFactory getKGQueryFactory() {
        return (KGQueryFactory)this.getInjector().getInstance(KGQueryFactory.class);
    }

    private static class MissingOBDASpecificationObjectException
    extends OntopInternalBugException {
        private MissingOBDASpecificationObjectException() {
            super("Bug: this configuration does not received an OBDA specification object nor a specification loaderand thus should have been constructed.\nPlease fix the configuration builder implementation.");
        }
    }

    protected static abstract class OntopReformulationBuilderMixin<B extends OntopReformulationConfiguration.Builder<B>>
    extends OntopKGQueryConfigurationImpl.OntopKGQueryBuilderMixin<B>
    implements OntopReformulationConfiguration.Builder<B> {
        private final DefaultOntopReformulationBuilderFragment<B> localBuilderFragment = new DefaultOntopReformulationBuilderFragment<B>(){

            @Override
            protected B self() {
                return (OntopReformulationConfiguration.Builder)this.self();
            }
        };

        OntopReformulationBuilderMixin() {
        }

        @Override
        public B enableExistentialReasoning(boolean enable) {
            return this.localBuilderFragment.enableExistentialReasoning(enable);
        }

        protected Properties generateProperties() {
            Properties properties = super.generateProperties();
            properties.putAll((Map<?, ?>)this.localBuilderFragment.generateProperties());
            return properties;
        }

        protected final OntopReformulationOptions generateReformulationOptions() {
            OntopKGQueryConfigurationImpl.OntopKGQueryOptions queryOptions = this.generateKGQueryOptions();
            return this.localBuilderFragment.generateReformulationOptions(queryOptions);
        }
    }

    static abstract class DefaultOntopReformulationBuilderFragment<B extends OntopReformulationConfiguration.Builder<B>>
    implements OntopReformulationConfiguration.OntopReformulationBuilderFragment<B> {
        private Optional<Boolean> existentialReasoning = Optional.empty();

        DefaultOntopReformulationBuilderFragment() {
        }

        protected abstract B self();

        @Override
        public B enableExistentialReasoning(boolean enable) {
            this.existentialReasoning = Optional.of(enable);
            return this.self();
        }

        protected Properties generateProperties() {
            Properties p = new Properties();
            this.existentialReasoning.ifPresent(r -> p.put("ontop.existentialReasoning", r));
            return p;
        }

        protected OntopReformulationOptions generateReformulationOptions(OntopKGQueryConfigurationImpl.OntopKGQueryOptions queryOptions) {
            return new OntopReformulationOptions(queryOptions);
        }
    }

    static class OntopReformulationOptions {
        final OntopKGQueryConfigurationImpl.OntopKGQueryOptions queryOptions;

        OntopReformulationOptions(OntopKGQueryConfigurationImpl.OntopKGQueryOptions queryOptions) {
            this.queryOptions = queryOptions;
        }
    }
}

