/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.CompatibleTreeWitnessSetIterator;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.DownwardSaturatedImmutableSet;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.QueryConnectedComponent;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.QueryFolding;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitness;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessGenerator;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessRewriterReasoner;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeWitnessSet
implements Iterable<ImmutableCollection<TreeWitness>> {
    private final List<TreeWitness> tws = new LinkedList<TreeWitness>();
    private final QueryConnectedComponent cc;
    private final CachedClassifiedTBoxWrapper cache;
    private List<TreeWitness> mergeable;
    private Queue<TreeWitness> delta;
    private Map<TreeWitness.TermCover, TreeWitness> twsCache;
    private static final Logger log = LoggerFactory.getLogger(TreeWitnessSet.class);

    private TreeWitnessSet(QueryConnectedComponent cc, TreeWitnessRewriterReasoner reasoner) {
        this.cc = cc;
        this.cache = new CachedClassifiedTBoxWrapper(reasoner);
    }

    public ImmutableList<TreeWitness> getTWs() {
        return ImmutableList.copyOf(this.tws);
    }

    public static TreeWitnessSet getTreeWitnesses(QueryConnectedComponent cc, TreeWitnessRewriterReasoner reasoner) {
        TreeWitnessSet treewitnesses = new TreeWitnessSet(cc, reasoner);
        if (!cc.isDegenerate()) {
            treewitnesses.computeTreeWitnesses();
        }
        return treewitnesses;
    }

    private void computeTreeWitnesses() {
        QueryFolding qf = new QueryFolding(this.cache);
        for (Object loop : this.cc.getQuantifiedVariables()) {
            ImmutableList<TreeWitnessGenerator> twg;
            QueryConnectedComponent.Edge edge;
            VariableOrGroundTerm v = ((QueryConnectedComponent.Loop)loop).getTerm();
            log.debug("QUANTIFIED VARIABLE {}", (Object)v);
            qf.newOneStepFolding(v);
            UnmodifiableIterator unmodifiableIterator = this.cc.getEdges().iterator();
            while (unmodifiableIterator.hasNext() && !((edge = (QueryConnectedComponent.Edge)unmodifiableIterator.next()).getTerm0().equals(v) ? !qf.extend(edge.getLoop1(), edge, (QueryConnectedComponent.Loop)loop) : edge.getTerm1().equals(v) && !qf.extend(edge.getLoop0(), edge, (QueryConnectedComponent.Loop)loop))) {
            }
            if (!qf.isValid() || (twg = this.getTreeWitnessGenerators(qf)).isEmpty()) continue;
            this.tws.add(qf.getTreeWitness(twg, (Collection<QueryConnectedComponent.Edge>)this.cc.getEdges()));
        }
        if (!this.tws.isEmpty()) {
            this.mergeable = new ArrayList<TreeWitness>();
            LinkedList<TreeWitness> working = new LinkedList<TreeWitness>();
            for (TreeWitness tw : this.tws) {
                if (!tw.isMergeable()) continue;
                working.add(tw);
                this.mergeable.add(tw);
            }
            this.delta = new LinkedList<TreeWitness>();
            this.twsCache = new HashMap<TreeWitness.TermCover, TreeWitness>();
            while (!working.isEmpty()) {
                TreeWitness tw;
                while (!working.isEmpty()) {
                    tw = (TreeWitness)working.poll();
                    qf.newQueryFolding(tw);
                    this.saturateTreeWitnesses(qf);
                }
                while (!this.delta.isEmpty()) {
                    tw = this.delta.poll();
                    this.tws.add(tw);
                    if (!tw.isMergeable()) continue;
                    working.add(tw);
                    this.mergeable.add(tw);
                }
            }
        }
        log.debug("TREE WITNESSES FOUND: {}", (Object)this.tws.size());
    }

    private void saturateTreeWitnesses(QueryFolding qf) {
        boolean saturated = true;
        for (QueryConnectedComponent.Edge edge : this.cc.getEdges()) {
            QueryConnectedComponent.Loop internalLoop;
            QueryConnectedComponent.Loop rootLoop;
            if (qf.canBeAttachedToAnInternalRoot(edge.getLoop0(), edge.getLoop1())) {
                rootLoop = edge.getLoop0();
                internalLoop = edge.getLoop1();
            } else {
                if (!qf.canBeAttachedToAnInternalRoot(edge.getLoop1(), edge.getLoop0())) continue;
                rootLoop = edge.getLoop1();
                internalLoop = edge.getLoop0();
            }
            log.debug("EDGE {} IS ADJACENT TO THE TREE WITNESS {}", (Object)edge, (Object)qf);
            if (qf.getRoots().contains(internalLoop)) {
                if (qf.extend(internalLoop, edge, rootLoop)) {
                    log.debug("    RE-ATTACHING A HANDLE {}", (Object)edge);
                    continue;
                }
                log.debug("    FAILED TO RE-ATTACH A HANDLE {}", (Object)edge);
                return;
            }
            saturated = false;
            VariableOrGroundTerm rootNewLiteral = rootLoop.getTerm();
            VariableOrGroundTerm internalNewLiteral = internalLoop.getTerm();
            for (TreeWitness tw : this.mergeable) {
                if (!tw.getRoots().contains((Object)rootNewLiteral) || !tw.getDomain().contains((Object)internalNewLiteral)) continue;
                log.debug("    ATTACHING A TREE WITNESS {}", (Object)tw);
                this.saturateTreeWitnesses(qf.extend(tw));
            }
            QueryFolding qf2 = new QueryFolding(qf);
            if (!qf2.extend(internalLoop, edge, rootLoop)) continue;
            log.debug("    ATTACHING A HANDLE {}", (Object)edge);
            this.saturateTreeWitnesses(qf2);
        }
        if (saturated && qf.hasRoot()) {
            if (!this.twsCache.containsKey(qf.getTerms())) {
                ImmutableList<TreeWitnessGenerator> twg = this.getTreeWitnessGenerators(qf);
                if (!twg.isEmpty()) {
                    TreeWitness tw = qf.getTreeWitness(twg, (Collection<QueryConnectedComponent.Edge>)this.cc.getEdges());
                    this.delta.add(tw);
                    this.twsCache.put(tw.getTerms(), tw);
                } else {
                    this.twsCache.put(qf.getTerms(), null);
                }
            } else {
                log.debug("TWS CACHE HIT {}", (Object)qf.getTerms());
            }
        }
    }

    private ImmutableList<TreeWitnessGenerator> getTreeWitnessGenerators(QueryFolding qf) {
        ImmutableList.Builder twg = ImmutableList.builder();
        log.debug("CHECKING WHETHER THE FOLDING {} CAN BE GENERATED: ", (Object)qf);
        for (TreeWitnessGenerator g : this.cache.reasoner.getTreeWitnessGenerators()) {
            DownwardSaturatedImmutableSet<ObjectPropertyExpression> subp = qf.getProperties();
            if (!subp.subsumes(g.getProperty())) {
                log.debug("      NEGATIVE PROPERTY CHECK {}", (Object)g.getProperty());
                continue;
            }
            log.debug("      POSITIVE PROPERTY CHECK {}", (Object)g.getProperty());
            DownwardSaturatedImmutableSet<ClassExpression> subc = qf.getInternalRootConcepts();
            if (!g.endPointEntails(subc)) {
                log.debug("        ENDTYPE TOO SPECIFIC: {} FOR {}", subc, (Object)g);
                continue;
            }
            log.debug("        ENDTYPE IS FINE: TOP FOR {}", (Object)g);
            boolean failed = false;
            for (TreeWitness tw : qf.getInteriorTreeWitnesses()) {
                if (!g.endPointEntailsAny((Collection<TreeWitnessGenerator>)tw.getGenerators())) {
                    log.debug("        ENDTYPE TOO SPECIFIC: {} FOR {}", (Object)tw, (Object)g);
                    failed = true;
                    break;
                }
                log.debug("        ENDTYPE IS FINE: {} FOR {}", (Object)tw, (Object)g);
            }
            if (failed) continue;
            twg.add((Object)g);
            log.debug("        OK");
        }
        return twg.build();
    }

    @Override
    public Iterator<ImmutableCollection<TreeWitness>> iterator() {
        return new CompatibleTreeWitnessSetIterator((ImmutableList<TreeWitness>)ImmutableList.copyOf(this.tws));
    }

    public Set<TreeWitnessGenerator> getGeneratorsOfDetachedCC() {
        HashSet<TreeWitnessGenerator> generators = new HashSet<TreeWitnessGenerator>();
        if (this.cc.isDegenerate()) {
            DownwardSaturatedImmutableSet<ClassExpression> subc = this.cache.getLoopConcepts(this.cc.getLoop().get());
            log.debug("DEGENERATE DETACHED COMPONENT: {}", (Object)this.cc);
            if (!subc.isBottom()) {
                for (TreeWitnessGenerator twg : this.cache.reasoner.getTreeWitnessGenerators()) {
                    if (twg.endPointEntails(subc)) {
                        log.debug("        ENDTYPE IS FINE: {} FOR {}", (Object)subc, (Object)twg);
                        generators.add(twg);
                        continue;
                    }
                    log.debug("        ENDTYPE TOO SPECIFIC: {} FOR {}", (Object)subc, (Object)twg);
                }
            }
        } else {
            for (TreeWitness tw : this.tws) {
                if (!tw.getDomain().containsAll(this.cc.getVariables())) continue;
                log.debug("TREE WITNESS {} COVERS THE QUERY", (Object)tw);
                DownwardSaturatedImmutableSet<ClassExpression> subc = this.cache.reasoner.getSubConcepts((Collection<DataAtom<RDFAtomPredicate>>)tw.getRootAtoms());
                if (subc.isBottom()) continue;
                for (TreeWitnessGenerator twg : this.cache.reasoner.getTreeWitnessGenerators()) {
                    if (twg.endPointEntails(subc)) {
                        log.debug("        ENDTYPE IS FINE: {} FOR {}", subc, (Object)twg);
                        if (twg.endPointEntailsAny((Collection<TreeWitnessGenerator>)tw.getGenerators())) {
                            log.debug("        ENDTYPE IS FINE: {} FOR {}", (Object)tw, (Object)twg);
                            generators.add(twg);
                            continue;
                        }
                        log.debug("        ENDTYPE TOO SPECIFIC: {} FOR {}", (Object)tw, (Object)twg);
                        continue;
                    }
                    log.debug("        ENDTYPE TOO SPECIFIC: {} FOR {}", subc, (Object)twg);
                }
            }
        }
        if (!generators.isEmpty()) {
            boolean saturated = false;
            while (!saturated) {
                saturated = true;
                for (TreeWitnessGenerator g : this.cache.reasoner.getTreeWitnessGenerators()) {
                    if (!g.endPointEntailsAny(generators) || !generators.add(g)) continue;
                    saturated = false;
                }
            }
        }
        return generators;
    }

    static class CachedClassifiedTBoxWrapper {
        private final Map<Map.Entry<VariableOrGroundTerm, VariableOrGroundTerm>, DownwardSaturatedImmutableSet<ObjectPropertyExpression>> propertiesCache = new HashMap<Map.Entry<VariableOrGroundTerm, VariableOrGroundTerm>, DownwardSaturatedImmutableSet<ObjectPropertyExpression>>();
        private final Map<VariableOrGroundTerm, DownwardSaturatedImmutableSet<ClassExpression>> conceptsCache = new HashMap<VariableOrGroundTerm, DownwardSaturatedImmutableSet<ClassExpression>>();
        private final TreeWitnessRewriterReasoner reasoner;

        private CachedClassifiedTBoxWrapper(TreeWitnessRewriterReasoner reasoner) {
            this.reasoner = reasoner;
        }

        public DownwardSaturatedImmutableSet<ClassExpression> getLoopConcepts(QueryConnectedComponent.Loop loop) {
            return this.conceptsCache.computeIfAbsent(loop.getTerm(), t -> this.reasoner.getSubConcepts((Collection<DataAtom<RDFAtomPredicate>>)loop.getAtoms()));
        }

        public DownwardSaturatedImmutableSet<ObjectPropertyExpression> getEdgeProperties(QueryConnectedComponent.Edge edge, VariableOrGroundTerm root, VariableOrGroundTerm nonroot) {
            return this.propertiesCache.computeIfAbsent(new AbstractMap.SimpleImmutableEntry<VariableOrGroundTerm, VariableOrGroundTerm>(root, nonroot), idx -> this.reasoner.getSubProperties((Collection<DataAtom<RDFAtomPredicate>>)edge.getBAtoms(), (Map.Entry<VariableOrGroundTerm, VariableOrGroundTerm>)idx));
        }
    }
}

