/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.DownwardSaturatedImmutableSet;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import java.util.Collection;

public class TreeWitnessGenerator {
    private final ObjectPropertyExpression property;
    private final DownwardSaturatedImmutableSet<ClassExpression> concepts;
    private final ImmutableSet<ClassExpression> maximalRepresentatives;

    public TreeWitnessGenerator(ObjectPropertyExpression property, DownwardSaturatedImmutableSet<ClassExpression> concepts, ImmutableSet<ClassExpression> maximalRepresentatives) {
        this.property = property;
        this.concepts = concepts;
        this.maximalRepresentatives = maximalRepresentatives;
    }

    public DownwardSaturatedImmutableSet<ClassExpression> getGeneratorConcepts() {
        return this.concepts;
    }

    public ImmutableSet<ClassExpression> getMaximalGeneratorRepresentatives() {
        return this.maximalRepresentatives;
    }

    public ObjectPropertyExpression getProperty() {
        return this.property;
    }

    public boolean endPointEntailsAny(Collection<TreeWitnessGenerator> twgs) {
        return twgs.stream().anyMatch(twg -> this.endPointEntails(twg.getGeneratorConcepts()));
    }

    public boolean endPointEntails(DownwardSaturatedImmutableSet<ClassExpression> s) {
        return s.subsumes((ClassExpression)this.property.getRange());
    }

    public String toString() {
        return "tw-generator E" + this.property.toString();
    }

    public int hashCode() {
        return this.property.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof TreeWitnessGenerator) {
            TreeWitnessGenerator o = (TreeWitnessGenerator)other;
            return this.property.equals(o.property);
        }
        return false;
    }
}

