/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableListIterator;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.DownwardSaturatedImmutableSet;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessGenerator;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import java.util.Collection;
import java.util.HashSet;

public class TreeWitness {
    private final TermCover terms;
    private final ImmutableSet<DataAtom<RDFAtomPredicate>> rootAtoms;
    private final ImmutableList<TreeWitnessGenerator> generators;
    private final DownwardSaturatedImmutableSet<ClassExpression> rootConcepts;

    public TreeWitness(ImmutableList<TreeWitnessGenerator> generators, TermCover terms, ImmutableSet<DataAtom<RDFAtomPredicate>> rootAtoms, DownwardSaturatedImmutableSet<ClassExpression> rootConcepts) {
        this.generators = generators;
        this.terms = terms;
        this.rootAtoms = rootAtoms;
        this.rootConcepts = rootConcepts;
    }

    public DownwardSaturatedImmutableSet<ClassExpression> getRootConcepts() {
        return this.rootConcepts;
    }

    public ImmutableSet<VariableOrGroundTerm> getRoots() {
        return this.terms.roots;
    }

    public boolean isMergeable() {
        return !this.rootConcepts.isBottom();
    }

    public ImmutableSet<VariableOrGroundTerm> getDomain() {
        return this.terms.domain;
    }

    public TermCover getTerms() {
        return this.terms;
    }

    public ImmutableList<TreeWitnessGenerator> getGenerators() {
        return this.generators;
    }

    public ImmutableSet<DataAtom<RDFAtomPredicate>> getRootAtoms() {
        return this.rootAtoms;
    }

    private static boolean isCompatible(TreeWitness tw1, TreeWitness tw2) {
        HashSet<VariableOrGroundTerm> commonTerms = new HashSet<VariableOrGroundTerm>((Collection<VariableOrGroundTerm>)tw1.getDomain());
        commonTerms.retainAll((Collection<?>)tw2.getDomain());
        return commonTerms.isEmpty() || tw1.getRoots().containsAll(commonTerms) && tw2.getRoots().containsAll(commonTerms);
    }

    public static boolean isCompatible(ImmutableList<TreeWitness> tws) {
        UnmodifiableListIterator i = tws.listIterator(tws.size());
        while (i.hasPrevious()) {
            TreeWitness tw0 = (TreeWitness)i.previous();
            UnmodifiableListIterator j = tws.listIterator();
            while (j.nextIndex() <= i.previousIndex()) {
                if (TreeWitness.isCompatible(tw0, (TreeWitness)j.next())) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "tree witness generated by " + this.generators + "\n    with domain " + this.terms + " and root atoms " + this.rootAtoms;
    }

    public static final class TermCover {
        private final ImmutableSet<VariableOrGroundTerm> domain;
        private final ImmutableSet<VariableOrGroundTerm> roots;

        public TermCover(ImmutableSet<VariableOrGroundTerm> domain, ImmutableSet<VariableOrGroundTerm> roots) {
            this.domain = domain;
            this.roots = roots;
        }

        public ImmutableSet<VariableOrGroundTerm> getDomain() {
            return this.domain;
        }

        public ImmutableSet<VariableOrGroundTerm> getRoots() {
            return this.roots;
        }

        public String toString() {
            return "tree witness domain " + this.domain + " with roots " + this.roots;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TermCover) {
                TermCover other = (TermCover)obj;
                return this.roots.equals(other.roots) && this.domain.equals(other.domain);
            }
            return false;
        }

        public int hashCode() {
            return this.roots.hashCode() ^ this.domain.hashCode();
        }
    }
}

