/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitness;
import it.unibz.inf.ontop.constraints.ImmutableCQ;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class QueryConnectedComponent {
    private final ImmutableList<Variable> variables;
    private final ImmutableList<Loop> quantifiedVariables;
    private final ImmutableList<Variable> freeVariables;
    private final ImmutableList<Edge> edges;
    private final Optional<Loop> loop;
    private final boolean noFreeTerms;

    private QueryConnectedComponent(ImmutableList<Edge> edges, ImmutableList<Loop> terms) {
        this.edges = edges;
        this.loop = this.isDegenerate() && !terms.isEmpty() ? Optional.of((Loop)terms.get(0)) : Optional.empty();
        this.variables = (ImmutableList)terms.stream().map(Loop::getTerm).filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toList());
        this.freeVariables = (ImmutableList)terms.stream().filter(l -> !l.isExistentialVariable() && l.getTerm() instanceof Variable).map(l -> (Variable)l.getTerm()).collect(ImmutableCollectors.toList());
        this.quantifiedVariables = (ImmutableList)terms.stream().filter(Loop::isExistentialVariable).collect(ImmutableCollectors.toList());
        this.noFreeTerms = terms.size() == this.variables.size() && this.freeVariables.isEmpty();
    }

    private static QueryConnectedComponent getConnectedComponent(List<Map.Entry<ImmutableSet<VariableOrGroundTerm>, Collection<DataAtom<RDFAtomPredicate>>>> pairs, Map<VariableOrGroundTerm, Loop> allLoops, ImmutableSet<VariableOrGroundTerm> seed, ImmutableSet<Variable> headVariables) {
        boolean expanded;
        ImmutableList.Builder ccEdges = ImmutableList.builder();
        HashSet<VariableOrGroundTerm> ccTerms = new HashSet<VariableOrGroundTerm>((Collection<VariableOrGroundTerm>)seed);
        do {
            expanded = false;
            Iterator<Map.Entry<ImmutableSet<VariableOrGroundTerm>, Collection<DataAtom<RDFAtomPredicate>>>> i = pairs.iterator();
            while (i.hasNext()) {
                Map.Entry<ImmutableSet<VariableOrGroundTerm>, Collection<DataAtom<RDFAtomPredicate>>> e = i.next();
                UnmodifiableIterator iterator = e.getKey().iterator();
                VariableOrGroundTerm t0 = (VariableOrGroundTerm)iterator.next();
                VariableOrGroundTerm t1 = (VariableOrGroundTerm)iterator.next();
                if (ccTerms.contains(t0)) {
                    ccTerms.add(t1);
                } else {
                    if (!ccTerms.contains(t1)) continue;
                    ccTerms.add(t0);
                }
                Loop l0 = allLoops.computeIfAbsent(t0, n -> new Loop((VariableOrGroundTerm)n, headVariables, (ImmutableList<DataAtom<RDFAtomPredicate>>)ImmutableList.of()));
                Loop l1 = allLoops.computeIfAbsent(t1, n -> new Loop((VariableOrGroundTerm)n, headVariables, (ImmutableList<DataAtom<RDFAtomPredicate>>)ImmutableList.of()));
                ccEdges.add((Object)new Edge(l0, l1, (ImmutableList<DataAtom<RDFAtomPredicate>>)ImmutableList.copyOf(e.getValue())));
                expanded = true;
                i.remove();
            }
        } while (expanded);
        ImmutableList.Builder ccLoops = ImmutableList.builder();
        for (VariableOrGroundTerm t : ccTerms) {
            Loop l = allLoops.remove(t);
            if (l == null) continue;
            ccLoops.add((Object)l);
        }
        return new QueryConnectedComponent((ImmutableList<Edge>)ccEdges.build(), (ImmutableList<Loop>)ccLoops.build());
    }

    public static ImmutableList<QueryConnectedComponent> getConnectedComponents(ImmutableCQ<RDFAtomPredicate> cq) {
        ImmutableSet answerVariables = cq.getAnswerVariables();
        ImmutableMultimap.Builder pz = ImmutableMultimap.builder();
        ImmutableMultimap.Builder lz = ImmutableMultimap.builder();
        for (DataAtom a : cq.getAtoms()) {
            boolean isClass = ((RDFAtomPredicate)a.getPredicate()).getClassIRI(a.getArguments()).isPresent();
            if (!isClass && !a.getTerm(0).equals(a.getTerm(2))) {
                pz.put((Object)ImmutableSet.of((Object)a.getTerm(0), (Object)a.getTerm(2)), (Object)a);
                continue;
            }
            lz.put((Object)a.getTerm(0), (Object)a);
        }
        HashMap<VariableOrGroundTerm, Loop> allLoops = new HashMap<VariableOrGroundTerm, Loop>();
        for (Map.Entry e : lz.build().asMap().entrySet()) {
            allLoops.put((VariableOrGroundTerm)e.getKey(), new Loop((VariableOrGroundTerm)e.getKey(), (ImmutableSet<Variable>)answerVariables, (ImmutableList<DataAtom<RDFAtomPredicate>>)ImmutableList.copyOf((Collection)((Collection)e.getValue()))));
        }
        ArrayList<Map.Entry<ImmutableSet<VariableOrGroundTerm>, Collection<DataAtom<RDFAtomPredicate>>>> pairs = new ArrayList<Map.Entry<ImmutableSet<VariableOrGroundTerm>, Collection<DataAtom<RDFAtomPredicate>>>>((Collection<Map.Entry<ImmutableSet<VariableOrGroundTerm>, Collection<DataAtom<RDFAtomPredicate>>>>)pz.build().asMap().entrySet());
        ImmutableList.Builder ccs = ImmutableList.builder();
        while (!pairs.isEmpty()) {
            ccs.add((Object)QueryConnectedComponent.getConnectedComponent(pairs, allLoops, (ImmutableSet<VariableOrGroundTerm>)((ImmutableSet)((Map.Entry)pairs.iterator().next()).getKey()), (ImmutableSet<Variable>)answerVariables));
        }
        while (!allLoops.isEmpty()) {
            ccs.add((Object)QueryConnectedComponent.getConnectedComponent(pairs, allLoops, (ImmutableSet<VariableOrGroundTerm>)ImmutableSet.of((Object)((VariableOrGroundTerm)allLoops.keySet().iterator().next())), (ImmutableSet<Variable>)answerVariables));
        }
        return ccs.build();
    }

    public Optional<Loop> getLoop() {
        return this.loop;
    }

    public boolean isDegenerate() {
        return this.edges.isEmpty();
    }

    public boolean hasNoFreeTerms() {
        return this.noFreeTerms;
    }

    public ImmutableList<Edge> getEdges() {
        return this.edges;
    }

    public ImmutableList<Variable> getVariables() {
        return this.variables;
    }

    public ImmutableList<Loop> getQuantifiedVariables() {
        return this.quantifiedVariables;
    }

    public ImmutableList<Variable> getFreeVariables() {
        return this.freeVariables;
    }

    static class Edge {
        private final Loop l0;
        private final Loop l1;
        private final ImmutableList<DataAtom<RDFAtomPredicate>> bAtoms;

        public Edge(Loop l0, Loop l1, ImmutableList<DataAtom<RDFAtomPredicate>> bAtoms) {
            this.bAtoms = bAtoms;
            this.l0 = l0;
            this.l1 = l1;
        }

        public Loop getLoop0() {
            return this.l0;
        }

        public Loop getLoop1() {
            return this.l1;
        }

        public VariableOrGroundTerm getTerm0() {
            return this.l0.term;
        }

        public VariableOrGroundTerm getTerm1() {
            return this.l1.term;
        }

        public ImmutableList<DataAtom<RDFAtomPredicate>> getBAtoms() {
            return this.bAtoms;
        }

        public ImmutableList<DataAtom<RDFAtomPredicate>> getAtoms() {
            return (ImmutableList)Stream.concat(this.bAtoms.stream(), Stream.concat(this.l0.getAtoms().stream(), this.l1.getAtoms().stream())).collect(ImmutableCollectors.toList());
        }

        public boolean isCoveredBy(TreeWitness tw) {
            return tw.getDomain().contains((Object)this.l0.term) && tw.getDomain().contains((Object)this.l1.term);
        }

        public String toString() {
            return "edge: {" + this.l0.term + ", " + this.l1.term + "}" + this.bAtoms + this.l0.atoms + this.l1.atoms;
        }
    }

    static class Loop {
        private final VariableOrGroundTerm term;
        private final ImmutableList<DataAtom<RDFAtomPredicate>> atoms;
        private final boolean isExistentialVariable;

        public Loop(VariableOrGroundTerm term, ImmutableSet<Variable> headVariables, ImmutableList<DataAtom<RDFAtomPredicate>> atoms) {
            this.term = term;
            this.isExistentialVariable = term instanceof Variable && !headVariables.contains((Object)term);
            this.atoms = atoms;
        }

        public VariableOrGroundTerm getTerm() {
            return this.term;
        }

        public ImmutableList<DataAtom<RDFAtomPredicate>> getAtoms() {
            return this.atoms;
        }

        public boolean isExistentialVariable() {
            return this.isExistentialVariable;
        }

        public String toString() {
            return "loop: {" + this.term + "}" + this.atoms;
        }

        public boolean equals(Object o) {
            if (o instanceof Loop) {
                return this.term.equals(((Loop)o).term);
            }
            return false;
        }

        public int hashCode() {
            return this.term.hashCode();
        }
    }
}

