/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import java.util.Optional;

public abstract class BasicGraphPatternTransformer
extends DefaultRecursiveIQTreeVisitingTransformer {
    @Inject
    protected BasicGraphPatternTransformer(IntermediateQueryFactory iqFactory) {
        super(iqFactory);
    }

    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList.Builder builderBGP = ImmutableList.builder();
        ImmutableList.Builder builderChildren = ImmutableList.builder();
        for (IQTree child : children) {
            if (child.getRootNode() instanceof IntensionalDataNode) {
                builderBGP.add((Object)((IntensionalDataNode)child));
                continue;
            }
            this.addTransformedBGP((ImmutableList.Builder<IQTree>)builderChildren, (ImmutableList<IntensionalDataNode>)builderBGP.build());
            builderBGP = ImmutableList.builder();
            builderChildren.add((Object)child.acceptTransformer((IQTreeVisitingTransformer)this));
        }
        this.addTransformedBGP((ImmutableList.Builder<IQTree>)builderChildren, (ImmutableList<IntensionalDataNode>)builderBGP.build());
        return this.formInnerJoin((ImmutableList<IQTree>)builderChildren.build(), rootNode.getOptionalFilterCondition());
    }

    public IQTree transformIntensionalData(IntensionalDataNode intensionalDataNode) {
        return this.formInnerJoin(this.transformBGP((ImmutableList<IntensionalDataNode>)ImmutableList.of((Object)intensionalDataNode)), Optional.empty());
    }

    private IQTree formInnerJoin(ImmutableList<IQTree> list, Optional<ImmutableExpression> filter) {
        switch (list.size()) {
            case 0: {
                throw new IllegalStateException("All triple patterns of BGP have been eliminated by the transformation");
            }
            case 1: {
                if (filter.isPresent()) {
                    return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(filter.get()), (IQTree)list.get(0));
                }
                return (IQTree)list.get(0);
            }
        }
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(filter), list);
    }

    private void addTransformedBGP(ImmutableList.Builder<IQTree> builderChildren, ImmutableList<IntensionalDataNode> currentBGP) {
        if (!currentBGP.isEmpty()) {
            builderChildren.addAll(this.transformBGP(currentBGP));
        }
    }

    protected abstract ImmutableList<IQTree> transformBGP(ImmutableList<IntensionalDataNode> var1);
}

