/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.reformulation.QueryCache;
import it.unibz.inf.ontop.answering.reformulation.impl.QuestQueryProcessor;
import it.unibz.inf.ontop.answering.reformulation.rewriting.QueryRewriter;
import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.TranslationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.GeneralStructuralAndSemanticIQOptimizer;
import it.unibz.inf.ontop.iq.planner.QueryPlanner;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.query.KGQueryFactory;
import it.unibz.inf.ontop.query.translation.KGQueryTranslator;
import it.unibz.inf.ontop.query.unfolding.QueryUnfolder;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToFullNativeQueryReformulator
extends QuestQueryProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToFullNativeQueryReformulator.class);
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @AssistedInject
    private ToFullNativeQueryReformulator(@Assisted OBDASpecification obdaSpecification, QueryCache queryCache, QueryUnfolder.Factory queryUnfolderFactory, TranslationFactory translationFactory, QueryRewriter queryRewriter, KGQueryFactory kgQueryFactory, KGQueryTranslator inputQueryTranslator, GeneralStructuralAndSemanticIQOptimizer generalOptimizer, QueryPlanner queryPlanner, QueryLogger.Factory queryLoggerFactory, QueryContext.Factory queryContextFactory, IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(obdaSpecification, queryCache, queryUnfolderFactory, translationFactory, queryRewriter, kgQueryFactory, inputQueryTranslator, generalOptimizer, queryPlanner, queryLoggerFactory, queryContextFactory);
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
    }

    @Override
    protected IQ generateExecutableQuery(IQ iq) throws OntopReformulationException {
        DistinctVariableOnlyDataAtom initialProjectionAtom = iq.getProjectionAtom();
        IQTree initialTree = iq.getTree();
        Substitution<ImmutableTerm> definitions = this.extractDefinitions(initialTree);
        ImmutableMap<Variable, RDFTermType> rdfTypes = this.extractRDFTypes(definitions);
        IQTree dbTree = this.replaceRDFByDBTerms(initialTree, rdfTypes);
        LOGGER.debug("Producing the native query string...");
        IQ dbIQ = this.iqFactory.createIQ(initialProjectionAtom, dbTree);
        IQTree nativeTree = this.datasourceQueryGenerator.generateSourceQuery(dbIQ, true).normalizeForOptimization().getTree();
        if (!(nativeTree instanceof NativeNode)) {
            throw new NotFullyTranslatableToNativeQueryException("the post-processing step could not be eliminated");
        }
        NativeNode nativeNode = (NativeNode)nativeTree;
        ImmutableMap dbTypeMap = nativeNode.getTypeMap();
        ConstructionNode postProcessingToRDFNode = this.iqFactory.createConstructionNode(nativeTree.getVariables(), (Substitution)nativeTree.getVariables().stream().collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getRDFFunctionalTerm((ImmutableTerm)this.termFactory.getConversion2RDFLexical(Optional.ofNullable((DBTermType)dbTypeMap.get(v)).orElseThrow(() -> new MinorOntopInternalBugException("Was expecting a type from the native node")), (ImmutableTerm)v, Optional.ofNullable((RDFTermType)rdfTypes.get(v)).orElseThrow(() -> new MinorOntopInternalBugException("Was expecting an RDF type"))), (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)rdfTypes.get(v))))));
        UnaryIQTree executableTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)postProcessingToRDFNode, nativeTree);
        IQ executableQuery = this.iqFactory.createIQ(dbIQ.getProjectionAtom(), (IQTree)executableTree);
        LOGGER.debug("Resulting native query:\n{}\n", (Object)executableQuery);
        return executableQuery;
    }

    private IQTree replaceRDFByDBTerms(IQTree tree, ImmutableMap<Variable, RDFTermType> rdfTypes) {
        if (rdfTypes.isEmpty()) {
            return tree;
        }
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof SliceNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)((SliceNode)rootNode), this.replaceRDFByDBTerms(tree, rdfTypes));
        }
        if (rootNode instanceof ConstructionNode) {
            ConstructionNode constructionNode = (ConstructionNode)rootNode;
            Substitution newSubstitution = constructionNode.getSubstitution().builder().transform(arg_0 -> rdfTypes.get(arg_0), this::replaceRDFByDBTerm).build();
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(constructionNode.getVariables(), newSubstitution), ((UnaryIQTree)tree).getChild());
        }
        throw new MinorOntopInternalBugException("Unexpected tree shape (proper exception should have already been thrown)");
    }

    private Substitution<ImmutableTerm> extractDefinitions(IQTree rdfTree) throws NotFullyTranslatableToNativeQueryException {
        QueryNode rootNode = rdfTree.getRootNode();
        if (rootNode instanceof ConstructionNode) {
            Substitution substitution = ((ConstructionNode)rootNode).getSubstitution();
            Sets.SetView missingVariables = Sets.difference((Set)rdfTree.getVariables(), (Set)substitution.getDomain());
            if (missingVariables.isEmpty()) {
                return substitution;
            }
            throw new NotFullyTranslatableToNativeQueryException(String.format("its variables %s are missing an independent definition", missingVariables));
        }
        if (rootNode instanceof SliceNode) {
            return this.extractDefinitions(((UnaryIQTree)rootNode).getChild());
        }
        if (rdfTree.getVariables().isEmpty()) {
            return this.substitutionFactory.getSubstitution();
        }
        throw new NotFullyTranslatableToNativeQueryException("was expected to have an extended projection at the top. IQ: " + rdfTree);
    }

    private ImmutableTerm replaceRDFByDBTerm(ImmutableTerm definition, RDFTermType rdfType) {
        if (definition instanceof Variable) {
            return definition;
        }
        if (definition instanceof RDFConstant) {
            return this.termFactory.getConversionFromRDFLexical2DB((ImmutableTerm)this.termFactory.getDBStringConstant(((RDFConstant)definition).getValue()), rdfType);
        }
        if (definition instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)definition).getFunctionSymbol() instanceof RDFTermFunctionSymbol) {
            return this.termFactory.getConversionFromRDFLexical2DB(((ImmutableFunctionalTerm)definition).getTerm(0), rdfType);
        }
        throw new MinorOntopInternalBugException("BI connector: unexpected tree shape (proper exception should have already been thrown)");
    }

    private ImmutableMap<Variable, RDFTermType> extractRDFTypes(Substitution<ImmutableTerm> definitions) throws NotFullyTranslatableToNativeQueryException {
        try {
            return definitions.builder().toMap((v, t) -> this.extractRDFType((Variable)v, (ImmutableTerm)t, definitions));
        }
        catch (NotFullyTranslatableToNativeQueryRuntimeException e) {
            throw new NotFullyTranslatableToNativeQueryException(e.getMessage());
        }
    }

    private RDFTermType extractRDFType(Variable variable, ImmutableTerm definition, Substitution<ImmutableTerm> definitions) {
        if (definition instanceof Variable) {
            Variable otherVariable = (Variable)definition;
            return this.extractRDFType(otherVariable, definitions.get(otherVariable), definitions);
        }
        if (definition instanceof RDFConstant) {
            return ((RDFConstant)definition).getType();
        }
        if (definition instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)definition).getFunctionSymbol() instanceof RDFTermFunctionSymbol) {
            ImmutableFunctionalTerm termTypeFunctionalTerm;
            ImmutableTerm termTypeTerm = (ImmutableTerm)((ImmutableFunctionalTerm)definition).getTerms().get(1);
            if (termTypeTerm instanceof RDFTermTypeConstant) {
                return ((RDFTermTypeConstant)termTypeTerm).getRDFTermType();
            }
            if (termTypeTerm instanceof ImmutableFunctionalTerm && (termTypeFunctionalTerm = (ImmutableFunctionalTerm)termTypeTerm).getFunctionSymbol() instanceof DBIfElseNullFunctionSymbol && termTypeFunctionalTerm.getTerm(1) instanceof RDFTermTypeConstant) {
                return ((RDFTermTypeConstant)termTypeFunctionalTerm.getTerm(1)).getRDFTermType();
            }
            throw new NotFullyTranslatableToNativeQueryRuntimeException(String.format("its variable %s may not be uniquely typed", variable));
        }
        throw new NotFullyTranslatableToNativeQueryRuntimeException(String.format("could not infer the unique type of its variable %s", variable));
    }

    private static class NotFullyTranslatableToNativeQueryRuntimeException
    extends RuntimeException {
        private NotFullyTranslatableToNativeQueryRuntimeException(String message) {
            super(message);
        }
    }

    protected static class NotFullyTranslatableToNativeQueryException
    extends OntopReformulationException {
        protected NotFullyTranslatableToNativeQueryException(String message) {
            super("Not fully translatable to a native query: " + message);
        }
    }
}

