/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.logging.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLFunctionSymbol;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;

@Singleton
public class QueryTemplateExtractor {
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final OntopModelSettings settings;

    @Inject
    protected QueryTemplateExtractor(CoreSingletons coreSingletons, OntopModelSettings settings) {
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.settings = settings;
    }

    Optional<QueryTemplateExtraction> extract(IQ iq) {
        IQTree initialIQTree = iq.getTree();
        QueryTemplateTransformer transformer = new QueryTemplateTransformer(this.coreSingletons, (ImmutableSet<Variable>)initialIQTree.getKnownVariables(), this.settings);
        IQTree newTree = transformer.transform(initialIQTree);
        ImmutableMap<GroundTerm, Variable> parameterMap = transformer.getParameterMap();
        if (parameterMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new QueryTemplateExtraction(this.iqFactory.createIQ(iq.getProjectionAtom(), newTree), parameterMap));
    }

    public static class QueryTemplateExtraction {
        private final IQ iq;
        private final ImmutableMap<GroundTerm, Variable> parameterMap;

        public QueryTemplateExtraction(IQ iq, ImmutableMap<GroundTerm, Variable> parameterMap) {
            this.iq = iq;
            this.parameterMap = parameterMap;
        }

        public IQ getIq() {
            return this.iq;
        }

        public ImmutableMap<GroundTerm, Variable> getParameterMap() {
            return this.parameterMap;
        }
    }

    protected static class QueryTemplateTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final VariableGenerator variableGenerator;
        private final Map<GroundTerm, Variable> parameterMap;
        private final AtomFactory atomFactory;
        private final OntopModelSettings settings;
        private final SPARQLFunctionSymbol sparqlEqFunctionSymbol;
        private final TermFactory termFactory;
        private final BooleanFunctionSymbol rdf2BoolFunctionsymbol;

        protected QueryTemplateTransformer(CoreSingletons coreSingletons, ImmutableSet<Variable> knownVariables, OntopModelSettings settings) {
            super(coreSingletons);
            this.atomFactory = coreSingletons.getAtomFactory();
            this.settings = settings;
            this.variableGenerator = coreSingletons.getCoreUtilsFactory().createVariableGenerator(knownVariables);
            this.parameterMap = Maps.newLinkedHashMap();
            this.termFactory = coreSingletons.getTermFactory();
            FunctionSymbolFactory functionSymbolFactory = coreSingletons.getFunctionSymbolFactory();
            this.sparqlEqFunctionSymbol = functionSymbolFactory.getRequiredSPARQLFunctionSymbol("=", 2);
            this.rdf2BoolFunctionsymbol = functionSymbolFactory.getRDF2DBBooleanFunctionSymbol();
        }

        public ImmutableMap<GroundTerm, Variable> getParameterMap() {
            return ImmutableMap.copyOf(this.parameterMap);
        }

        public IQTree transformIntensionalData(IntensionalDataNode dataNode) {
            DataAtom atom = dataNode.getProjectionAtom();
            if (atom.getPredicate() instanceof RDFAtomPredicate) {
                ImmutableList arguments;
                RDFAtomPredicate rdfAtomPredicate = (RDFAtomPredicate)atom.getPredicate();
                ImmutableList indexes = rdfAtomPredicate.getClassIRI(arguments = atom.getArguments()).map(iri -> ImmutableList.of((Object)0)).orElseGet(() -> ImmutableList.of((Object)0, (Object)2));
                ImmutableMap groundTermIndex = (ImmutableMap)indexes.stream().flatMap(i -> Optional.of((VariableOrGroundTerm)arguments.get(i.intValue())).filter(t -> t instanceof GroundTerm).map(t -> (GroundTerm)t).map(t -> Maps.immutableEntry((Object)i, (Object)t)).stream()).collect(ImmutableCollectors.toMap());
                if (groundTermIndex.isEmpty()) {
                    return dataNode;
                }
                groundTermIndex.values().forEach(t -> this.parameterMap.computeIfAbsent((GroundTerm)t, g -> this.variableGenerator.generateNewVariable()));
                ImmutableList newArguments = (ImmutableList)IntStream.range(0, arguments.size()).mapToObj(i -> Optional.ofNullable((GroundTerm)groundTermIndex.get((Object)i)).map(this.parameterMap::get).map(t -> t).orElseGet(() -> (VariableOrGroundTerm)arguments.get(i))).collect(ImmutableCollectors.toList());
                DataAtom newAtom = this.atomFactory.getDataAtom(atom.getPredicate(), newArguments);
                return this.iqFactory.createIntensionalDataNode(newAtom);
            }
            return dataNode;
        }

        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            IQTree newChild = child.acceptTransformer((IQTreeVisitingTransformer)this);
            Optional<ImmutableExpression> newCondition = this.transformFilterCondition(rootNode.getFilterCondition());
            FilterNode newRootNode = newCondition.map(arg_0 -> ((FilterNode)rootNode).changeFilterCondition(arg_0)).orElse(rootNode);
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newRootNode, newChild);
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            IQTree newLeft = leftChild.acceptTransformer((IQTreeVisitingTransformer)this);
            IQTree newRight = rightChild.acceptTransformer((IQTreeVisitingTransformer)this);
            Optional<LeftJoinNode> newCondition = rootNode.getOptionalFilterCondition().flatMap(this::transformFilterCondition);
            LeftJoinNode newRootNode = newCondition.map(c -> rootNode.changeOptionalFilterCondition(newCondition)).orElse(rootNode);
            return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)newRootNode, newLeft, newRight);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
            Optional<InnerJoinNode> newCondition = rootNode.getOptionalFilterCondition().flatMap(this::transformFilterCondition);
            InnerJoinNode newRootNode = newCondition.map(c -> rootNode.changeOptionalFilterCondition(newCondition)).orElse(rootNode);
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)newRootNode, newChildren);
        }

        protected Optional<ImmutableExpression> transformFilterCondition(ImmutableExpression filterCondition) {
            if (this.settings.isTestModeEnabled()) {
                return Optional.empty();
            }
            return this.termFactory.getConjunction(filterCondition.flattenAND().map(this::transformSubExpression)).filter(e -> !e.equals(filterCondition));
        }

        private ImmutableExpression transformSubExpression(ImmutableExpression expression) {
            ImmutableFunctionalTerm subFunctionalTerm;
            ImmutableTerm subTerm;
            if (expression.getFunctionSymbol().equals(this.rdf2BoolFunctionsymbol) && (subTerm = expression.getTerm(0)) instanceof ImmutableFunctionalTerm && (subFunctionalTerm = (ImmutableFunctionalTerm)subTerm).getFunctionSymbol().equals(this.sparqlEqFunctionSymbol)) {
                ImmutableList initialTerms = subFunctionalTerm.getTerms();
                ImmutableList newTerms = (ImmutableList)initialTerms.stream().map(t -> t instanceof GroundTerm ? (ImmutableTerm)this.parameterMap.computeIfAbsent((GroundTerm)t, g -> this.variableGenerator.generateNewVariable()) : t).collect(ImmutableCollectors.toList());
                return newTerms.equals((Object)initialTerms) ? expression : this.termFactory.getImmutableExpression(this.rdf2BoolFunctionsymbol, new ImmutableTerm[]{this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.sparqlEqFunctionSymbol, newTerms)});
            }
            return expression;
        }
    }
}

