/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.logging.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.logging.impl.ClassAndPropertyExtractor;
import it.unibz.inf.ontop.answering.logging.impl.QueryTemplateExtractor;
import it.unibz.inf.ontop.answering.logging.impl.RelationNameExtractor;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.injection.OntopReformulationSettings;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.ontology.InconsistentOntologyException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryLoggerImpl
implements QueryLogger {
    public static final String OUTPUT_STREAM_JSON_ERROR = "Problem with the output stream for the query logger. Disabled";
    public static final String EXECUTION_BEFORE_UNBLOCKING_DURATION_KEY = "executionBeforeUnblockingDuration";
    protected static final String REFORMATION_EXC_MSG = "query:exception-reformulation";
    protected static final String EVALUATION_EXC_MSG = "query:exception-evaluation";
    protected static final String CONNECTION_EXC_MSG = "query:exception-connection";
    protected static final String CONVERSION_EXC_MSG = "query:exception-conversion";
    protected static final String SPARQL_QUERY_KEY = "sparqlQuery";
    protected static final String REFORMULATED_QUERY_KEY = "reformulatedQuery";
    protected static final String TIMESTAMP_KEY = "@timestamp";
    protected static final String MESSAGE_KEY = "message";
    protected static final String QUERY_ID_KEY = "queryId";
    protected static final String APPLICATION_KEY = "application";
    protected static final String PAYLOAD_KEY = "payload";
    public static final String QUERY_RESULT_SET_UNBLOCKED = "query:result-set-unblocked";
    public static final String QUERY_LAST_RESULT_FETCHED = "query:last-result-fetched";
    public static final String MERGED_MSG = "query:all";
    public static final String EXECUTION_AND_FETCHING_DURATION_KEY = "executionAndFetchingDuration";
    public static final String RESULT_COUNT_KEY = "resultCount";
    public static final String TOTAL_DURATION_KEY = "totalDuration";
    public static final String EXCEPTION_KEY = "exception";
    public static final String REFORMULATION_DURATION_KEY = "reformulationDuration";
    public static final String REFORMULATION_CACHE_HIT_KEY = "reformulationCacheHit";
    public static final String QUERY_REFORMULATED = "query:reformulated";
    protected static final String CLASSES_KEY = "classesUsedInQuery";
    protected static final String PROPERTIES_KEY = "propertiesUsedInQuery";
    protected static final String TABLES_KEY = "tables";
    protected static final String HTTP_HEADERS_KEY = "httpHeaders";
    protected static final String QUERY_TEMPLATE_KEY = "extractedQueryTemplate";
    protected static final String HASH_KEY = "hash";
    protected static final String PARAMETERS_KEY = "parameters";
    protected static final String PREDEFINED_KEY = "predefined";
    protected static final String PREDEFINED_QUERY_KEY = "queryId";
    protected static final String BINDINGS_KEY = "bindings";
    protected static final String USER_KEY = "user";
    protected static final String GROUPS_KEY = "groups";
    protected static final String ROLES_KEY = "roles";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static final Logger REGULAR_LOGGER = LoggerFactory.getLogger(QueryLoggerImpl.class);
    private final UUID queryId;
    private final long creationTime;
    private final PrintStream outputStream;
    private final ImmutableMap<String, String> httpHeaders;
    private final OntopReformulationSettings settings;
    private final boolean disabled;
    private final String applicationName;
    private final JsonFactory jsonFactory;
    private final boolean isDecompositionEnabled;
    private final boolean isMergingEnabled;
    private long reformulationTime;
    private long unblockedResulSetTime;
    private final ClassAndPropertyExtractor classAndPropertyExtractor;
    private final RelationNameExtractor relationNameExtractor;
    private final QueryTemplateExtractor queryTemplateExtractor;
    private @Nullable ImmutableSet<IRI> classes;
    private @Nullable ImmutableSet<IRI> properties;
    private @Nullable ImmutableSet<String> relationNames;
    private @Nullable String sparqlQueryString;
    private @Nullable QueryTemplateExtractor.QueryTemplateExtraction queryTemplate;
    private @Nullable IQ reformulatedQuery;
    private @Nullable Boolean wasReformulationCached;
    private @Nullable String predefinedQueryId;
    private @Nullable ImmutableMap<String, String> bindings;

    @AssistedInject
    protected QueryLoggerImpl(@Assisted ImmutableMap<String, String> httpHeaders, OntopReformulationSettings settings, ClassAndPropertyExtractor classAndPropertyExtractor, RelationNameExtractor relationNameExtractor, QueryTemplateExtractor queryTemplateExtractor) {
        this(System.out, httpHeaders, settings, classAndPropertyExtractor, relationNameExtractor, queryTemplateExtractor);
    }

    protected QueryLoggerImpl(PrintStream outputStream, ImmutableMap<String, String> httpHeaders, OntopReformulationSettings settings, ClassAndPropertyExtractor classAndPropertyExtractor, RelationNameExtractor relationNameExtractor, QueryTemplateExtractor queryTemplateExtractor) {
        this.outputStream = outputStream;
        this.httpHeaders = httpHeaders;
        this.settings = settings;
        this.classAndPropertyExtractor = classAndPropertyExtractor;
        this.relationNameExtractor = relationNameExtractor;
        this.queryTemplateExtractor = queryTemplateExtractor;
        this.queryId = UUID.randomUUID();
        this.creationTime = System.currentTimeMillis();
        this.applicationName = settings.getApplicationName();
        this.reformulationTime = -1L;
        this.unblockedResulSetTime = -1L;
        this.jsonFactory = new JsonFactory();
        this.disabled = !settings.isQueryLoggingEnabled();
        this.isDecompositionEnabled = settings.isQueryLoggingDecompositionEnabled();
        this.isMergingEnabled = !this.isDecompositionEnabled || !settings.areQueryLoggingDecompositionAndMergingMutuallyExclusive();
    }

    @Override
    public void declareReformulationFinishedAndSerialize(IQ reformulatedQuery, boolean wasCached) {
        if (this.disabled) {
            return;
        }
        this.reformulationTime = System.currentTimeMillis();
        if (this.isDecompositionEnabled) {
            StringWriter stringWriter = new StringWriter();
            try (JsonGenerator js = this.jsonFactory.createGenerator((Writer)stringWriter);){
                js.writeStartObject();
                js.writeStringField(TIMESTAMP_KEY, this.serializeTimestamp(System.currentTimeMillis()));
                js.writeStringField(MESSAGE_KEY, QUERY_REFORMULATED);
                js.writeStringField(APPLICATION_KEY, this.applicationName);
                js.writeObjectFieldStart(PAYLOAD_KEY);
                js.writeStringField("queryId", this.queryId.toString());
                this.writeReformulationSpecificFields(reformulatedQuery, wasCached, js);
                js.writeEndObject();
                js.writeEndObject();
            }
            catch (IOException ex) {
                REGULAR_LOGGER.error(OUTPUT_STREAM_JSON_ERROR + ex);
            }
            this.outputStream.println(stringWriter);
        }
        if (this.isMergingEnabled) {
            this.reformulatedQuery = reformulatedQuery;
            this.wasReformulationCached = wasCached;
        }
    }

    protected void writeReformulationSpecificFields(IQ reformulatedQuery, boolean wasCached, JsonGenerator js) throws IOException {
        if (this.classes != null) {
            js.writeArrayFieldStart(CLASSES_KEY);
            for (IRI klass : this.classes) {
                js.writeString(klass.getIRIString());
            }
            js.writeEndArray();
        }
        if (this.properties != null) {
            js.writeArrayFieldStart(PROPERTIES_KEY);
            for (IRI p : this.properties) {
                js.writeString(p.getIRIString());
            }
            js.writeEndArray();
        }
        if (this.relationNames != null) {
            js.writeArrayFieldStart(TABLES_KEY);
            for (String n : this.relationNames) {
                js.writeString(n);
            }
            js.writeEndArray();
        }
        js.writeNumberField(REFORMULATION_DURATION_KEY, this.reformulationTime - this.creationTime);
        js.writeBooleanField(REFORMULATION_CACHE_HIT_KEY, wasCached);
        this.writeUserInfo(js);
        this.writeHttpHeaders(js);
        this.writeQueryTemplateExtraction(js);
        this.writePredefinedQueryInfo(js);
        if (this.sparqlQueryString != null) {
            js.writeStringField(SPARQL_QUERY_KEY, this.sparqlQueryString);
        }
        if (this.settings.isReformulatedQueryIncludedIntoQueryLog()) {
            js.writeStringField(REFORMULATED_QUERY_KEY, reformulatedQuery.toString());
        }
    }

    private void writeUserInfo(JsonGenerator js) throws IOException {
        if (this.settings.isUserInfoIncludedIntoQueryLog()) {
            String roles;
            String groups;
            String user = (String)this.httpHeaders.get((Object)"x-user");
            if (user != null) {
                js.writeStringField(USER_KEY, user);
            }
            if ((groups = (String)this.httpHeaders.get((Object)"x-groups")) != null) {
                js.writeStringField(GROUPS_KEY, groups);
            }
            if ((roles = (String)this.httpHeaders.get((Object)"x-roles")) != null) {
                js.writeStringField(ROLES_KEY, roles);
            }
        }
    }

    private void writeHttpHeaders(JsonGenerator js) throws IOException {
        js.writeObjectFieldStart(HTTP_HEADERS_KEY);
        ImmutableSet<String> namesToLog = this.settings.getHttpHeaderNamesToLog();
        for (Map.Entry e : this.httpHeaders.entrySet()) {
            String normalizedKey = ((String)e.getKey()).toLowerCase();
            if (!namesToLog.contains((Object)normalizedKey)) continue;
            js.writeStringField(normalizedKey, (String)e.getValue());
        }
        js.writeEndObject();
    }

    private void writeQueryTemplateExtraction(JsonGenerator js) throws IOException {
        if (this.queryTemplate == null) {
            return;
        }
        js.writeObjectFieldStart(QUERY_TEMPLATE_KEY);
        String iqHash = Hashing.sha256().hashString((CharSequence)this.queryTemplate.getIq().toString(), StandardCharsets.UTF_8).toString();
        js.writeStringField(HASH_KEY, iqHash);
        js.writeObjectFieldStart(PARAMETERS_KEY);
        for (Map.Entry e : this.queryTemplate.getParameterMap().entrySet()) {
            js.writeStringField(((Variable)e.getValue()).toString(), ((GroundTerm)e.getKey()).toString());
        }
        js.writeEndObject();
        js.writeEndObject();
    }

    private void writePredefinedQueryInfo(JsonGenerator js) throws IOException {
        if (this.predefinedQueryId == null || this.bindings == null) {
            return;
        }
        js.writeObjectFieldStart(PREDEFINED_KEY);
        js.writeStringField("queryId", this.predefinedQueryId);
        js.writeObjectFieldStart(BINDINGS_KEY);
        for (Map.Entry e : this.bindings.entrySet()) {
            js.writeStringField((String)e.getKey(), (String)e.getValue());
        }
        js.writeEndObject();
        js.writeEndObject();
    }

    @Override
    public void declareResultSetUnblockedAndSerialize() {
        if (this.disabled) {
            return;
        }
        this.unblockedResulSetTime = System.currentTimeMillis();
        if (this.isDecompositionEnabled) {
            StringWriter stringWriter = new StringWriter();
            try (JsonGenerator js = this.jsonFactory.createGenerator((Writer)stringWriter);){
                js.writeStartObject();
                js.writeStringField(TIMESTAMP_KEY, this.serializeTimestamp(this.unblockedResulSetTime));
                js.writeStringField(MESSAGE_KEY, QUERY_RESULT_SET_UNBLOCKED);
                js.writeStringField(APPLICATION_KEY, this.applicationName);
                js.writeObjectFieldStart(PAYLOAD_KEY);
                js.writeStringField("queryId", this.queryId.toString());
                this.writeResultSetUnblockedSpecificFields(js);
                js.writeEndObject();
                js.writeEndObject();
            }
            catch (IOException e) {
                REGULAR_LOGGER.error(OUTPUT_STREAM_JSON_ERROR + e);
                return;
            }
            this.outputStream.println(stringWriter);
        }
    }

    protected void writeResultSetUnblockedSpecificFields(JsonGenerator js) throws IOException {
        if (this.reformulationTime != -1L) {
            js.writeNumberField(EXECUTION_BEFORE_UNBLOCKING_DURATION_KEY, this.unblockedResulSetTime - this.reformulationTime);
        }
    }

    @Override
    public void declareLastResultRetrievedAndSerialize(long resultCount) {
        if (this.disabled) {
            return;
        }
        long lastResultFetchedTime = System.currentTimeMillis();
        if (this.unblockedResulSetTime == -1L) {
            throw new IllegalStateException("Result set should have been declared as unblocked");
        }
        if (this.isDecompositionEnabled) {
            StringWriter stringWriter = new StringWriter();
            try (JsonGenerator js = this.jsonFactory.createGenerator((Writer)stringWriter);){
                js.writeStartObject();
                js.writeStringField(TIMESTAMP_KEY, this.serializeTimestamp(lastResultFetchedTime));
                js.writeStringField(MESSAGE_KEY, QUERY_LAST_RESULT_FETCHED);
                js.writeStringField(APPLICATION_KEY, this.applicationName);
                js.writeObjectFieldStart(PAYLOAD_KEY);
                js.writeStringField("queryId", this.queryId.toString());
                this.writeLastResultRetrievedSpecificFields(js, lastResultFetchedTime, resultCount);
                js.writeEndObject();
                js.writeEndObject();
            }
            catch (IOException e) {
                REGULAR_LOGGER.error(OUTPUT_STREAM_JSON_ERROR + e);
            }
            this.outputStream.println(stringWriter);
        }
        if (this.isMergingEnabled) {
            this.serializeMergedMessage(lastResultFetchedTime, resultCount);
        }
    }

    protected void writeLastResultRetrievedSpecificFields(JsonGenerator js, long lastResultFetchedTime, long resultCount) throws IOException {
        if (this.reformulationTime != -1L) {
            js.writeNumberField(EXECUTION_AND_FETCHING_DURATION_KEY, lastResultFetchedTime - this.reformulationTime);
        }
        js.writeNumberField(TOTAL_DURATION_KEY, lastResultFetchedTime - this.creationTime);
        js.writeNumberField(RESULT_COUNT_KEY, resultCount);
    }

    @Override
    public void declareReformulationException(OntopReformulationException e) {
        this.declareException((Exception)((Object)e), REFORMATION_EXC_MSG);
    }

    @Override
    public void declareEvaluationException(Exception e) {
        this.declareException(e, EVALUATION_EXC_MSG);
    }

    @Override
    public void declareConnectionException(Exception e) {
        this.declareException(e, CONNECTION_EXC_MSG);
    }

    @Override
    public void declareConversionException(InconsistentOntologyException e) {
        this.declareException((Exception)e, CONVERSION_EXC_MSG);
    }

    @Override
    public void setSparqlQuery(String sparqlQuery) {
        if (this.disabled || !this.settings.isSparqlQueryIncludedIntoQueryLog()) {
            return;
        }
        if (this.sparqlQueryString != null) {
            throw new IllegalStateException("Already specified SPARQL query");
        }
        this.sparqlQueryString = sparqlQuery;
    }

    @Override
    public void setSparqlIQ(IQ sparqlIQ) {
        if (this.disabled) {
            return;
        }
        if (this.settings.areClassesAndPropertiesIncludedIntoQueryLog()) {
            ClassAndPropertyExtractor.ClassesAndProperties classesAndProperties = this.classAndPropertyExtractor.extractClassesAndProperties(sparqlIQ);
            this.classes = classesAndProperties.getClasses();
            this.properties = classesAndProperties.getProperties();
        }
        if (this.settings.isQueryTemplateExtractionEnabled()) {
            Optional<QueryTemplateExtractor.QueryTemplateExtraction> extraction = this.queryTemplateExtractor.extract(sparqlIQ);
            extraction.ifPresent(e -> {
                this.queryTemplate = e;
            });
        }
    }

    @Override
    public void setPlannedQuery(IQ plannedQuery) {
        if (this.disabled || !this.settings.areTablesIncludedIntoQueryLog()) {
            return;
        }
        this.relationNames = this.relationNameExtractor.extractRelationNames(plannedQuery);
    }

    @Override
    public void setPredefinedQuery(String queryId, ImmutableMap<String, String> bindings) {
        if (this.disabled) {
            return;
        }
        this.predefinedQueryId = queryId;
        this.bindings = bindings;
    }

    protected void declareException(Exception e, String exceptionType) {
        if (this.disabled) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        try (JsonGenerator js = this.jsonFactory.createGenerator((Writer)stringWriter);){
            js.writeStartObject();
            js.writeStringField(TIMESTAMP_KEY, this.serializeTimestamp(System.currentTimeMillis()));
            js.writeStringField(MESSAGE_KEY, exceptionType);
            js.writeStringField(APPLICATION_KEY, this.applicationName);
            js.writeObjectFieldStart(PAYLOAD_KEY);
            js.writeStringField("queryId", this.queryId.toString());
            js.writeStringField(EXCEPTION_KEY, e.getMessage());
            if (this.sparqlQueryString != null) {
                js.writeStringField(SPARQL_QUERY_KEY, this.sparqlQueryString);
            }
            if (this.reformulatedQuery != null) {
                js.writeStringField(REFORMULATED_QUERY_KEY, this.reformulatedQuery.toString());
            }
            js.writeEndObject();
            js.writeEndObject();
        }
        catch (IOException ex) {
            REGULAR_LOGGER.error(OUTPUT_STREAM_JSON_ERROR + ex);
        }
        this.outputStream.println(stringWriter);
    }

    protected String serializeTimestamp(long time) {
        return DATE_FORMAT.format(new Timestamp(time));
    }

    protected void serializeMergedMessage(long lastResultFetchedTime, long resultCount) {
        StringWriter stringWriter = new StringWriter();
        try (JsonGenerator js = this.jsonFactory.createGenerator((Writer)stringWriter);){
            js.writeStartObject();
            js.writeStringField(TIMESTAMP_KEY, this.serializeTimestamp(lastResultFetchedTime));
            js.writeStringField(MESSAGE_KEY, MERGED_MSG);
            js.writeStringField(APPLICATION_KEY, this.applicationName);
            js.writeObjectFieldStart(PAYLOAD_KEY);
            js.writeStringField("queryId", this.queryId.toString());
            if (this.reformulatedQuery != null) {
                this.writeReformulationSpecificFields(this.reformulatedQuery, this.wasReformulationCached, js);
            }
            this.writeResultSetUnblockedSpecificFields(js);
            this.writeLastResultRetrievedSpecificFields(js, lastResultFetchedTime, resultCount);
            js.writeEndObject();
            js.writeEndObject();
        }
        catch (IOException e) {
            REGULAR_LOGGER.error(OUTPUT_STREAM_JSON_ERROR + e);
        }
        this.outputStream.println(stringWriter);
    }
}

