/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.mcp.server;

import com.ontotext.forest.core.SimilarityIndexesUtil;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.tools.AutocompleteIriDiscoveryTool;
import com.ontotext.forest.gpt.ttyg.tools.FTSSearchTool;
import com.ontotext.forest.gpt.ttyg.tools.IRIDiscoveryTool;
import com.ontotext.forest.gpt.ttyg.tools.RetrievalSearchTool;
import com.ontotext.forest.gpt.ttyg.tools.SPARQLQueryTool;
import com.ontotext.forest.gpt.ttyg.tools.SimilaritySearchTool;
import com.ontotext.forest.mcp.server.MCPToolExecutionException;
import com.ontotext.forest.security.utils.SecurityUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McpToolsRegistry {
    private static final String DEFAULT_EXTRACT_ONTOLOGY_QUERY = "PREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX sesame: <http://www.openrdf.org/schema/sesame#>\n\nSELECT DISTINCT ?s ?p ?o ?g\nWHERE {\n  {\n    GRAPH ?g {\n      {\n        VALUES ?p { rdf:type rdfs:subClassOf rdfs:subPropertyOf\n                    owl:equivalentClass owl:equivalentProperty\n                    owl:inverseOf rdfs:domain rdfs:range }\n        ?s ?p ?o .\n      }\n      UNION\n      {\n        VALUES ?o { owl:Class owl:ObjectProperty owl:DatatypeProperty\n                    owl:AnnotationProperty rdfs:Class rdf:Property }\n        ?s ?p ?o .\n      }\n    }\n  }\n  UNION\n  {\n    {\n      VALUES ?p { rdf:type rdfs:subClassOf rdfs:subPropertyOf\n                  owl:equivalentClass owl:equivalentProperty\n                  owl:inverseOf rdfs:domain rdfs:range }\n      ?s ?p ?o .\n    }\n    UNION\n    {\n      VALUES ?o { owl:Class owl:ObjectProperty owl:DatatypeProperty\n                  owl:AnnotationProperty rdfs:Class rdf:Property }\n      ?s ?p ?o .\n    }\n    BIND(IRI(\"sesame:nil\") AS ?g)\n  }\n}";
    private static final String REPOSITORY_ID_TOOL_PARAM_DESCRIPTION_SUFFIX = " This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.";
    private static final String REPOSITORY_ID_TOOL_PARAM_DESCRIPTION = "The name of the GraphDB repository to query. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.";
    public static final String PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE = "Parameter '%s' is required";
    public static final String REPOSITORY_ID = "repositoryId";
    private final SemanticDataManagement dataManagement;

    @Autowired
    public McpToolsRegistry(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }

    @Tool(name="fts_search", description="Query GraphDB by full-text search and return a subgraph of RDF triples.")
    public String executeFts(@ToolParam(description="FTS search query") String query, @ToolParam(required=false, description="Limit the maximum number of triples returned by Full-text search.The default value is automatic and determined at runtime. If not sure leave the default value") Integer limit, @ToolParam(description="The name of the GraphDB repository to query. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.") String repositoryId) {
        String string;
        block9: {
            SecurityUtils.checkRepositoryAccess((String)Objects.requireNonNull(repositoryId, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, REPOSITORY_ID)), (boolean)false);
            RepositoryConnection conn = this.getRepositoryConnection(repositoryId);
            try {
                FTSSearchTool ftsTool = new FTSSearchTool();
                if (limit != null) {
                    ftsTool.setLimit(limit);
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("query", query);
                string = ftsTool.call(params, new ToolCallContext(conn)).getOutput();
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapExceptionIfNeeded(e);
                }
            }
            conn.close();
        }
        return string;
    }

    @Tool(name="iri_discovery_search", description="Discovery IRIs by full-text search in labels.")
    public String executeIRIDiscovery(@ToolParam(description="FTS search query") String query, @ToolParam(description="The name of the GraphDB repository to query. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.") String repositoryId) {
        String string;
        block8: {
            SecurityUtils.checkRepositoryAccess((String)Objects.requireNonNull(repositoryId, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, REPOSITORY_ID)), (boolean)false);
            RepositoryConnection conn = this.getRepositoryConnection(repositoryId);
            try {
                IRIDiscoveryTool iriDiscoveryTool = new IRIDiscoveryTool();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("query", query);
                string = iriDiscoveryTool.call(params, new ToolCallContext(conn)).getOutput();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapExceptionIfNeeded(e);
                }
            }
            conn.close();
        }
        return string;
    }

    @Tool(name="retrieval_search", description="Query GraphDB by full-text search and return a textual representation of RDF triples.")
    public String executeRetrievalSearch(@ToolParam(description="Array of queries to be processed") String queries, @ToolParam(description="The ChatGPT Retrieval Connector instance to use for CtatGPT retrieval queries.") String connectorInstance, @ToolParam(description="This template may use a filter with the available metadata fields in your ChatGPT Retrieval Connector instance. The default value contains only the query part and uses no metadata fields. Please consult the documentation for more information.") String queryTemplate, @ToolParam(required=false, description="Limit the maximum number of text chunks returned by the ChatGPT Retrieval Connector. The default value is automatic and determined at runtime. If not sure, leave the default value.") Integer limit, @ToolParam(description="The name of the GraphDB repository to query. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.") String repositoryId) {
        String string;
        block9: {
            SecurityUtils.checkRepositoryAccess((String)Objects.requireNonNull(repositoryId, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, REPOSITORY_ID)), (boolean)false);
            RepositoryConnection conn = this.getRepositoryConnection(repositoryId);
            try {
                RetrievalSearchTool retrievalTool = new RetrievalSearchTool();
                retrievalTool.setConnectorInstance(Objects.requireNonNull(connectorInstance, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, "connectorInstance")));
                retrievalTool.setQueryTemplate(Objects.requireNonNull(queryTemplate, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, "queryTemplate")));
                if (limit != null) {
                    retrievalTool.setLimit(limit);
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("queries", queries);
                string = retrievalTool.call(params, new ToolCallContext(conn)).getOutput();
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapExceptionIfNeeded(e);
                }
            }
            conn.close();
        }
        return string;
    }

    @Tool(name="autocomplete_iri_discovery_search", description="Discover IRIs by searching their names and getting results in order of relevance leveraging GraphDB's Autocomplete index.")
    public String executeAutocompleteDiscovery(@ToolParam(description="Autocomplete for IRI discovery search query") String query, @ToolParam(required=false, description="Filter results by class. Valid values are the exact URI of one class from the ontology.") String resultClass, @ToolParam(required=false, description="Limit the maximum number of IRIs (using autocomplete).The default value is automatic and determined at runtime. If not sure leave the default value") Integer limit, @ToolParam(description="The name of the GraphDB repository to query. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.") String repositoryId) {
        String string;
        block9: {
            SecurityUtils.checkRepositoryAccess((String)Objects.requireNonNull(repositoryId, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, REPOSITORY_ID)), (boolean)false);
            RepositoryConnection conn = this.getRepositoryConnection(repositoryId);
            try {
                AutocompleteIriDiscoveryTool autocompleteIriDiscoveryTool = new AutocompleteIriDiscoveryTool();
                if (limit != null) {
                    autocompleteIriDiscoveryTool.setLimit(limit);
                }
                ToolCallContext toolCallContext = new ToolCallContext(conn);
                autocompleteIriDiscoveryTool.validate(toolCallContext);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("query", query);
                params.put("resultClass", resultClass);
                string = autocompleteIriDiscoveryTool.call(params, toolCallContext).getOutput();
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapExceptionIfNeeded(e);
                }
            }
            conn.close();
        }
        return string;
    }

    @Tool(name="similarity_search", description="    Performs semantic similarity search to find conceptually related content using vector embeddings.\n    Best for conceptual queries like \"who is interested in sports\", \"employees with leadership experience\",\n    or \"people working on similar projects\".\n    Returns entities ranked by semantic similarity rather than exact keyword matches.\n    **Use this when you want to find content that means something similar, even if the exact words don't match.\n    For exact keyword or phrase matching, use fts_search instead.**\n    Always call get_similarity_options first to discover available connectors, indexes, and vector fields.\n")
    public String executeSimilaritySearch(@ToolParam(description="Natural language description of what you're looking for. Write conceptually - describe the meaning, not exact keywords.\nGood examples: 'interested in sports', 'has management experience', 'works with data analysis', 'enjoys creative hobbies'\nAvoid: exact names, specific keywords, boolean operators\n") String query, @ToolParam(description="Name of the similarity index or connector instance to use. Get this from get_similarity_options output.\n") String similarityIndex, @ToolParam(required=false, description="Minimum similarity score 0-1 to filter results (optional).\n- 0.6 \u2192 Broader, more inclusive results\n- 0.7 \u2192 Balanced relevance (good default)\n- 0.8+ \u2192 Only very similar content\n- 0.9+ \u2192 Nearly identical content only\nLower values cast a wider net, higher values are more selective.\n") Double resultThreshold, @ToolParam(required=false, description="Maximum number of RDF triples to return (optional).\nDefault is automatically determined based on result relevance.\nStart with default, then specify if you need more/fewer results.\n") Integer limit, @ToolParam(description="The search method to use:\n- 'similarity' \u2192 GraphDB's built-in semantic similarity (most common)\n- 'elasticsearch' \u2192 External Elasticsearch connector (requires connectorField)\n- 'opensearch' \u2192 External OpenSearch connector (requires connectorField)\nUse get_similarity_options to see which types are available.\n") String connectorType, @ToolParam(required=false, description="Vector field name in the external index **(required only for 'elasticsearch' and 'opensearch' connector types)**.\nGet available field names from get_similarity_options.\n") String connectorField, @ToolParam(description="The name of the GraphDB repository to query. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.") String repositoryId) {
        String string;
        block11: {
            Objects.requireNonNull(repositoryId, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, REPOSITORY_ID));
            Objects.requireNonNull(query, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, "query"));
            Objects.requireNonNull(similarityIndex, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, "similarityIndex"));
            Objects.requireNonNull(connectorType, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, "connectorType"));
            SecurityUtils.checkRepositoryAccess((String)Objects.requireNonNull(repositoryId, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, REPOSITORY_ID)), (boolean)false);
            RepositoryConnection conn = this.getRepositoryConnection(repositoryId);
            try {
                SimilaritySearchTool similaritySearchTool = new SimilaritySearchTool();
                similaritySearchTool.setConnectorType(connectorType);
                similaritySearchTool.setSimilarityIndex(similarityIndex);
                if (resultThreshold != null) {
                    similaritySearchTool.setResultThreshold(resultThreshold);
                }
                if (limit != null) {
                    similaritySearchTool.setLimit(limit);
                }
                if (StringUtils.isNotEmpty((CharSequence)connectorField)) {
                    similaritySearchTool.setConnectorFields(Collections.singletonList(connectorField));
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("query", query);
                string = similaritySearchTool.call(params, new ToolCallContext(conn)).getOutput();
                if (conn == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapExceptionIfNeeded(e);
                }
            }
            conn.close();
        }
        return string;
    }

    @Tool(name="sparql_query", description="Execute a SPARQL `SELECT`, `CONSTRUCT`, or `DESCRIBE` query against GraphDB\nand return the results.\n\n# Internal Federation in GraphDB\n\nGraphDB supports federated queries across repositories using the `SERVICE` clause.\nTo query multiple repositories from a specific repository (e.g., from repository `a`)\nwithin the same GraphDB MCP server, use the following pattern:\n\n## Example: From Repository `a`\n\n```sparql\nSELECT * WHERE {\n    ?s ?p ?o .\n    SERVICE <repository:b> {\n        ?s ?p ?o .\n    }\n}\n```\n\nThis is the recommended approach for retrieving related data across repositories managed by the GraphDB MCP Server.\n\n## Best Practices\n\n1. **Query optimization:** Place the most selective patterns and filters inside `SERVICE` blocks to minimize transferred data.\n2. **Error isolation:** Validate queries against each individual repository before combining them in a federated query.\n3. **Performance awareness:** Be mindful of data volume and cardinality when joining results across repositories.\n\nThis method enables robust, scalable cross-repository analytics while preserving the benefits of distributed RDF storage.\n")
    public String executeSparqlSearch(@ToolParam(description="SPARQL query") String query, @ToolParam(required=false, description="Automatically inserts missing namespaces in SPARQL queries") Boolean addMissingNamespaces, @ToolParam(description="The name of the GraphDB repository to query. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.") String repositoryId) {
        String string;
        block8: {
            SecurityUtils.checkRepositoryAccess((String)Objects.requireNonNull(repositoryId, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, REPOSITORY_ID)), (boolean)false);
            RepositoryConnection conn = this.getRepositoryConnection(repositoryId);
            try {
                SPARQLQueryTool sparqlQueryTool = new SPARQLQueryTool();
                sparqlQueryTool.setAddMissingNamespaces(Boolean.TRUE.equals(addMissingNamespaces));
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("query", query);
                string = sparqlQueryTool.call(params, new ToolCallContext(conn)).getOutput();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapExceptionIfNeeded(e);
                }
            }
            conn.close();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Tool(name="ontology_schema", description="List all node types, their attributes and their relationships to other node-types in the GraphDB database.")
    public String getOntology(@ToolParam(required=false, description="The named graph that contains the entire ontology or a subset sufficient to generate useful SPARQL queriesEither this or 'ontologyQuery' must be provided.") String ontologyGraph, @ToolParam(required=false, description="A SPARQL CONSTRUCT query that returns the entire ontology or a subset sufficient to generate useful SPARQL queriesEither this or 'ontologyGraph' must be provided") String ontologyQuery, @ToolParam(required=false, description="Automatically inserts missing namespaces in SPARQL queries") Boolean addMissingNamespaces, @ToolParam(description="The name of the repository from which to extract the ontology. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.") String repositoryId) {
        SecurityUtils.checkRepositoryAccess((String)Objects.requireNonNull(repositoryId, String.format(PARAMETER_IS_REQUIRED_ERROR_MSG_TEMPLATE, REPOSITORY_ID)), (boolean)false);
        try (RepositoryConnection conn = this.getRepositoryConnection(repositoryId);){
            SPARQLQueryTool sparqlQueryTool = new SPARQLQueryTool(ontologyGraph, ontologyQuery);
            if (StringUtils.isEmpty((CharSequence)ontologyGraph) && StringUtils.isEmpty((CharSequence)ontologyQuery)) {
                String string2 = sparqlQueryTool.call(Map.of("query", DEFAULT_EXTRACT_ONTOLOGY_QUERY), new ToolCallContext(conn)).getOutput();
                return string2;
            }
            sparqlQueryTool.setAddMissingNamespaces(Boolean.TRUE.equals(addMissingNamespaces));
            String string = sparqlQueryTool.extractOntologyFromRepository(conn);
            return string;
        }
        catch (Exception e) {
            throw this.wrapExceptionIfNeeded(e);
        }
    }

    @Tool(name="get_repository_ids", description="Provides system information about available repositories in GraphDB MCP Server")
    public Set<String> getRepositoryIds() {
        return this.dataManagement.getCurrentLocationOrThrow().sesameManager().getRepositoryIDs().stream().filter(repoId -> SecurityUtils.hasRepositoryAccess((String)repoId, (boolean)false)).collect(Collectors.toSet());
    }

    @Tool(name="get_similarity_options", description="    Discovers available similarity search capabilities in a GraphDB repository.\n    This tool is a prerequisite for using similarity_search - it shows which similarity indexes,\n    connector types, and vector fields are available.\n    Always call this first before performing similarity searches to understand your options and configure the similarity_search parameters correctly.\n")
    public Map<String, List<SimilarityIndexesUtil.SimilarityIndex>> getSimilarityOptions(@ToolParam(description="The name of the GraphDB repository to query. This ID should correspond to a registered RDF repository in the MCP server of GraphDB instance.") String repositoryId) {
        Map map;
        block8: {
            RepositoryConnection conn = this.getRepositoryConnection(repositoryId);
            try {
                map = SimilarityIndexesUtil.getSimilarityIndexesForMCP((String)repositoryId, (RepositoryConnection)conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapExceptionIfNeeded(e);
                }
            }
            conn.close();
        }
        return map;
    }

    RepositoryConnection getRepositoryConnection(String repositoryId) {
        return this.dataManagement.getCurrentLocationOrThrow().getRepository(repositoryId).getRepository().getConnection();
    }

    private RuntimeException wrapExceptionIfNeeded(Exception e) {
        String msg = e.getMessage();
        if (msg != null && !msg.isBlank()) {
            RuntimeException runtimeException;
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                runtimeException = re;
            } else {
                runtimeException = new MCPToolExecutionException(msg, e);
            }
            throw runtimeException;
        }
        throw new MCPToolExecutionException("Unexpected error: " + e.getClass().getSimpleName(), e);
    }
}

