/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools.openapi;

import com.fasterxml.jackson.annotation.JsonKey;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import java.util.Map;

public class OpenApiToolDefinition {
    private final Tool tool;

    public OpenApiToolDefinition(Tool tool) {
        this.tool = tool;
    }

    @JsonKey
    public String getUrl() {
        return "/" + this.tool.getType().getToolName();
    }

    public PostMethod getPost() {
        return new PostMethod();
    }

    @JsonPropertyOrder(value={"operationId", "description", "requestBody", "deprecated"})
    public class PostMethod {
        public String getOperationId() {
            return OpenApiToolDefinition.this.tool.getType().getToolName();
        }

        public String getDescription() {
            return OpenApiToolDefinition.this.tool.getDescription();
        }

        public RequestBody getRequestBody() {
            return new RequestBody();
        }

        public boolean isDeprecated() {
            return false;
        }
    }

    public class RequestBody {
        public boolean isRequired() {
            return true;
        }

        public Map<String, Object> getContent() {
            return Map.of("application/json", Map.of("schema", OpenApiToolDefinition.this.tool.getParameterSchema()));
        }
    }
}

