/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ontotext.forest.gpt.ttyg.tools.AutocompleteIriDiscoveryTool;
import com.ontotext.forest.gpt.ttyg.tools.FTSSearchTool;
import com.ontotext.forest.gpt.ttyg.tools.IRIDiscoveryTool;
import com.ontotext.forest.gpt.ttyg.tools.NowTool;
import com.ontotext.forest.gpt.ttyg.tools.RetrievalSearchTool;
import com.ontotext.forest.gpt.ttyg.tools.SPARQLQueryTool;
import com.ontotext.forest.gpt.ttyg.tools.SimilaritySearchTool;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.graphdb.gpt.explain.NativeQueryType;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.stream.Stream;

public enum ToolType {
    SPARQL_QUERY(SPARQLQueryTool.class, NativeQueryType.SPARQL, "sparql_search"),
    FTS_SEARCH(FTSSearchTool.class, NativeQueryType.SPARQL, "fts_search"),
    SIMILARITY_SEARCH(SimilaritySearchTool.class, NativeQueryType.SPARQL, "similarity_search"),
    RETRIEVAL_SEARCH(RetrievalSearchTool.class, NativeQueryType.JSON, "retrieval_search"),
    AUTOCOMPLETE_IRI_DISCOVERY_SEARCH(AutocompleteIriDiscoveryTool.class, NativeQueryType.SPARQL, "autocomplete_iri_discovery_search", false, false),
    IRI_DISCOVERY(IRIDiscoveryTool.class, NativeQueryType.SPARQL, "iri_discovery_search", false, false),
    NOW(NowTool.class, NativeQueryType.OTHER, null, false, true);

    private final Class<? extends Tool> implClass;
    private final boolean mainTool;
    private final boolean hiddenTool;
    private final NativeQueryType nativeQueryType;
    private final String legacyUiMethodKey;

    public static ToolType fromImplementationClass(Class<? extends Tool> implClass) {
        return EnumSet.allOf(ToolType.class).stream().filter(e -> e.implClass.equals(implClass)).findAny().orElseThrow(() -> new IllegalArgumentException("Unsupported implementation class: " + implClass.getSimpleName()));
    }

    public static ToolType fromLegacyUiMethodKey(String legacyUiMethodKey) {
        return Stream.of(ToolType.values()).filter(t -> t.legacyUiMethodKey != null && t.legacyUiMethodKey.equals(legacyUiMethodKey)).findAny().orElseThrow(IllegalArgumentException::new);
    }

    @JsonCreator
    public static ToolType fromString(String toolName) {
        return ToolType.valueOf(toolName.toUpperCase());
    }

    private ToolType(Class<? extends Tool> implClass, NativeQueryType nativeQueryType, String legacyUiMethodKey) {
        this(implClass, nativeQueryType, legacyUiMethodKey, true, false);
    }

    private ToolType(Class<? extends Tool> implClass, NativeQueryType nativeQueryType, String legacyUiMethodKey, boolean mainTool, boolean hiddenTool) {
        if (mainTool && hiddenTool) {
            throw new IllegalArgumentException("Tool cannot be a main tool and hidden at the same time");
        }
        this.implClass = implClass;
        this.mainTool = mainTool;
        this.hiddenTool = hiddenTool;
        this.nativeQueryType = nativeQueryType;
        this.legacyUiMethodKey = legacyUiMethodKey;
    }

    public boolean isMainTool() {
        return this.mainTool;
    }

    public boolean isHiddenTool() {
        return this.hiddenTool;
    }

    public NativeQueryType getNativeQueryType() {
        return this.nativeQueryType;
    }

    Class<? extends Tool> implementationClass() {
        return this.implClass;
    }

    public Tool instantiateTool() {
        try {
            return this.implClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @JsonValue
    public String getToolName() {
        return this.name().toLowerCase();
    }

    public String getLegacyUiMethodKey() {
        return this.legacyUiMethodKey;
    }

    public static ToolType extractToolType(String toolName) {
        ToolType toolType;
        try {
            toolType = ToolType.valueOf(toolName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown tool type: " + toolName);
        }
        return toolType;
    }
}

