/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.graphdb.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public enum SPARQLWellKnownOntology {
    SCHEMA_ORG("onto:use:schema.org", "the schema.org ontology."),
    WIKIDATA("onto:use:wikidata", "the Wikidata ontology but note that GraphDB cannot handle Wikidata SPARQL extensions."),
    FOAF("onto:use:foaf", "the foaf ontology."),
    CUSTOM("onto:custom", ""),
    DISABLED("onto:disabled", "");

    final String iri;
    private final String instruction;

    private SPARQLWellKnownOntology(String iri, String instruction) {
        this.iri = iri;
        this.instruction = instruction;
    }

    static SPARQLWellKnownOntology fromIri(String iri) {
        for (SPARQLWellKnownOntology s : SPARQLWellKnownOntology.values()) {
            if (!s.iri.equals(iri) && (s != DISABLED || iri == null || !iri.startsWith(s.iri)) && (s != CUSTOM || iri == null || !iri.startsWith(s.iri))) continue;
            return s;
        }
        return null;
    }

    String getInstruction(String iri) {
        String[] components;
        if (this == DISABLED) {
            String[] components2 = iri.split("/", 2);
            if (components2.length == 2) {
                try {
                    return Files.readString(Paths.get(Config.getDistDirectory(), components2[1]));
                }
                catch (IOException e) {
                    throw new ToolConfigException("Cannot read file: " + components2[1], e);
                }
            }
        } else if (this == CUSTOM && (components = iri.split("/", 2)).length == 2) {
            return components[1];
        }
        return this.instruction;
    }
}

