/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.tools.RetrievalSearchTool;
import com.ontotext.graphdb.configs.SystemConfig;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;

class RetrievalSearchConnectorService
implements RetrievalSearchTool.RetrievalSearchService {
    private static final String QUERY = "PREFIX retr: <http://www.ontotext.com/connectors/retrieval#>\nPREFIX retr-inst: <http://www.ontotext.com/connectors/retrieval/instance#>\nSELECT ?entity ?text {\n    [] a retr-inst:%s ;\n        retr:query %s ;\n%s        retr:entities ?entity .\n    ?entity retr:snippets _:s .\n        _:s retr:snippetField ?field ;\n    retr:snippetText ?text .\n    # STR() needed for a quirk in connectors\n    FILTER(STR(?field) = \"chunk\")\n}";
    private static final String LIMIT_TEMPLATE = "        retr:limit %d ;\n";
    private final RetrievalSearchTool tool;

    RetrievalSearchConnectorService(RetrievalSearchTool tool) {
        this.tool = tool;
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        return SystemConfig.localeIndependentFormat((String)QUERY, (Object[])new Object[]{this.tool.getConnectorInstance(), this.tool.toSparqlLiteral(JSONUtil.prettyPrintJSON(this.tool.sanitizeParameters(parameters))), this.tool.getLimit() > 0 ? SystemConfig.localeIndependentFormat((String)LIMIT_TEMPLATE, (Object[])new Object[]{this.tool.getLimit()}) : ""});
    }

    @Override
    public String call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        RepositoryConnection connection = agentRepository.connectionInstance();
        TupleQuery tq = connection.prepareTupleQuery(this.getNativeQuery(parameters));
        try (TupleQueryResult tqr = tq.evaluate();){
            String string = tqr.stream().map(bs -> bs.getValue("text").stringValue()).collect(Collectors.joining("\n\n"));
            return string;
        }
    }
}

