/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.tools.BaseTool;
import com.ontotext.forest.gpt.ttyg.tools.ParameterDefinition;
import com.ontotext.forest.gpt.ttyg.tools.ToolResponse;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import dev.langchain4j.agent.tool.ToolSpecification;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public class NowTool
extends BaseTool {
    private static final NowTool INSTANCE = new NowTool();

    public static NowTool getInstance() {
        return INSTANCE;
    }

    private NowTool() {
        super(ToolType.NOW);
        this.setEnabled(true);
    }

    @Override
    public String getDescription() {
        return "Returns the current moment in time. Do not reuse responses.";
    }

    @Override
    public ParameterDefinition getParameterSchema() {
        return ParameterDefinition.rootParameters(List.of());
    }

    @Override
    public ToolSpecification toToolSpecification() {
        return ToolSpecification.builder().description(this.getDescription()).name(this.getType().getToolName().toLowerCase()).build();
    }

    @Override
    public ToolResponse call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        ZoneId zoneId = ZoneId.systemDefault();
        Integer zoneOffset = (Integer)parameters.get("tzOffset");
        if (zoneOffset != null) {
            zoneId = ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds(zoneOffset * 60));
        }
        String now = ZonedDateTime.now(zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return new ToolResponse(now);
    }

    @Override
    public String getRawQuery(Map<String, Object> parameters) {
        return null;
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        return null;
    }

    @Override
    public void setFromLegacyUiObject(JsonNode node) {
    }

    @Override
    public void writeToLegacyUiObject(JsonGenerator gen) throws IOException {
    }

    @Override
    public void validate(ToolCallContext agentRepository) {
    }
}

