/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.gpt.ttyg.RDFUtil;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.forest.gpt.ttyg.tools.BaseTool;
import com.ontotext.forest.gpt.ttyg.tools.ParameterDefinition;
import com.ontotext.forest.gpt.ttyg.tools.ToolResponse;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.SystemConfig;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.repository.RepositoryConnection;

public class IRIDiscoveryTool
extends BaseTool {
    public static final String QUERY_TEMPLATE_PROPERTY = "graphdb.ttyg.fts_iri.query.template";
    private static final String QUERY = Config.getProperty((String)"graphdb.ttyg.fts_iri.query.template", (String)"PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX onto: <http://www.ontotext.com/>\nSELECT ?label ?iri {\n    ?label onto:fts (%s '*') .\n    ?iri rdfs:label|skos:prefLabel ?label .\n}");
    public static final String IRI_DISCOVERY_DESCRIPTION = "Discovery IRIs by full-text search in labels.";

    public IRIDiscoveryTool() {
        super(ToolType.IRI_DISCOVERY);
    }

    @VisibleForTesting
    public IRIDiscoveryTool(Void dummy) {
        this();
        this.setEnabled(true);
    }

    @Override
    public void setFromLegacyUiObject(JsonNode node) {
        this.setEnabled(true);
    }

    @Override
    public void writeToLegacyUiObject(JsonGenerator gen) throws IOException {
        gen.writeStringField("method", this.getType().getLegacyUiMethodKey());
    }

    @Override
    public void validate(ToolCallContext agentRepository) {
        if (!RDFUtil.isFtsIndexEnabled(agentRepository.connectionInstance())) {
            throw new ToolConfigException("Full-text search index of repository " + agentRepository.getRepositoryId() + " must be enabled.");
        }
    }

    @Override
    public String getDescription() {
        return IRI_DISCOVERY_DESCRIPTION;
    }

    @Override
    public ParameterDefinition getParameterSchema() {
        return ParameterDefinition.singleParameter("query", "FTS search query");
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        String ftsQuery = RDFUtil.escapeFtsQuery(this.getRawQuery((Map)parameters));
        return SystemConfig.localeIndependentFormat((String)QUERY, (Object[])new Object[]{this.toSparqlLiteral(this.toFuzzyQuery(ftsQuery))});
    }

    @Override
    public ToolResponse call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        RepositoryConnection connection = agentRepository.connectionInstance();
        return new ToolResponse(this.evaluateParsedQuery((Query)connection.prepareTupleQuery(this.getNativeQuery(parameters)), connection, 0));
    }

    private String toFuzzyQuery(String query) {
        return Stream.of(query.split(" ")).map(s -> s + "~").collect(Collectors.joining(" "));
    }
}

