/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.gpt.ttyg.RDFUtil;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.forest.gpt.ttyg.tools.BaseTool;
import com.ontotext.forest.gpt.ttyg.tools.ParameterDefinition;
import com.ontotext.forest.gpt.ttyg.tools.ToolResponse;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.SystemConfig;
import java.io.IOException;
import java.util.Map;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.repository.RepositoryConnection;

public class FTSSearchTool
extends BaseTool {
    public static final String QUERY_TEMPLATE_PROPERTY = "graphdb.ttyg.fts.query.template";
    private static final String QUERY = Config.getProperty((String)"graphdb.ttyg.fts.query.template", (String)"PREFIX onto: <http://www.ontotext.com/>\nDESCRIBE ?iri {\n   ?x onto:fts (%s '*') {\n       ?x ?p ?iri .\n   } UNION {\n       ?iri ?p ?x .\n   }\n}");
    public static final String FTS_DESCRIPTION = "Query GraphDB by full-text search and return a subgraph of RDF triples.";
    private int limit;

    public FTSSearchTool() {
        super(ToolType.FTS_SEARCH);
    }

    @VisibleForTesting
    public FTSSearchTool(int limit) {
        this();
        this.setEnabled(true);
        this.setLimit(limit);
    }

    @Override
    public void setFromLegacyUiObject(JsonNode node) {
        this.setEnabled(true);
        this.setLimit(node.path("maxNumberOfTriplesPerCall").asInt(0));
    }

    @Override
    public void writeToLegacyUiObject(JsonGenerator gen) throws IOException {
        gen.writeStringField("method", this.getType().getLegacyUiMethodKey());
        gen.writeNumberField("maxNumberOfTriplesPerCall", this.getLimit());
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void validate(ToolCallContext agentRepository) {
        if (!RDFUtil.isFtsIndexEnabled(agentRepository.connectionInstance())) {
            throw new ToolConfigException("Full-text search index of repository " + agentRepository.getRepositoryId() + " must be enabled.");
        }
    }

    @Override
    public String getDescription() {
        return FTS_DESCRIPTION;
    }

    @Override
    public ParameterDefinition getParameterSchema() {
        return ParameterDefinition.singleParameter("query", "FTS search query");
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        String ftsQuery = RDFUtil.escapeFtsQuery(this.getRawQuery((Map)parameters));
        return SystemConfig.localeIndependentFormat((String)QUERY, (Object[])new Object[]{this.toSparqlLiteral(ftsQuery)});
    }

    @Override
    public ToolResponse call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        RepositoryConnection connection = agentRepository.connectionInstance();
        return new ToolResponse(this.evaluateParsedQuery((Query)connection.prepareGraphQuery(this.getNativeQuery(parameters)), connection, this.limit));
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FTSSearchTool)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FTSSearchTool tool = (FTSSearchTool)o;
        return this.limit == tool.limit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.limit;
        return result;
    }
}

