/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.azure.ai.openai.assistants.models.FunctionDefinition;
import com.azure.ai.openai.assistants.models.FunctionToolDefinition;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.RDFUtil;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.forest.gpt.ttyg.tools.ToolSpecificationHelper;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.configs.SystemConfig;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import java.util.Map;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.repository.RepositoryConnection;

abstract class BaseTool
implements Tool {
    private boolean enabled;
    private final ToolType type;

    BaseTool(ToolType type) {
        this.type = type;
    }

    @Override
    public final ToolType getType() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getRawQuery(Map<String, Object> parameters) {
        return this.getStringParameter(parameters, "query");
    }

    @Override
    public FunctionToolDefinition toFunctionToolDefinition() {
        Map parameterDesc = (Map)JSONUtil.getObjectMapper().convertValue((Object)this.getParameterSchema(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        BinaryData parameters = BinaryData.fromObject((Object)parameterDesc);
        FunctionDefinition def = new FunctionDefinition(this.getType().getToolName(), parameters);
        def.setDescription(this.getDescription());
        return new FunctionToolDefinition(def);
    }

    @Override
    public ToolSpecification toToolSpecification() {
        Map parameterDesc = (Map)JSONUtil.getObjectMapper().convertValue((Object)this.getParameterSchema(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        JsonNode parametersNode = JSONUtil.getObjectMapper().valueToTree((Object)parameterDesc);
        JsonObjectSchema parametersSchema = (JsonObjectSchema)ToolSpecificationHelper.jsonNodeToJsonSchemaElement(parametersNode);
        return ToolSpecification.builder().description(this.getDescription()).name(this.getType().getToolName().toLowerCase()).parameters(parametersSchema).build();
    }

    protected String toSparqlLiteral(String string) {
        return SystemConfig.localeIndependentFormat((String)"'''%s'''", (Object[])new Object[]{string.replace("\\", "\\\\").replace("'", "\\'")});
    }

    protected String getStringParameter(Map<String, Object> parameters, String parameterName) {
        Object value = parameters.get(parameterName);
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Parameter '" + parameterName + "' is missing or not a string");
    }

    protected String evaluateParsedQuery(Query parsedQuery, RepositoryConnection connection, int limit) {
        if (parsedQuery instanceof BooleanQuery) {
            return Boolean.toString(((BooleanQuery)parsedQuery).evaluate());
        }
        if (parsedQuery instanceof TupleQuery) {
            return RDFUtil.serializeTupleResult(((TupleQuery)parsedQuery).evaluate(), limit, 256000);
        }
        if (parsedQuery instanceof GraphQuery) {
            return RDFUtil.serializeRdf((QueryResult<Statement>)((GraphQuery)parsedQuery).evaluate(), (Iterable<Namespace>)connection.getNamespaces(), true, limit, 256000);
        }
        throw new IllegalStateException("Unsupported query type: " + parsedQuery.getClass().getSimpleName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTool)) {
            return false;
        }
        BaseTool baseTool = (BaseTool)o;
        return this.enabled == baseTool.enabled;
    }

    public int hashCode() {
        return Boolean.hashCode(this.enabled);
    }
}

