/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg;

import com.ontotext.forest.gpt.ttyg.RDFUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.eclipse.rdf4j.rio.turtlestar.TurtleStarWriter;

class SmartTurtleStarWriter
implements RDFWriter,
AutoCloseable {
    private final int sizeLimit;
    private final boolean onlyUsedNamespaces;
    private final StringWriter statementsWriter;
    private final StringWriter namespacesWriter;
    private final TurtleStarWriter delegate;
    private final Set<String> usedNamespaces = new HashSet<String>();
    private boolean hasStatements;
    private Map<String, String> namespaceTable;

    SmartTurtleStarWriter(int sizeLimit, final boolean onlyUsedNamespaces) {
        this.sizeLimit = sizeLimit;
        this.onlyUsedNamespaces = onlyUsedNamespaces;
        this.statementsWriter = new StringWriter();
        this.namespacesWriter = new StringWriter();
        this.delegate = new TurtleStarWriter(this.statementsWriter){
            {
                super(writer);
                if (onlyUsedNamespaces) {
                    this.namespaceTable = new NamespaceTracker();
                }
                SmartTurtleStarWriter.this.namespaceTable = this.namespaceTable;
            }

            protected void writeURI(IRI uri) throws IOException {
                String prefix;
                if (uri.getLocalName().isEmpty() && (prefix = (String)this.namespaceTable.get(uri.getNamespace())) != null) {
                    this.writer.write(prefix);
                    this.writer.write(":");
                    return;
                }
                super.writeURI(uri);
            }

            protected void writeNamespace(String prefix, String name) {
            }
        };
        this.delegate.set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TURTLESTAR;
    }

    public RDFWriter setWriterConfig(WriterConfig writerConfig) {
        throw new IllegalStateException("Not supported");
    }

    public WriterConfig getWriterConfig() {
        throw new IllegalStateException("Not supported");
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        throw new IllegalStateException("Not supported");
    }

    public <T> RDFWriter set(RioSetting<T> rioSetting, T t) {
        throw new IllegalStateException("Not supported");
    }

    public void startRDF() throws RDFHandlerException {
        this.delegate.startRDF();
        if (this.sizeLimit > 0) {
            try {
                Field bufferSizeField = TurtleWriter.class.getDeclaredField("bufferSize");
                bufferSizeField.setAccessible(true);
                bufferSizeField.set(this.delegate, this.sizeLimit / 32);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void endRDF() throws RDFHandlerException {
        int reduceBySize;
        this.delegate.endRDF();
        TurtleStarWriter writer = new TurtleStarWriter((Writer)this.namespacesWriter);
        writer.startRDF();
        this.namespaceTable.forEach((name, prefix) -> {
            if (!this.onlyUsedNamespaces || this.usedNamespaces.contains(prefix)) {
                writer.handleNamespace(prefix, name);
            }
        });
        this.namespacesWriter.flush();
        writer.endRDF();
        StringBuffer statementsBuffer = this.statementsWriter.getBuffer();
        int statementsSize = statementsBuffer.length();
        int totalSize = this.namespacesWriter.getBuffer().length() + 1 + statementsSize;
        if (this.sizeLimit > 0 && totalSize > this.sizeLimit && (reduceBySize = totalSize - this.sizeLimit) < statementsSize) {
            statementsBuffer.setLength(statementsSize - reduceBySize);
            String goodEndString = " .\n";
            int pos = statementsBuffer.lastIndexOf(goodEndString);
            if (pos != -1) {
                statementsBuffer.setLength(pos + goodEndString.length());
            }
        }
    }

    public void handleNamespace(String s, String s1) throws RDFHandlerException {
        this.delegate.handleNamespace(s, s1);
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        this.delegate.handleStatement(statement);
        StringBuffer buffer = this.statementsWriter.getBuffer();
        if (this.sizeLimit > 0 && buffer.length() > this.sizeLimit) {
            throw new RDFUtil.ResultOverLimitException();
        }
        this.hasStatements = true;
    }

    public void handleComment(String s) throws RDFHandlerException {
        this.delegate.handleComment(s);
    }

    @Override
    public void close() throws IOException {
        try {
            this.statementsWriter.close();
        }
        finally {
            this.namespacesWriter.close();
        }
    }

    public String getSerialized() {
        if (!this.hasStatements) {
            return "";
        }
        return String.join((CharSequence)"\n", this.namespacesWriter.toString(), this.statementsWriter.toString().trim());
    }

    private class NamespaceTracker
    extends LinkedHashMap<String, String> {
        private NamespaceTracker() {
        }

        @Override
        public String get(Object key) {
            String value = (String)super.get(key);
            if (value != null) {
                SmartTurtleStarWriter.this.usedNamespaces.add(value);
            }
            return value;
        }
    }
}

