/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.chat.completions;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.gpt.chat.GptAssistantChat;
import com.ontotext.forest.gpt.chat.GptChat;
import com.ontotext.forest.gpt.chat.completions.GptCompletionsChat;
import com.ontotext.forest.persistence.ConversationsPersistedConfig;
import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.graphdb.configs.LLMConfig;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Named;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class GptChatInstanceHolder {
    @Autowired
    private PersistedConfig persistedConfig;
    @Autowired
    private ConversationsPersistedConfig conversationsPersistedConfig;
    @Autowired
    private SemanticDataManagement dataManagement;
    @Autowired
    private SemanticLocationManagement locationManagement;
    private GptChat instance;

    public GptChat getGPTChatInstance() {
        if (this.instance == null) {
            this.instance = new GptAssistantChat(this.dataManagement);
        }
        return this.instance;
    }

    @PostConstruct
    public void init() {
        if (!this.isAssistantAPI()) {
            this.instance = new GptCompletionsChat(this.persistedConfig, this.conversationsPersistedConfig, this.dataManagement, this.locationManagement);
        }
    }

    private boolean isAssistantAPI() {
        String api = LLMConfig.getLLMApi();
        return StringUtils.isEmpty((CharSequence)api) || api.toLowerCase(Locale.ROOT).startsWith("openai-assistants");
    }
}

