/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.chat;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.gpt.chat.GptChatMessage;
import com.ontotext.forest.gpt.conversations.CancelResponse;
import com.ontotext.forest.gpt.conversations.ConversationResponse;
import com.ontotext.forest.gpt.model.AssistantsInstructions;
import com.ontotext.forest.gpt.model.AssistantsRequest;
import com.ontotext.forest.gpt.model.AssistantsRequestDefaultValues;
import com.ontotext.forest.gpt.model.AssistantsResponse;
import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.forest.gpt.ttyg.AgentInstructions;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.RDFUtil;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.forest.gpt.ttyg.tools.NowTool;
import com.ontotext.forest.gpt.ttyg.tools.SPARQLQueryTool;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.forest.gpt.ttyg.tools.ToolResponse;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.forest.gpt.ttyg.transitional.ToolList;
import com.ontotext.graphdb.configs.SystemConfig;
import com.ontotext.graphdb.gpt.explain.ExplainRequestMessage;
import com.ontotext.graphdb.gpt.explain.ExplainResponseMessage;
import com.ontotext.graphdb.gpt.quota.GraphDBTokenQuotaManager;
import com.ontotext.trree.RepositoryMonitorTrackRecordHelper;
import com.ontotext.trree.RepositoryMonitorTrackRecordImpl;
import com.ontotext.trree.monitorRepository.MonitorRepositoryConnection;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GptChat {
    public static final String CANCEL_CHAT_STATUS = "Request cancelled by the user.";
    public static final String FAILED_CHAT_STATUS = "Request failed due to an error.";
    public static final String EXPIRED_CHAT_STATUS = "Request expired before completion.";
    public static final String NO_CONVERSATION_TO_CANCEL = "There is no actively running chat to cancel.";
    public static final String CANCELLING_CHAT_STATUS = "Request in process of termination.";
    private static final Logger logger = LoggerFactory.getLogger(GptChat.class);
    private final SemanticDataManagement dataManagement;
    protected Map<String, RepositoryMonitorTrackRecordImpl> threadIdToTrackRecord = new ConcurrentHashMap<String, RepositoryMonitorTrackRecordImpl>();
    public final ExecutorService cancellationExecutor = Executors.newCachedThreadPool();

    public GptChat(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }

    public abstract ConversationResponse continueChat(String var1, String var2, String var3, Integer var4);

    public abstract GptChatMessage createConversation();

    public abstract ConversationResponse renameConversation(String var1, String var2);

    public abstract ConversationResponse getConversation(String var1);

    public abstract List<ConversationResponse> getConversations(Set<String> var1, Consumer<String> var2);

    public abstract ConversationResponse deleteConversation(String var1);

    public CancelResponse cancelChat(String threadId) {
        if (this.threadIdToTrackRecord.containsKey(threadId)) {
            this.threadIdToTrackRecord.remove(threadId).abort();
        }
        return new CancelResponse();
    }

    public abstract ExplainResponseMessage explainResponse(ExplainRequestMessage var1);

    public abstract ConversationResponse exportChat(String var1);

    public abstract AssistantsResponse createAgent(AssistantsRequest var1);

    public abstract AssistantsResponse editAgent(AssistantsRequest var1);

    public abstract void deleteAgent(String var1);

    public abstract List<AssistantsResponse> getAllAgents();

    public abstract AssistantsResponse getAgent(String var1);

    public abstract AgentConfig getAgentConfig(String var1);

    public abstract AgentInstructions explainAgentInstructions(AssistantsRequest var1);

    protected abstract ConversationResponse getConversationResponse(String var1, String var2, String var3, Integer var4, AgentConfig var5);

    protected abstract void editAgentFingerprint(AgentConfig var1, RepositoryConnection var2);

    public RepositoryConnection getRepositoryConnection(String repositoryId) {
        return this.dataManagement.getCurrentLocationOrThrow().getRepository(repositoryId).getRepository().getConnection();
    }

    public AssistantsRequestDefaultValues getDefaultAgent() {
        logger.debug("TTYG getDefaultAgent");
        AssistantsRequestDefaultValues assistantsRequestDefaultValues = new AssistantsRequestDefaultValues();
        logger.debug("TTYG getDefaultAgent => OK");
        return assistantsRequestDefaultValues;
    }

    public ConversationResponse chat(String threadId, String question, String assistantId, Integer tzOffset) {
        GraphDBTokenQuotaManager.getInstance().validateQuotaOrThrow();
        logger.debug("TTYG chat {}///{}: {}", new Object[]{threadId, assistantId, question});
        AgentConfig agentConfig = this.getAgentConfig(assistantId);
        this.applyRepositoryChanges(agentConfig);
        ConversationResponse response = this.getConversationResponse(threadId, question, assistantId, tzOffset, agentConfig);
        logger.debug("TTYG chat {}///{} OK: {}", new Object[]{threadId, assistantId, question});
        return response;
    }

    public String callTool(String functionName, String functionArgs, AgentConfig agentConfig, Integer tzOffset, @Nullable String threadId) {
        try {
            String string;
            block11: {
                RepositoryConnection conn = this.getRepositoryConnection(agentConfig.getRepositoryId());
                try {
                    if (threadId != null) {
                        this.registerCompletionsQueryTool(conn, threadId);
                    }
                    string = this.callTool(this.lookupTool(agentConfig, functionName), functionArgs, tzOffset, conn);
                    if (conn == null) break block11;
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                conn.close();
            }
            return string;
        }
        finally {
            if (threadId != null) {
                this.threadIdToTrackRecord.remove(threadId);
            }
        }
    }

    public String callTool(Tool tool, String functionArgs, Integer tzOffset, RepositoryConnection conn) {
        Object output;
        try {
            String functionName = tool.getType().getToolName();
            logger.debug("TTYG callTool: {}\n{}", (Object)functionName, (Object)functionArgs);
            Map<String, Object> parameters = this.parseCallParametersJson(functionArgs);
            if (tzOffset != null && tool.getType() == ToolType.NOW) {
                parameters = Map.of("tzOffset", tzOffset);
            }
            ToolCallContext toolCallContext = new ToolCallContext(conn);
            tool.validate(toolCallContext);
            ToolResponse result = tool.call(parameters, toolCallContext);
            output = result.getOutput();
            logger.debug("TTYG callTool result: {} => {} characters", (Object)functionName, (Object)((String)output).length());
        }
        catch (ToolConfigException e) {
            logger.error("TTYG callTool fatal config error (propagated to model without stacktrace)", (Throwable)e);
            output = "Fatal tool configuration error. Inform the user and do not retry. Details:\n\n" + String.valueOf(e);
        }
        catch (RuntimeException e) {
            logger.warn("TTYG callTool error (propagated to model): {}", (Object)e.toString());
            output = "Error: " + String.valueOf(e);
        }
        return output;
    }

    protected Tool getToolForExplain(AgentConfig agentConfig, String functionName) {
        Tool tool;
        try {
            tool = this.lookupTool(agentConfig, functionName);
        }
        catch (IllegalArgumentException e) {
            tool = this.getToolDefaultConfig(functionName);
        }
        return tool;
    }

    protected String getErrorOutput(String output) {
        if (output == null || output.startsWith("Error") || output.startsWith("Fatal")) {
            return StringUtils.defaultString((String)output, (String)"Generic error");
        }
        return null;
    }

    @VisibleForTesting
    protected Tool lookupTool(AgentConfig agentConfig, String toolName) {
        ToolType toolType = ToolType.extractToolType(toolName);
        return agentConfig.getEnabledTool(toolType);
    }

    private Tool getToolDefaultConfig(String toolName) {
        AgentConfig.ToolMap allTools = this.getDefaultAgent().getAssistantExtractionMethods().toMap();
        allTools.putAll(this.getDefaultAgent().getAdditionalExtractionMethods().toMap());
        allTools.put(ToolType.NOW, NowTool.getInstance());
        ToolType toolType = ToolType.extractToolType(toolName);
        Tool toolConfig = (Tool)allTools.get((Object)toolType);
        if (toolConfig == null) {
            throw new IllegalArgumentException("Unknown tool type: " + String.valueOf((Object)toolType));
        }
        return toolConfig;
    }

    protected Map<String, Object> parseCallParametersJson(String jsonString) {
        return JSONUtil.parseJSON(this.preprocessJsonString(jsonString));
    }

    protected String preprocessJsonString(String jsonString) {
        return jsonString.replaceAll("`", "\"");
    }

    protected <T extends AgentConfig> T agentConfigFromRequest(AssistantsRequest assistantsRequest, RepositoryConnection connection, Supplier<T> constructor) {
        AgentConfig agentConfig = (AgentConfig)constructor.get();
        ToolCallContext toolCallContext = new ToolCallContext(connection);
        agentConfig.setId(assistantsRequest.getId());
        agentConfig.setName(assistantsRequest.getName());
        agentConfig.setModel(assistantsRequest.getModel());
        agentConfig.setInstallationId(SystemConfig.getInstallationId());
        agentConfig.setRepositoryId(assistantsRequest.getRepositoryId());
        agentConfig.setFingerprint(toolCallContext.getRepositoryFingerprint());
        agentConfig.setTemperature(assistantsRequest.getTemperature());
        agentConfig.setTopP(assistantsRequest.getTopP());
        agentConfig.setContextSize(assistantsRequest.getContextSize());
        AssistantsInstructions instructions = assistantsRequest.getInstructions();
        if (instructions != null) {
            agentConfig.setBaseInstruction(instructions.getSystemInstruction());
            agentConfig.setUserInstruction(instructions.getUserInstruction());
        }
        ToolList toolList = assistantsRequest.getAssistantExtractionMethods();
        ToolList otherToolList = assistantsRequest.getAdditionalExtractionMethods();
        if (toolList != null || otherToolList != null) {
            if (toolList != null) {
                if (otherToolList != null) {
                    toolList.addAll(otherToolList);
                }
            } else {
                toolList = otherToolList;
            }
            AgentConfig.ToolMap toolMap = toolList.toMap();
            toolMap.put(ToolType.NOW, NowTool.getInstance());
            agentConfig.setTools(toolMap);
        }
        agentConfig.validate(toolCallContext);
        return (T)agentConfig;
    }

    protected AssistantsResponse assistantsResponseFromAgentConfig(AgentConfig agentConfig) {
        AssistantsResponse response = new AssistantsResponse();
        response.setId(agentConfig.getId());
        response.setName(agentConfig.getName());
        response.setModel(agentConfig.getModel());
        response.setTemperature(agentConfig.getTemperature());
        response.setTopP(agentConfig.getTopP());
        response.setContextSize(agentConfig.getContextSize());
        response.setRepositoryId(agentConfig.getRepositoryId());
        response.setInstructions(new AssistantsInstructions(agentConfig.getBaseInstruction(), agentConfig.getUserInstruction()));
        ToolList mainTools = new ToolList();
        agentConfig.getTools().forEach((type, config) -> {
            if (!type.isHiddenTool() && type.isMainTool()) {
                mainTools.add(config);
            }
        });
        response.setAssistantExtractionMethods(mainTools);
        ToolList additionalTools = new ToolList();
        agentConfig.getTools().forEach((type, config) -> {
            if (!type.isHiddenTool() && !type.isMainTool()) {
                additionalTools.add(config);
            }
        });
        response.setAdditionalExtractionMethods(additionalTools);
        response.setCompatibility(AssistantsResponse.AgentCompatibility.fromVersion(agentConfig.getVersion()));
        return response;
    }

    public void applyRepositoryChanges(AgentConfig agentConfig) {
        try (RepositoryConnection connection = this.getRepositoryConnection(agentConfig.getRepositoryId());){
            SPARQLQueryTool config;
            String fingerprint = RDFUtil.getRepositoryFingerprint(connection);
            if (!fingerprint.equals(agentConfig.getFingerprint()) && (config = (SPARQLQueryTool)agentConfig.getTools().get((Object)ToolType.SPARQL_QUERY)) != null && config.isEnabled()) {
                logger.info("Updating agent's instructions because the data in the repository changed: {}", (Object)agentConfig.getName());
                agentConfig.setFingerprint(fingerprint);
                this.editAgentFingerprint(agentConfig, connection);
            }
        }
    }

    public void registerCompletionsQueryTool(RepositoryConnection conn, String threadId) {
        if (conn instanceof MonitorRepositoryConnection) {
            MonitorRepositoryConnection monitorConnection = (MonitorRepositoryConnection)conn;
            RepositoryMonitorTrackRecordHelper trackRecordHelper = monitorConnection.getSailConnectionImpl().getTrackRecordHelper();
            RepositoryMonitorTrackRecordImpl trackRecord = trackRecordHelper.getTrackRecord();
            trackRecordHelper.registerTrackRecordQuery(() -> trackRecordHelper.closeTrackRecord(trackRecord));
            this.threadIdToTrackRecord.put(threadId, trackRecord);
        }
    }
}

