/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.chat;

import com.azure.ai.openai.assistants.AssistantsClient;
import com.azure.ai.openai.assistants.AssistantsClientBuilder;
import com.azure.ai.openai.assistants.models.AssistantThread;
import com.azure.ai.openai.assistants.models.ListSortOrder;
import com.azure.ai.openai.assistants.models.RunStatus;
import com.azure.ai.openai.assistants.models.RunStep;
import com.azure.ai.openai.assistants.models.RunStepDetails;
import com.azure.ai.openai.assistants.models.RunStepFunctionToolCall;
import com.azure.ai.openai.assistants.models.RunStepMessageCreationDetails;
import com.azure.ai.openai.assistants.models.RunStepToolCall;
import com.azure.ai.openai.assistants.models.RunStepToolCallDetails;
import com.azure.ai.openai.assistants.models.ThreadDeletionStatus;
import com.azure.ai.openai.assistants.models.ThreadMessage;
import com.azure.ai.openai.assistants.models.ThreadRun;
import com.azure.core.credential.KeyCredential;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpClient;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Header;
import com.azure.core.util.HttpClientOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.gpt.assistants.AssistantsGptClient;
import com.ontotext.forest.gpt.chat.ChatRunner;
import com.ontotext.forest.gpt.chat.GptChat;
import com.ontotext.forest.gpt.chat.GptChatMessage;
import com.ontotext.forest.gpt.conversations.CancelResponse;
import com.ontotext.forest.gpt.conversations.ConversationGptClient;
import com.ontotext.forest.gpt.conversations.ConversationResponse;
import com.ontotext.forest.gpt.conversations.Usage;
import com.ontotext.forest.gpt.model.AssistantsRequest;
import com.ontotext.forest.gpt.model.AssistantsResponse;
import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.forest.gpt.ttyg.AgentInstructions;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.agent.config.AssistanceAgentConfig;
import com.ontotext.forest.gpt.ttyg.exceptions.GenericServerException;
import com.ontotext.forest.gpt.ttyg.exceptions.NonExistentResourceRequested;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.graphdb.configs.LLMConfig;
import com.ontotext.graphdb.configs.SystemConfig;
import com.ontotext.graphdb.gpt.ChatModelFactory;
import com.ontotext.graphdb.gpt.explain.ExplainMessage;
import com.ontotext.graphdb.gpt.explain.ExplainRequestMessage;
import com.ontotext.graphdb.gpt.explain.ExplainResponseMessage;
import com.ontotext.graphdb.gpt.quota.GraphDBTokenQuotaManager;
import com.ontotext.graphdb.gpt.quota.QuotaUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GptAssistantChat
extends GptChat {
    final AssistantsClient assistantsOpenAIClient;
    final AssistantsGptClient assistantsService;
    final ConversationGptClient conversationService;
    ConcurrentMap<String, ChatRunner> threadChatRunner = new ConcurrentHashMap<String, ChatRunner>();
    @VisibleForTesting
    final Cache<String, ChatRunner> chatRunners = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private final Cache<String, ConversationResponse> chatWithoutMessagesCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(1000L).expireAfterWrite(60L, TimeUnit.MINUTES).build();
    private static final Logger logger = LoggerFactory.getLogger(GptAssistantChat.class);

    public GptAssistantChat(SemanticDataManagement dataManagement) {
        super(dataManagement);
        this.assistantsOpenAIClient = this.prepareAssistantsClient();
        this.assistantsService = new AssistantsGptClient(this.assistantsOpenAIClient);
        this.conversationService = new ConversationGptClient(this.assistantsOpenAIClient);
    }

    @VisibleForTesting
    protected GptAssistantChat(AssistantsClient client, AssistantsGptClient assService, ConversationGptClient convService, SemanticDataManagement dataManagement) {
        super(dataManagement);
        this.assistantsOpenAIClient = client;
        this.assistantsService = assService;
        this.conversationService = convService;
    }

    @Override
    protected void editAgentFingerprint(AgentConfig agentConfig, RepositoryConnection connection) {
        this.assistantsService.updateAssistantInstructions(agentConfig, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConversationResponse getConversationResponse(String threadId, String question, String assistantId, Integer tzOffset, AgentConfig agentConfig) {
        this.conversationService.getThreadWithSecurity(threadId);
        ChatRunner chatRunner = new ChatRunner(this, threadId, question, agentConfig, arg_0 -> this.chatRunners.invalidate(arg_0));
        this.threadChatRunner.put(threadId, chatRunner);
        try {
            ConversationResponse conversationResponse = this.processChatRun(chatRunner, threadId, tzOffset);
            return conversationResponse;
        }
        finally {
            this.threadChatRunner.remove(threadId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConversationResponse continueChat(String threadId, String runId, String agentId, Integer tzOffset) {
        try {
            GraphDBTokenQuotaManager.getInstance().validateQuotaOrThrow();
            logger.debug("TTYG continue chat {}: {}", (Object)threadId, (Object)runId);
            this.conversationService.getThreadWithSecurity(threadId);
            ChatRunner chatRunner = (ChatRunner)this.chatRunners.getIfPresent((Object)runId);
            if (chatRunner == null) {
                throw new IllegalStateException("No chat runner found for run id " + runId);
            }
            this.threadChatRunner.put(threadId, chatRunner);
            ConversationResponse response = this.processChatRun(chatRunner, threadId, tzOffset);
            logger.debug("TTYG continue chat {} OK: {}", (Object)threadId, (Object)runId);
            ConversationResponse conversationResponse = response;
            return conversationResponse;
        }
        finally {
            this.threadChatRunner.remove(threadId);
        }
    }

    private ConversationResponse processChatRun(ChatRunner chatRunner, String threadId, Integer tzOffset) {
        ChatRunner.ChatRunnerResult result = chatRunner.getNextResult(tzOffset);
        String continueRunId = result.getContinueRunId();
        if (continueRunId != null) {
            this.chatRunners.put((Object)continueRunId, (Object)chatRunner);
        }
        ConversationResponse conversation = this.conversationService.getConversationWithoutMessages(threadId);
        conversation.setContinueRunId(continueRunId);
        Usage usage = result.getUsage();
        conversation.setUsage(usage);
        for (ThreadMessage message : result.getMessages()) {
            Map metadata = message.getMetadata();
            metadata.put("graphdb.usage", JSONUtil.toJSON(result.getUsage()));
            this.assistantsOpenAIClient.updateMessage(threadId, message.getId(), metadata);
        }
        this.conversationService.addConversationMessages(conversation, result.getMessages(), null);
        usage = result.getUsage();
        conversation.setUsage(usage);
        if (usage != null) {
            QuotaUtils.consumeTokens((long)usage.getPromptTokens(), (long)usage.getCompletionTokens());
        }
        return conversation;
    }

    protected Header getAuthHeader() {
        Pair header = LLMConfig.getLLMAuth();
        if (header == null) {
            return null;
        }
        return new Header((String)header.getKey(), (String)header.getValue());
    }

    private AssistantsClient prepareAssistantsClient() {
        String chatUrl;
        AssistantsClientBuilder acb = new AssistantsClientBuilder();
        Header authHeader = this.getAuthHeader();
        Map openAIHeaders = ChatModelFactory.getOpenAIHeaders();
        if (!openAIHeaders.isEmpty() || authHeader != null) {
            ClientOptions co = new ClientOptions();
            LinkedList<Header> headers = new LinkedList<Header>(openAIHeaders.entrySet().stream().map(pair -> new Header((String)pair.getKey(), (String)pair.getValue())).toList());
            co.setHeaders(headers);
            if (authHeader != null) {
                acb.credential(new KeyCredential(LLMConfig.getLLMApiKeyOrThrow()));
                headers.add(authHeader);
            }
            acb.clientOptions(co);
        }
        if ((chatUrl = LLMConfig.getLLMUrl()) != null) {
            acb.endpoint(chatUrl);
        }
        acb.httpClient(HttpClient.createDefault((HttpClientOptions)new HttpClientOptions().setResponseTimeout(Duration.ofSeconds(SystemConfig.getApiTimeout()))));
        return acb.buildClient();
    }

    @Override
    public GptChatMessage createConversation() {
        logger.debug("TTYG createThread");
        AssistantThread conversation = this.conversationService.createConversation();
        GptChatMessage response = new GptChatMessage();
        response.setConversationId(conversation.getId());
        logger.debug("TTYG createThread => {}", (Object)conversation.getId());
        return response;
    }

    @Override
    public ConversationResponse renameConversation(String threadId, String name) {
        logger.debug("TTYG renameThread {}: {}", (Object)threadId, (Object)name);
        ConversationResponse response = this.conversationService.renameConversation(threadId, name);
        this.chatWithoutMessagesCache.put((Object)response.getId(), (Object)response);
        logger.debug("TTYG renameThread {}: {} => OK", (Object)threadId, (Object)name);
        return response;
    }

    @Override
    public ConversationResponse getConversation(String threadId) {
        return this.getConversation(threadId, SystemConfig.getMessageLimit());
    }

    private ConversationResponse getConversation(String threadId, Integer limit) {
        logger.debug("TTYG getChat: {}", (Object)threadId);
        try {
            ConversationResponse result = this.conversationService.getConversationWithoutMessages(threadId);
            this.conversationService.addAllConversationMessages(result, limit);
            ConversationResponse resultForCache = new ConversationResponse();
            resultForCache.setId(threadId);
            resultForCache.setName(result.getName());
            resultForCache.setTimestamp(result.getTimestamp());
            this.chatWithoutMessagesCache.put((Object)threadId, (Object)resultForCache);
            logger.debug("TTYG getChat: {} => OK", (Object)threadId);
            return result;
        }
        catch (ResourceNotFoundException | NonExistentResourceRequested e) {
            this.chatWithoutMessagesCache.invalidate((Object)threadId);
            throw e;
        }
    }

    @Override
    public List<ConversationResponse> getConversations(Set<String> conversations, Consumer<String> onChatNotFound) {
        logger.debug("TTYG getChats: {} (size)", (Object)conversations.size());
        ArrayList<ConversationResponse> responses = new ArrayList<ConversationResponse>();
        int cacheHits = 0;
        for (String conversation : conversations) {
            ConversationResponse response;
            block4: {
                response = (ConversationResponse)this.chatWithoutMessagesCache.getIfPresent((Object)conversation);
                if (response == null) {
                    try {
                        response = this.conversationService.getConversationWithoutMessages(conversation);
                        this.chatWithoutMessagesCache.put((Object)conversation, (Object)response);
                        break block4;
                    }
                    catch (ResourceNotFoundException | NonExistentResourceRequested e) {
                        logger.warn("List chats: chat not found: {}", (Object)conversation);
                        if (!(e instanceof ResourceNotFoundException) || conversation.startsWith("thread_gdb_")) continue;
                        onChatNotFound.accept(conversation);
                        continue;
                    }
                }
                ++cacheHits;
            }
            responses.add(response);
        }
        logger.debug("TTYG getChats: {} (size) => {}/{} cache hits", new Object[]{conversations.size(), responses.size(), cacheHits});
        return responses;
    }

    @Override
    public ConversationResponse deleteConversation(String id) {
        logger.debug("TTYG deleteChat: {}", (Object)id);
        this.conversationService.getThreadWithSecurity(id);
        ThreadDeletionStatus status = this.assistantsOpenAIClient.deleteThread(id);
        ConversationResponse response = new ConversationResponse();
        if (status != null) {
            response.setId(status.getId());
        }
        this.chatWithoutMessagesCache.invalidate((Object)id);
        logger.debug("TTYG deleteChat: {} => OK", (Object)id);
        return response;
    }

    @Override
    public CancelResponse cancelChat(String threadId) {
        try {
            super.cancelChat(threadId);
            ChatRunner runner = this.supplyRunnerAsync(threadId).get(SystemConfig.getCancelRunWait(), TimeUnit.SECONDS);
            return runner.cancel();
        }
        catch (TimeoutException e) {
            throw new GenericServerException("Timeout waiting for chat to start.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GenericServerException("Interrupted waiting for chat to start in conversation " + threadId);
        }
        catch (ExecutionException e) {
            throw new GenericServerException("Execution exception during chat in conversation " + threadId);
        }
    }

    protected CompletableFuture<ChatRunner> supplyRunnerAsync(String id) {
        return CompletableFuture.supplyAsync(() -> {
            ChatRunner r;
            while ((r = (ChatRunner)this.threadChatRunner.get(id)) == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CompletionException(e);
                }
            }
            return r;
        }, this.cancellationExecutor);
    }

    @Override
    public ExplainResponseMessage explainResponse(ExplainRequestMessage explainRequestMessage) {
        RunStatus runStatus;
        String threadId = explainRequestMessage.getConversationId();
        AssistantThread thread = this.conversationService.getThreadWithSecurity(threadId);
        String messageId = explainRequestMessage.getAnswerId();
        logger.debug("TTYG explain: {}///{}", (Object)messageId, (Object)threadId);
        ExplainResponseMessage explainResponse = new ExplainResponseMessage();
        explainResponse.setConversationId(threadId);
        explainResponse.setAnswerId(messageId);
        explainResponse.setQueryMethods(new ArrayList());
        if (thread == null || messageId == null) {
            return explainResponse;
        }
        String runId = this.conversationService.getMessage(thread, messageId).getRunId();
        ThreadRun threadRun = this.assistantsOpenAIClient.getRun(threadId, runId);
        if (threadRun != null && ((runStatus = this.assistantsOpenAIClient.getRun(threadId, runId).getStatus()).equals((Object)RunStatus.CANCELLED) || runStatus.equals((Object)RunStatus.FAILED) || runStatus.equals((Object)RunStatus.EXPIRED))) {
            explainResponse.setAnswerId(null);
            return explainResponse;
        }
        List runSteps = this.assistantsOpenAIClient.listRunSteps(threadId, runId, null, ListSortOrder.DESCENDING, null, null).getData();
        HashMap<String, AgentConfig> agentConfigs = new HashMap<String, AgentConfig>();
        LinkedList<ExplainMessage> responses = new LinkedList<ExplainMessage>();
        String stepMessageId = null;
        for (RunStep runStep : runSteps) {
            RunStepDetails details = runStep.getStepDetails();
            if (details instanceof RunStepMessageCreationDetails) {
                stepMessageId = ((RunStepMessageCreationDetails)details).getMessageCreation().getMessageId();
                continue;
            }
            if (!(details instanceof RunStepToolCallDetails) || !messageId.equals(stepMessageId)) continue;
            RunStepToolCallDetails toolCallDetails = (RunStepToolCallDetails)details;
            AgentConfig agentConfig = agentConfigs.computeIfAbsent(runStep.getAssistantId(), this.assistantsService::getAgentConfig);
            responses.addAll(0, this.extractExplainResponses(toolCallDetails, agentConfig));
        }
        explainResponse.setQueryMethods(responses);
        logger.debug("TTYG explain: {}///{} => OK", (Object)messageId, (Object)threadId);
        return explainResponse;
    }

    List<ExplainMessage> extractExplainResponses(RunStepToolCallDetails toolCallDetails, AgentConfig agentConfig) {
        ArrayList<ExplainMessage> responses = new ArrayList<ExplainMessage>();
        for (RunStepToolCall toolCall : toolCallDetails.getToolCalls()) {
            if (!(toolCall instanceof RunStepFunctionToolCall)) continue;
            ExplainMessage response = new ExplainMessage();
            String functionName = ((RunStepFunctionToolCall)toolCall).getFunction().getName();
            Tool tool = this.getToolForExplain(agentConfig, functionName);
            String arguments = ((RunStepFunctionToolCall)toolCall).getFunction().getArguments();
            Map<String, Object> parameters = this.parseCallParametersJson(arguments);
            response.setName(functionName);
            response.setQuery(tool.getNativeQuery(parameters));
            response.setQueryType(tool.getType().getNativeQueryType());
            response.setRawQuery(tool.getRawQuery(parameters));
            String output = this.getErrorOutput(((RunStepFunctionToolCall)toolCall).getFunction().getOutput());
            if (output != null) {
                response.setErrorOutput(output);
            }
            responses.add(response);
        }
        return responses;
    }

    @Override
    public ConversationResponse exportChat(String id) {
        logger.debug("TTYG exportChat: {}", (Object)id);
        ConversationResponse result = this.getConversation(id, null);
        logger.debug("TTYG exportChat: {} => OK", (Object)id);
        return result;
    }

    @Override
    public AssistantsResponse createAgent(AssistantsRequest assistantsRequest) {
        try (RepositoryConnection connection = this.getRepositoryConnection(assistantsRequest.getRepositoryId());){
            logger.debug("TTYG createAgent: {} ({})", (Object)assistantsRequest.getName(), (Object)assistantsRequest.getRepositoryId());
            AssistanceAgentConfig agentConfig = this.agentConfigFromRequest(assistantsRequest, connection, AssistanceAgentConfig::new);
            AgentConfig result = this.assistantsService.createAssistant(agentConfig, connection);
            logger.debug("TTYG createAgent: {} ({}) => {}", new Object[]{assistantsRequest.getName(), assistantsRequest.getRepositoryId(), result.getId()});
            AssistantsResponse assistantsResponse = this.assistantsResponseFromAgentConfig(result);
            return assistantsResponse;
        }
    }

    @Override
    public AssistantsResponse editAgent(AssistantsRequest assistantsRequest) {
        try (RepositoryConnection connection = this.getRepositoryConnection(assistantsRequest.getRepositoryId());){
            logger.debug("TTYG editAgent {}: {} ({})", new Object[]{assistantsRequest.getId(), assistantsRequest.getName(), assistantsRequest.getRepositoryId()});
            AssistanceAgentConfig agentConfig = this.agentConfigFromRequest(assistantsRequest, connection, AssistanceAgentConfig::new);
            AgentConfig result = this.assistantsService.editAssistant(agentConfig, connection);
            logger.debug("TTYG editAgent {}: {} ({}) => OK", new Object[]{assistantsRequest.getId(), assistantsRequest.getName(), assistantsRequest.getRepositoryId()});
            AssistantsResponse assistantsResponse = this.assistantsResponseFromAgentConfig(result);
            return assistantsResponse;
        }
    }

    @Override
    public void deleteAgent(String agentId) {
        logger.debug("TTYG deleteAgent {}", (Object)agentId);
        this.assistantsService.deleteAssistant(agentId);
        logger.debug("TTYG deleteAgent {} => OK", (Object)agentId);
    }

    @Override
    public List<AssistantsResponse> getAllAgents() {
        logger.debug("TTYG getAgents");
        List<AssistantsResponse> result = this.assistantsService.getAgents().stream().map(this::assistantsResponseFromAgentConfig).toList();
        logger.debug("TTYG getAgents => OK");
        return result;
    }

    @Override
    public AssistantsResponse getAgent(String agentId) {
        logger.debug("TTYG getAgent: {}", (Object)agentId);
        AgentConfig result = this.assistantsService.getAgent(agentId);
        logger.debug("TTYG getAgent: {} => OK", (Object)agentId);
        return this.assistantsResponseFromAgentConfig(result);
    }

    @Override
    public AgentConfig getAgentConfig(String agentId) {
        return this.assistantsService.getAgentConfig(agentId);
    }

    @Override
    public AgentInstructions explainAgentInstructions(AssistantsRequest assistantsRequest) {
        try (RepositoryConnection connection = this.getRepositoryConnection(assistantsRequest.getRepositoryId());){
            logger.debug("TTYG explainAgent {}: {} ({})", new Object[]{assistantsRequest.getId(), assistantsRequest.getName(), assistantsRequest.getRepositoryId()});
            AssistanceAgentConfig agentConfig = this.agentConfigFromRequest(assistantsRequest, connection, AssistanceAgentConfig::new);
            AgentInstructions result = this.assistantsService.explainAgentInstructions(agentConfig, connection);
            logger.debug("TTYG explainAgent {}: {} ({}) => OK", new Object[]{assistantsRequest.getId(), assistantsRequest.getName(), assistantsRequest.getRepositoryId()});
            AgentInstructions agentInstructions = result;
            return agentInstructions;
        }
    }
}

