/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.assistants;

import com.azure.ai.openai.assistants.AssistantsClient;
import com.azure.ai.openai.assistants.models.Assistant;
import com.azure.ai.openai.assistants.models.AssistantCreationOptions;
import com.azure.ai.openai.assistants.models.CreateToolResourcesOptions;
import com.azure.ai.openai.assistants.models.ListSortOrder;
import com.azure.ai.openai.assistants.models.PageableList;
import com.azure.ai.openai.assistants.models.ToolDefinition;
import com.azure.ai.openai.assistants.models.UpdateAssistantOptions;
import com.azure.ai.openai.assistants.models.UpdateToolResourcesOptions;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.forest.gpt.ttyg.AgentInstructions;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.agent.config.AssistanceAgentConfig;
import com.ontotext.forest.gpt.ttyg.exceptions.GenericClientException;
import com.ontotext.forest.gpt.ttyg.exceptions.NonExistentResourceRequested;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.configs.SystemConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssistantsGptClient {
    public final Logger logger = LoggerFactory.getLogger(AssistantsGptClient.class);
    private final AssistantsClient assistantsClient;

    public AssistantsGptClient(AssistantsClient assistantsOpenAIClient) {
        this.assistantsClient = assistantsOpenAIClient;
    }

    public AgentConfig createAssistant(AgentConfig agentConfig, RepositoryConnection connection) {
        String instructions = agentConfig.toAssistantInstructions(connection);
        AssistantCreationOptions assistantCreationOptions = new AssistantCreationOptions(agentConfig.getModel()).setName(agentConfig.getName()).setDescription("").setInstructions(instructions).setTools(this.convertChatGptAgentsExtractionMethodsToAssistantTools(agentConfig)).setToolResources(new CreateToolResourcesOptions()).setTemperature(Double.valueOf(agentConfig.getTemperature())).setTopP(Double.valueOf(agentConfig.getTopP())).setMetadata(agentConfig.toMetadata());
        Assistant assistant = this.assistantsClient.createAssistant(assistantCreationOptions);
        return this.agentConfigFromAssistant(assistant);
    }

    public AgentConfig editAssistant(AgentConfig agentConfig, RepositoryConnection connection) {
        this.getAssistantOrThrow(agentConfig.getId());
        String instructions = agentConfig.toAssistantInstructions(connection);
        UpdateAssistantOptions updateAssistantOptions = new UpdateAssistantOptions().setModel(agentConfig.getModel()).setName(agentConfig.getName()).setDescription("").setInstructions(instructions).setTools(this.convertChatGptAgentsExtractionMethodsToAssistantTools(agentConfig)).setToolResources(new UpdateToolResourcesOptions()).setTemperature(Double.valueOf(agentConfig.getTemperature())).setTopP(Double.valueOf(agentConfig.getTopP())).setMetadata(agentConfig.toMetadata());
        Assistant assistant = this.assistantsClient.updateAssistant(agentConfig.getId(), updateAssistantOptions);
        return this.agentConfigFromAssistant(assistant);
    }

    public void deleteAssistant(String agentId) {
        this.getAssistantOrThrow(agentId, false);
        this.assistantsClient.deleteAssistant(agentId);
    }

    private List<Assistant> getAssistants() {
        PageableList allAssists;
        ArrayList<Assistant> response = new ArrayList<Assistant>();
        String after = null;
        do {
            allAssists = this.assistantsClient.listAssistants(Integer.valueOf(100), ListSortOrder.DESCENDING, after, null);
            response.addAll(allAssists.getData());
            after = allAssists.getLastId();
        } while (allAssists.isHasMore());
        return response;
    }

    public List<AgentConfig> getAgents() {
        return this.getAssistants().stream().filter(assistant -> this.hasAssistantAccess((Assistant)assistant, false)).map(this::agentConfigFromAssistant).collect(Collectors.toList());
    }

    public AgentConfig getAgentConfig(String agentId) {
        return this.agentConfigFromAssistant(this.getAssistantOrThrow(agentId));
    }

    private Assistant getAssistantOrThrow(String agentId) {
        return this.getAssistantOrThrow(agentId, true);
    }

    private Assistant getAssistantOrThrow(String agentId, boolean activeOnly) {
        if (agentId == null || agentId.isEmpty()) {
            throw new GenericClientException("Agent ID cannot be null or empty. It should be provided.");
        }
        Assistant assistant = this.assistantsClient.getAssistant(agentId);
        if (!this.hasAssistantAccess(assistant, activeOnly)) {
            throw new NonExistentResourceRequested("Agent ID " + agentId + " not found.");
        }
        return assistant;
    }

    public AgentConfig getAgent(String agentId) {
        return this.agentConfigFromAssistant(this.getAssistantOrThrow(agentId));
    }

    public AgentInstructions explainAgentInstructions(AgentConfig agentConfig, RepositoryConnection connection) {
        this.getAssistantOrThrow(agentConfig.getId());
        return agentConfig.toAgentInstructions(connection);
    }

    private List<ToolDefinition> convertChatGptAgentsExtractionMethodsToAssistantTools(AgentConfig agentConfig) {
        ArrayList<ToolDefinition> tools = new ArrayList<ToolDefinition>();
        agentConfig.getTools().entrySet().stream().filter(e -> ((Tool)e.getValue()).isEnabled()).forEach(e -> tools.add((ToolDefinition)((Tool)e.getValue()).toFunctionToolDefinition()));
        return tools;
    }

    @VisibleForTesting
    AgentConfig agentConfigFromAssistant(Assistant assistant) {
        AssistanceAgentConfig agentConfig = new AssistanceAgentConfig();
        agentConfig.setId(assistant.getId());
        agentConfig.setName(assistant.getName());
        agentConfig.setModel(assistant.getModel());
        agentConfig.setTemperature(assistant.getTemperature());
        agentConfig.setTopP(assistant.getTopP());
        agentConfig.setFromMetadata(assistant.getMetadata());
        return agentConfig;
    }

    private boolean hasAssistantAccess(Assistant assistant, boolean activeOnly) {
        try {
            String baseMetadataJson = (String)assistant.getMetadata().get("graphdb.ttyg");
            if (baseMetadataJson == null) {
                this.logger.debug("Skipped agent without GraphDB metadata: {}", (Object)assistant.getId());
                return false;
            }
            Map baseMetadata = JSONUtil.parseJSON(baseMetadataJson);
            Object version = baseMetadata.get("version");
            if (!(version instanceof Number)) {
                this.logger.debug("Skipped agent with wrong version {}: {}", (Object)assistant.getId(), version);
                return false;
            }
            if (((Number)version).intValue() > 3 && activeOnly) {
                throw new GenericClientException("Agent version " + String.valueOf(version) + " is newer than this GraphDB's version.");
            }
            Object installationId = baseMetadata.get("installationId");
            if (!SystemConfig.matchesInstallationId((String)((String)installationId))) {
                this.logger.debug("Skipped agent with wrong installationId {}: {}", (Object)assistant.getId(), installationId);
                return false;
            }
            Object repositoryId = baseMetadata.get("repositoryId");
            if (!GraphDBHTTPContext.getAuthenticatedUser().hasRepositoryAccess((String)repositoryId, false)) {
                this.logger.debug("Skipped agent without access to repository {}: {}", (Object)assistant.getId(), repositoryId);
                return false;
            }
        }
        catch (GenericClientException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.logger.error("Unable to check access to OpenAI Assistant", (Throwable)e);
            return false;
        }
        return true;
    }

    public Assistant updateAssistantInstructions(AgentConfig agentConfig, RepositoryConnection connection) {
        return this.assistantsClient.updateAssistant(agentConfig.getId(), new UpdateAssistantOptions().setInstructions(agentConfig.toAssistantInstructions(connection)).setMetadata(agentConfig.toMetadata()));
    }
}

