/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt;

import com.azure.core.exception.AzureException;
import com.ontotext.forest.gpt.GptChatService;
import com.ontotext.forest.gpt.chat.GptChatMessage;
import com.ontotext.forest.gpt.conversations.CancelResponse;
import com.ontotext.forest.gpt.conversations.ContinueChatRequest;
import com.ontotext.forest.gpt.conversations.ConversationRequest;
import com.ontotext.forest.gpt.conversations.ConversationResponse;
import com.ontotext.forest.gpt.model.AssistantsRequest;
import com.ontotext.forest.gpt.model.AssistantsRequestDefaultValues;
import com.ontotext.forest.gpt.model.AssistantsResponse;
import com.ontotext.forest.gpt.ttyg.AzureUtil;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.exceptions.NonExistentResourceRequested;
import com.ontotext.forest.gpt.ttyg.exceptions.TTYGException;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.gpt.explain.ExplainRequestMessage;
import com.ontotext.graphdb.gpt.explain.ExplainResponseMessage;
import com.ontotext.trree.statistics.SystemStatisticsCollector;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/rest/ttyg"})
@Tag(name="Talk to Your Graph", description="Talk to Your Graph low-level API")
public class RetrievalChatController {
    private final GptChatService chatService;
    private final Logger logger = LoggerFactory.getLogger(RetrievalChatController.class);
    static final String ERROR_UNABLE_TO_CONNECT = "Unable to connect to the server";

    @Autowired
    public RetrievalChatController(GptChatService gptChatService) {
        this.chatService = gptChatService;
    }

    @Hidden
    @Operation(summary="Create an agent")
    @RequestMapping(value={"/agents"}, method={RequestMethod.POST})
    public ResponseEntity<?> createAgent(@RequestBody AssistantsRequest assistantsRequest) {
        AssistantsResponse response;
        try {
            response = this.chatService.createAgent(assistantsRequest);
        }
        catch (RuntimeException exception) {
            return this.handleException("Create agent", exception);
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @Operation(summary="Edit an agent")
    @RequestMapping(value={"/agents"}, method={RequestMethod.PUT})
    public ResponseEntity<?> editAgent(@RequestBody AssistantsRequest assistantsRequest) {
        AssistantsResponse response;
        try {
            response = this.chatService.editAgent(assistantsRequest);
        }
        catch (RuntimeException exception) {
            return this.handleException("Edit agent " + assistantsRequest.getId(), exception);
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @Operation(summary="Delete an agent")
    @RequestMapping(value={"/agents/{agentId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteAgent(@PathVariable(value="agentId") String agentId) {
        try {
            this.chatService.deleteAgent(agentId);
        }
        catch (RuntimeException exception) {
            return this.handleException("Delete agent " + agentId, exception);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @Operation(summary="List agents")
    @RequestMapping(value={"/agents"}, method={RequestMethod.GET})
    public ResponseEntity<?> listAgents() {
        try {
            List<AssistantsResponse> response = this.chatService.getAllAgents();
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException("List agents", exception);
        }
    }

    @Hidden
    @Operation(summary="Get an agent")
    @RequestMapping(value={"/agents/{agentId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getAgent(@PathVariable(value="agentId") String agentId) {
        AssistantsResponse response;
        try {
            response = this.chatService.getAgent(agentId);
        }
        catch (RuntimeException exception) {
            return this.handleException("Get agent " + agentId, exception);
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @Operation(summary="Get a default agent")
    @RequestMapping(value={"/agents/default"}, method={RequestMethod.GET})
    public ResponseEntity<?> getAgent() {
        AssistantsRequestDefaultValues response;
        try {
            response = this.chatService.getDefaultAgent();
        }
        catch (RuntimeException exception) {
            return this.handleException("Get default agent", exception);
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @Operation(summary="Explain agent instructions")
    @RequestMapping(value={"/agents/explain"}, method={RequestMethod.POST})
    public ResponseEntity<?> agentInstructions(@RequestBody AssistantsRequest assistantsRequest) {
        try {
            return new ResponseEntity((Object)this.chatService.explainAgentInstructions(assistantsRequest), (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException("Explain agent " + assistantsRequest.getId(), exception);
        }
    }

    @Operation(summary="Call agent query method/assistant tool")
    @RequestMapping(value={"/agents/{agentId}/{toolType}"}, method={RequestMethod.POST}, consumes={"text/plain"}, produces={"text/plain"})
    public ResponseEntity<?> callTool(@PathVariable String agentId, @PathVariable String toolType, @RequestBody String arguments) {
        try {
            ToolType toolTypeValue;
            try {
                toolTypeValue = ToolType.fromString(toolType);
            }
            catch (IllegalArgumentException e) {
                throw new NonExistentResourceRequested("No such tool: " + toolType);
            }
            String response = this.chatService.callTool(agentId, toolTypeValue, arguments);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException("Call tool: " + toolType, exception);
        }
    }

    @Hidden
    @Operation(summary="Create chat")
    @PostMapping(value={"/chats"})
    public ResponseEntity<?> createChat(@RequestBody ConversationRequest request) {
        String operation = "Create chat";
        try {
            GptChatMessage messageResponse = this.chatService.createConversation(request.getAgentId());
            messageResponse.setName("New chat");
            return new ResponseEntity((Object)messageResponse, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException(operation, exception);
        }
    }

    @Hidden
    @Operation(summary="Send message")
    @PostMapping(value={"/chats/question"})
    public ResponseEntity<?> chat(@RequestBody ConversationRequest request) {
        String operation = "Send message";
        try {
            SystemStatisticsCollector.getInstance().incrementTtygCalls();
            String id = request.getConversationId();
            if (id != null) {
                if (request.getAgentId() != null && request.getQuestion() != null) {
                    ConversationResponse answer = this.chatService.chat(id, request.getQuestion(), request.getAgentId(), request.getTzOffset());
                    this.applyLastRunChangesIfNeeded(answer);
                    return new ResponseEntity((Object)answer, (HttpStatusCode)HttpStatus.OK);
                }
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        catch (RuntimeException exception) {
            return this.handleException(operation, exception);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Hidden
    @Operation(summary="Continue chat response")
    @RequestMapping(value={"/chats/continue"}, method={RequestMethod.POST})
    public ResponseEntity<?> continueChat(@RequestBody ContinueChatRequest request) {
        String conversationId = request.getConversationId();
        String runId = request.getRunId();
        try {
            if (conversationId != null && runId != null) {
                ConversationResponse answer = this.chatService.continueChat(conversationId, runId, request.getAgentId(), request.getTzOffset());
                this.applyLastRunChangesIfNeeded(answer);
                return new ResponseEntity((Object)answer, (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (RuntimeException exception) {
            return this.handleException("Continue chat", exception);
        }
    }

    @Hidden
    @Operation(summary="Rename a chat")
    @RequestMapping(value={"/chats/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<?> updateConversation(@RequestBody ConversationRequest conversationRequest, @PathVariable String id) {
        try {
            if (conversationRequest.getName() != null) {
                ConversationResponse response = this.chatService.renameConversation(id, conversationRequest.getName());
                return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)"Pass your new chat name.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (RuntimeException exception) {
            return this.handleException("Rename chat " + id, exception);
        }
    }

    @Hidden
    @Operation(summary="Get a chat")
    @RequestMapping(value={"/chats/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getConversation(@PathVariable String id) {
        try {
            ConversationResponse response = this.chatService.getConversation(id);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException("Get chat " + id, exception);
        }
    }

    @Hidden
    @Operation(summary="List chats")
    @RequestMapping(value={"/chats"}, method={RequestMethod.GET})
    public ResponseEntity<?> getConversations() {
        try {
            List<ConversationResponse> response = this.chatService.getConversations();
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException("List chats", exception);
        }
    }

    @Hidden
    @Operation(summary="Delete a chat")
    @RequestMapping(value={"/chats/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteConversation(@PathVariable String id) {
        try {
            ConversationResponse response = this.chatService.deleteConversation(id);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException("Delete chat " + id, exception);
        }
    }

    @Hidden
    @Operation(summary="Cancel the current chat")
    @PostMapping(value={"/chats/{id}/cancel"})
    public ResponseEntity<?> cancelConversation(@PathVariable String id) {
        try {
            CancelResponse response = this.chatService.cancelRun(id);
            if (response == null) {
                return ResponseEntity.noContent().build();
            }
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException(String.format("Cancelling chat failed due to: %s", exception.getMessage()), exception);
        }
    }

    @Hidden
    @Operation(summary="Explain response")
    @RequestMapping(value={"/chats/explain"}, method={RequestMethod.POST})
    public ResponseEntity<?> explainResponse(@RequestBody ExplainRequestMessage explainRequestMessage) {
        try {
            ExplainResponseMessage response = this.chatService.explainResponse(explainRequestMessage);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException("Explain last response", exception);
        }
    }

    @Hidden
    @Operation(summary="Export chat")
    @RequestMapping(value={"/chats/export/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<?> exportChat(@PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] responseBody;
            String finalFilename;
            ConversationResponse conversationResponse = this.chatService.exportChat(id);
            String acceptHeader = request.getHeader("Accept");
            String chatName = conversationResponse.getName();
            if (chatName.endsWith("...")) {
                chatName = chatName.substring(0, chatName.length() - 3);
            }
            String baseFilename = chatName + "_" + conversationResponse.getId();
            if (acceptHeader != null && acceptHeader.contains("application/json")) {
                finalFilename = RetrievalChatController.sanitizeFilename(baseFilename, "json");
                String jsonText = JSONUtil.prettyPrintJSON(conversationResponse);
                responseBody = jsonText.getBytes(StandardCharsets.UTF_8);
            } else {
                finalFilename = RetrievalChatController.sanitizeFilename(baseFilename, "txt");
                String plainText = this.convertChatToPlainText(conversationResponse);
                responseBody = plainText.getBytes(StandardCharsets.UTF_8);
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDisposition(ContentDisposition.attachment().filename(finalFilename).build());
            return new ResponseEntity((Object)responseBody, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException exception) {
            return this.handleException("Export chat " + id, exception);
        }
    }

    public static String sanitizeFilename(String input, String extension) {
        if (input == null || ((String)input).isBlank()) {
            input = "chat_export" + System.currentTimeMillis();
        }
        Object sanitized = ((String)input).replaceAll("[\\p{Cntrl}]", "");
        sanitized = ((String)sanitized).replaceAll("[\\\\/:*?\"<>|]", "_");
        sanitized = ((String)sanitized).replaceAll("[^\\x20-\\x7E]", "_");
        if (((String)(sanitized = ((String)sanitized).trim())).isEmpty()) {
            sanitized = "chat_export" + System.currentTimeMillis();
        }
        int maxNameLength = 255 - extension.length() - 1;
        if (((String)sanitized).length() > maxNameLength) {
            sanitized = ((String)sanitized).substring(0, maxNameLength).trim();
        }
        return (String)sanitized + "." + extension;
    }

    public String convertChatToPlainText(ConversationResponse chat) {
        StringBuilder plainText = new StringBuilder();
        plainText.append("Chat ID: ").append(chat.getId()).append("\n");
        plainText.append("Name: ").append(chat.getName()).append("\n");
        plainText.append("Timestamp: ").append(chat.getTimestamp()).append("\n");
        plainText.append("Messages:\n");
        plainText.append("-------------------\n");
        List<GptChatMessage> messages = chat.getMessages();
        for (GptChatMessage message : messages) {
            if (message.getId() == null) continue;
            plainText.append("Message ID: ").append(message.getId()).append("\n");
            plainText.append("Role: ").append(message.getRole()).append("\n");
            plainText.append("Agent ID: ").append(message.getAgentId()).append("\n");
            plainText.append("Timestamp: ").append(message.getTimestamp()).append("\n");
            plainText.append("Content: ").append(message.getMessage()).append("\n");
            plainText.append("-------------------\n");
        }
        return plainText.toString();
    }

    private void applyLastRunChangesIfNeeded(ConversationResponse answer) {
        boolean isDefaultName;
        if (answer.getContinueRunId() != null) {
            return;
        }
        List<GptChatMessage> msgs = answer.getMessages();
        String name = answer.getName();
        boolean bl = isDefaultName = name == null || "New chat".equals(name);
        if (!isDefaultName) {
            return;
        }
        if (!msgs.isEmpty()) {
            String generatedName = this.chatService.generateConversationName(msgs.getLast().getMessage());
            answer.setName(generatedName);
            this.chatService.renameConversation(answer.getId(), generatedName);
            return;
        }
        this.chatService.renameConversation(answer.getId(), "New chat");
    }

    private ResponseEntity<String> handleException(String operation, Exception exception) {
        this.logger.error("TTYG error: {}", (Object)operation, (Object)exception);
        if (exception instanceof AzureException) {
            exception = AzureUtil.mapAzureException((AzureException)exception);
        }
        if (exception instanceof TTYGException) {
            return ResponseEntity.status((int)((TTYGException)exception).httpStatusCode()).body((Object)exception.getMessage());
        }
        if (exception instanceof IllegalArgumentException || exception instanceof MalformedQueryException) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)exception.getMessage());
        }
        if (exception instanceof UncheckedIOException && exception.getCause() instanceof UnknownHostException) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)String.join((CharSequence)" ", ERROR_UNABLE_TO_CONNECT, exception.getCause().getMessage()));
        }
        if (exception instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)exception;
            return ResponseEntity.status((HttpStatusCode)responseStatusException.getStatusCode()).body((Object)(StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{responseStatusException.getReason()}) ? responseStatusException.getReason() : responseStatusException.getMessage()));
        }
        if (exception instanceof AccessDeniedException) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)exception.getMessage());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)exception.getMessage());
    }
}

