/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.gpt.LLMService;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.exceptions.GenericClientException;
import com.ontotext.forest.gpt.ttyg.exceptions.NonExistentResourceRequested;
import com.ontotext.forest.gpt.ttyg.exceptions.TTYGException;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.forest.gpt.ttyg.tools.openapi.OpenApiTools;
import com.ontotext.graphdb.ttyg.tools.dify.DifyRequest;
import com.ontotext.graphdb.ttyg.tools.dify.DifyResponse;
import com.ontotext.trree.statistics.SystemStatisticsCollector;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/llm"})
@Tag(name="LLM integration", description="Low-level API for exposing GraphDB tools to LLMs via OpenAPI")
public class LLMController {
    private final LLMService llmService;
    private final SemanticDataManagement semanticDataManagement;
    private ProxyToRemoteSesame proxyToRemoteSesame;
    private final Logger logger = LoggerFactory.getLogger(LLMController.class);

    @Autowired
    public LLMController(LLMService gptChatService, SemanticDataManagement dataManagement, ProxyToRemoteSesame proxyToRemoteSesame) {
        this.llmService = gptChatService;
        this.semanticDataManagement = dataManagement;
        this.proxyToRemoteSesame = proxyToRemoteSesame;
    }

    @Operation(summary="Get OpenAPI description of LLM tools", description="Returns an OpenAPI document describing the tools available for a given LLM configuration.\nThe configuration is identified by its ID and type.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/yaml", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content})}, parameters={@Parameter(name="configType", description="The configuration type:\n    'ttyg' refers to tools defined in the preconfigured assistants in 'Talk to Your Graph' functionality;\n    'yaml' refers to tools defined in a static YAML file", in=ParameterIn.PATH, schema=@Schema(type="string", allowableValues={"yaml", "ttyg"}, example="yaml")), @Parameter(name="configId", description="The identifier of the LLM tool configuration", in=ParameterIn.PATH)})
    @GetMapping(value={"/tool/{configType}/{configId}"}, produces={"application/yaml"})
    public ResponseEntity<?> getOpenApiTools(@PathVariable String configId, @Validated @PathVariable String configType, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> {
            try {
                OpenApiTools openApiTools = this.llmService.getOpenApiTools(configId, configType, servletRequest.getRequestURL().toString());
                ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).contentType(MediaType.parseMediaType((String)"application/yaml; charset=UTF-8")).body((Object)mapper.writeValueAsString((Object)openApiTools));
            }
            catch (JsonProcessingException | RuntimeException e) {
                this.logger.error("LLM error: Get OpenAPI tools", e);
                throw e;
            }
        });
    }

    @Operation(summary="Call LLM tool", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})}, parameters={@Parameter(name="configType", description="The configuration type:\n    'ttyg' refers to tools defined in the preconfigured assistants in 'Talk to Your Graph' functionality;\n    'yaml' refers to tools defined in a static YAML file", in=ParameterIn.PATH, schema=@Schema(type="string", allowableValues={"yaml", "ttyg"}, example="yaml")), @Parameter(name="configId", description="The identifier of the LLM tool configuration", in=ParameterIn.PATH), @Parameter(name="toolType", description="The type of the tool to retrieve or operate on.", in=ParameterIn.PATH, schema=@Schema(type="string", allowableValues={"sparql_query", "fts_search", "similarity_search", "retrieval_search", "autocomplete_iri_discovery_search", "iri_discovery_search"}, example="sparql_query"))})
    @PostMapping(value={"/tool/{configType}/{configId}/{toolType}"}, consumes={"application/json"}, produces={"text/plain"})
    public String callLlmTool(@PathVariable String configType, @PathVariable String configId, @PathVariable String toolType, @RequestBody Map<String, Object> arguments, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (String)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded(arguments, servletRequest, servletResponse, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> {
            try {
                ToolType toolTypeValue;
                try {
                    toolTypeValue = ToolType.fromString(toolType);
                }
                catch (IllegalArgumentException e) {
                    throw new NonExistentResourceRequested("No such tool: " + toolType);
                }
                SystemStatisticsCollector.getInstance().incrementTtygRestToolCall();
                return this.llmService.callTool(configId, configType, toolTypeValue, JSONUtil.toJSON(arguments));
            }
            catch (RuntimeException e) {
                this.logger.error("LLM error: Call LLM tool: {}", (Object)toolType, (Object)e);
                throw e;
            }
        });
    }

    @Operation(summary="Dify API extension", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DifyResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})}, parameters={@Parameter(name="configType", description="The configuration type:\n    'ttyg' refers to tools defined in the preconfigured assistants in 'Talk to Your Graph' functionality;\n    'yaml' refers to tools defined in a static YAML file", in=ParameterIn.PATH, schema=@Schema(type="string", allowableValues={"yaml", "ttyg"}, example="yaml")), @Parameter(name="configId", description="The identifier of the LLM tool configuration", in=ParameterIn.PATH)})
    @PostMapping(value={"/{configType}/{configId}/dify"}, produces={"application/json"})
    public DifyResponse difyApiExtension(@PathVariable String configType, @PathVariable String configId, @RequestBody DifyRequest request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (DifyResponse)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)request, servletRequest, servletResponse, this.semanticDataManagement.getLocationFromHeaderOrThrow(), () -> {
            try {
                if ("ping".equals(request.point)) {
                    return new DifyResponse("pong");
                }
                if ("app.external_data_tool.query".equals(request.point)) {
                    String value = "";
                    String variable = (String)request.params.get("tool_variable");
                    SystemStatisticsCollector.getInstance().incrementTtygRestToolCall();
                    if (variable.startsWith("sparql_instructions")) {
                        value = this.llmService.getSparqlInstructions(configId, configType);
                    }
                    if (variable.startsWith("ontology")) {
                        value = this.llmService.getOntology(configId, configType);
                    }
                    return new DifyResponse(value);
                }
                throw new GenericClientException("No such point: " + request.point);
            }
            catch (RuntimeException e) {
                this.logger.error("LLM error: Dify API extension", (Throwable)e);
                throw e;
            }
        });
    }

    @ExceptionHandler(value={TTYGException.class})
    public ResponseEntity<?> handleTtygException(TTYGException ex) {
        return ResponseEntity.status((int)ex.httpStatusCode()).contentType(MediaType.TEXT_PLAIN).body((Object)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<?> handleGenericException(Exception ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)ex.getMessage());
    }
}

