/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt;

import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.raft.update.SystemUpdate;
import com.ontotext.raft.update.SystemUpdateProcessor;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class AgentSystemUpdate
implements SystemUpdate {
    private final String instructions;
    private String id;
    private String name;
    private String model;
    private double temperature;
    private double topP;
    private String fingerprint;
    private int contextSize;
    private Map<String, String> metadata;

    public AgentSystemUpdate(AgentConfig agentConfig, String instructions) {
        this.id = agentConfig.getId();
        this.name = agentConfig.getName();
        this.model = agentConfig.getModel();
        this.topP = agentConfig.getTopP();
        this.temperature = agentConfig.getTemperature();
        this.metadata = agentConfig.toMetadata();
        this.fingerprint = agentConfig.getFingerprint();
        this.contextSize = agentConfig.getContextSize();
        this.instructions = instructions;
    }

    public byte[] getBytes() {
        byte[] idBytes = this.id.getBytes(StandardCharsets.UTF_8);
        byte[] nameBytes = this.name.getBytes(StandardCharsets.UTF_8);
        byte[] modelBytes = this.model.getBytes(StandardCharsets.UTF_8);
        byte[] topPBytes = String.valueOf(this.topP).getBytes(StandardCharsets.UTF_8);
        byte[] temperatureBytes = String.valueOf(this.temperature).getBytes(StandardCharsets.UTF_8);
        byte[] contextSizeBytes = String.valueOf(this.contextSize).getBytes(StandardCharsets.UTF_8);
        byte[] fingerprintBytes = this.fingerprint.getBytes(StandardCharsets.UTF_8);
        byte[] metadataBytes = this.serializeObject(this.metadata);
        byte[] instructionsBytes = this.instructions.getBytes(StandardCharsets.UTF_8);
        byte[][] components = new byte[][]{idBytes, nameBytes, modelBytes, topPBytes, temperatureBytes, contextSizeBytes, fingerprintBytes, metadataBytes, instructionsBytes};
        return this.serializeComponents(components);
    }

    public String getFingerprint() {
        return this.id;
    }

    public SystemUpdateProcessor.Type getType() {
        return SystemUpdateProcessor.Type.LLM_UPDATE_AGENT;
    }
}

