/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.geo;

public class Utils {
    public static final double MIN_LAT_RADIANS = -1.5707963267948966;
    public static final double MAX_LAT_RADIANS = 1.5707963267948966;
    public static final double MIN_LON_RADIANS = -Math.PI;
    public static final double MAX_LON_RADIANS = Math.PI;
    public static final double ONE_REVOLUTION_RADIANS = Math.PI * 2;
    public static final double EARTH_AVERAGE_RADIUS_KM = 6371.009;
    public static final double KM_TO_MILES_RATIO = 1.609344;
    public static final String KM_SUFFIX = "km";
    public static final String MILE_SUFFIX = "mi";

    public static final double milesToKilometres(double distanceKm) {
        return distanceKm * 1.609344;
    }

    public static double distanceKmToAngular(double distanceKm) {
        return distanceKm / 6371.009;
    }

    public static boolean isMiles(String distance) {
        return distance.toLowerCase().endsWith(MILE_SUFFIX);
    }

    public static boolean isKilometres(String distance) {
        return distance.toLowerCase().endsWith(KM_SUFFIX);
    }

    public static double angularDistance(float lat1, float lon1, float lat2, float lon2) {
        double dlon = Math.toRadians(lon2 - lon1);
        double dlat = Math.toRadians(lat2 - lat1);
        double a = Math.sin(dlat / 2.0);
        a *= a;
        double b = Math.sin(dlon / 2.0);
        b *= b;
        return 2.0 * Math.asin(Math.min(1.0, Math.sqrt(a += Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * b)));
    }

    public static boolean within(double r_south, double r_west, double r_north, double r_east, double p_lat, double p_long) {
        return Utils.intersects(r_south, r_west, r_north, r_east, p_lat, p_long, p_lat, p_long);
    }

    public static boolean intersects(double r1_south, double r1_west, double r1_north, double r1_east, double r2_south, double r2_west, double r2_north, double r2_east) {
        if (r1_east < r1_west) {
            return Utils.intersects(r1_south, r1_west, r1_north, 180.0, r2_south, r2_west, r2_north, r2_east) || Utils.intersects(r1_south, -180.0, r1_north, r1_east, r2_south, r2_west, r2_north, r2_east);
        }
        if (r2_east < r2_west) {
            return Utils.intersects(r2_south, r2_west, r2_north, r2_east, r1_south, r1_west, r1_north, r1_east);
        }
        if (r1_north < r2_south) {
            return false;
        }
        if (r2_north < r1_south) {
            return false;
        }
        if (r1_east < r2_west) {
            return false;
        }
        return !(r2_east < r1_west);
    }
}

