/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.geo;

import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.rtree.RTreeWithCoords;
import com.ontotext.trree.plugin.geo.FunctionLoader;
import com.ontotext.trree.plugin.geo.GeoSpatial;
import com.ontotext.trree.plugin.geo.Polygon;
import com.ontotext.trree.plugin.geo.Utils;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.ListPatternInterpreter;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import com.ontotext.trree.sdk.UpdateInterpreter;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TLongProcedure;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoSpatialPlugin
extends PluginBase
implements PatternInterpreter,
ListPatternInterpreter,
UpdateInterpreter {
    private static final String STORAGE_FILE = "storage";
    private static final String TEMP_SUFFIX = ".temp";
    private static final Logger Logger;
    private final ReadWriteLock indexGuard = new ReentrantReadWriteLock();
    private RTreeWithCoords index = null;
    private long idLat;
    private long idLong;
    private long idCreateIndex;
    private long idNearby;
    private long idWithin;

    private static void boundingCoordinates(Rectangle[] res, float degLat, float degLon, float distancekm) {
        float radLat = (float)Math.toRadians(degLat);
        float radLon = (float)Math.toRadians(degLon);
        if (distancekm < 0.0f) {
            throw new IllegalArgumentException("distancekm can not be negative");
        }
        float radDist = (float)Utils.distanceKmToAngular(distancekm);
        float minLat = radLat - radDist;
        float maxLat = radLat + radDist;
        if ((double)minLat > -1.5707963267948966 && (double)maxLat < 1.5707963267948966) {
            double maxLon;
            double deltaLon = Math.asin(Math.sin(radDist) / Math.cos(radLat));
            boolean lonOver180 = false;
            boolean lonUnderMinus180 = false;
            double minLon = (double)radLon - deltaLon;
            if (minLon < -Math.PI) {
                minLon += Math.PI * 2;
                lonUnderMinus180 = true;
            }
            if ((maxLon = (double)radLon + deltaLon) > Math.PI) {
                maxLon -= Math.PI * 2;
                lonOver180 = true;
            }
            if (lonOver180 || lonUnderMinus180) {
                res[0] = new Rectangle((float)Math.toDegrees(minLat), 180.0f, (float)Math.toDegrees(maxLat), (float)Math.toDegrees(minLon));
                res[1] = new Rectangle((float)Math.toDegrees(minLat), (float)Math.toDegrees(maxLon), (float)Math.toDegrees(maxLat), -180.0f);
            } else {
                res[0] = new Rectangle((float)Math.toDegrees(minLat), (float)Math.toDegrees(minLon), (float)Math.toDegrees(maxLat), (float)Math.toDegrees(maxLon));
                res[1] = null;
            }
        } else {
            minLat = (float)Math.max((double)minLat, -1.5707963267948966);
            maxLat = (float)Math.min((double)maxLat, 1.5707963267948966);
            double minLon = -Math.PI;
            double maxLon = Math.PI;
            res[0] = new Rectangle((float)Math.toDegrees(minLat), (float)Math.toDegrees(minLon), (float)Math.toDegrees(maxLat), (float)Math.toDegrees(maxLon));
            res[1] = null;
        }
    }

    public String getName() {
        return "geospatial";
    }

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        if (this.getStorageFile().exists()) {
            try {
                this.restoreIndex();
            }
            catch (IOException e) {
                Logger.error("Failed to restore geospatial index", (Throwable)e);
            }
        }
        this.idLat = pluginConnection.getEntities().resolve((Value)GeoSpatial.LAT);
        this.idLong = pluginConnection.getEntities().resolve((Value)GeoSpatial.LONG);
        this.idCreateIndex = pluginConnection.getEntities().put((Value)GeoSpatial.CREATE_INDEX, Entities.Scope.SYSTEM);
        this.idNearby = pluginConnection.getEntities().put((Value)GeoSpatial.NEARBY, Entities.Scope.SYSTEM);
        this.idWithin = pluginConnection.getEntities().put((Value)GeoSpatial.WITHIN, Entities.Scope.SYSTEM);
        this.loadPredicates(pluginConnection);
        FunctionRegistry functionRegistry = FunctionRegistry.getInstance();
        ServiceLoader<Function> sl = ServiceLoader.load(Function.class, FunctionLoader.class.getClassLoader());
        sl.reload();
        Logger.debug("Plugin:" + this.getName() + " initialized");
    }

    private void loadPredicates(PluginConnection pluginConnection) {
        this.idLat = pluginConnection.getEntities().put((Value)GeoSpatial.LAT, Entities.Scope.DEFAULT);
        this.idLong = pluginConnection.getEntities().put((Value)GeoSpatial.LONG, Entities.Scope.DEFAULT);
    }

    private long getLatitudeId() {
        return this.idLat;
    }

    private long getLongtitudeId() {
        return this.idLong;
    }

    public void shutdown(ShutdownReason shutdownReason) {
    }

    public File getStorageFile() {
        return new File(this.getDataDir() + File.separator + STORAGE_FILE);
    }

    public File getTempStorageFile() {
        return new File(this.getStorageFile() + TEMP_SUFFIX);
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (com.ontotext.trree.sdk.Utils.match((long)predicate, (long[])new long[]{this.idCreateIndex})) {
            Boolean result = this.createIndex(pluginConnection.getStatements(), pluginConnection.getEntities());
            return result != false ? StatementIterator.TRUE() : StatementIterator.FALSE();
        }
        return null;
    }

    public StatementIterator interpret(long subject, long predicate, long[] objects, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (com.ontotext.trree.sdk.Utils.match((long)predicate, (long[])new long[]{this.idNearby})) {
            return this.handleNearBy(subject, predicate, objects, context, pluginConnection.getStatements(), pluginConnection.getEntities());
        }
        if (com.ontotext.trree.sdk.Utils.match((long)predicate, (long[])new long[]{this.idWithin})) {
            return this.handleWithin(subject, predicate, objects, context, pluginConnection.getStatements(), pluginConnection.getEntities());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createIndex(Statements statements, Entities entities) {
        block20: {
            this.indexGuard.writeLock().lock();
            try {
                int count;
                block22: {
                    if (this.getLongtitudeId() == 0L || this.getLatitudeId() == 0L) break block20;
                    TLongHashSet indexed = new TLongHashSet();
                    this.setFingerprint(0L);
                    this.index = new RTreeWithCoords();
                    Properties prop = new Properties();
                    prop.put("MaxNodeEntries", "10");
                    prop.put("MinNodeEntries", "5");
                    this.index.init(prop);
                    count = 0;
                    Rectangle r = new Rectangle();
                    StatementIterator iter = statements.get(0L, this.getLatitudeId(), 0L, 0L);
                    block14: while (true) {
                        while (iter.next()) {
                            long entry = iter.subject;
                            long latCoord = iter.object;
                            long longCoord = -1L;
                            try (StatementIterator iterLong = statements.get(entry, this.getLongtitudeId(), 0L, 0L);){
                                if (iterLong.next()) {
                                    longCoord = iterLong.object;
                                }
                                if (iterLong.next()) {
                                    Logger.warn("multiple latitudes found for node " + entry);
                                }
                            }
                            if (longCoord == -1L) continue;
                            try {
                                Literal latLiteral = (Literal)entities.get(latCoord);
                                Literal longLiteral = (Literal)entities.get(longCoord);
                                float latDouble = Float.parseFloat(latLiteral.getLabel());
                                float longDouble = Float.parseFloat(longLiteral.getLabel());
                                r.minX = r.maxX = latDouble;
                                r.minY = r.maxY = longDouble;
                                if (!indexed.add(entry)) {
                                    Logger.warn("node " + entry + " already indexed");
                                    continue block14;
                                }
                                this.index.add(r, entry);
                                long fp = this.getFingerprint();
                                fp ^= Double.doubleToLongBits(latDouble);
                                fp ^= Double.doubleToLongBits(longDouble);
                                this.setFingerprint(fp ^= entry);
                                if (++count % 10000 != 0) continue block14;
                                Logger.debug(count + " entries indexed so far (" + latDouble + "," + longDouble + ", entry=" + entities.get(entry) + ")");
                                continue block14;
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (ClassCastException classCastException) {
                            }
                        }
                        break block22;
                        {
                            continue block14;
                            break;
                        }
                        break;
                    }
                    finally {
                        iter.close();
                    }
                }
                Logger.debug(count + " entries indexed in total");
                Logger.debug("Persisting index...");
                if (!this.index.checkConsistency()) {
                    Logger.debug("RTree index inconsistent");
                }
                this.persistIndex();
                Logger.debug("Index persisted");
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Logger.error("Failed persisting the geospatial index to disk", (Throwable)e);
            }
            finally {
                this.indexGuard.writeLock().unlock();
            }
        }
        return false;
    }

    public void persistIndex() throws IOException {
        this.getDataDir().mkdirs();
        File storageFile = this.getStorageFile();
        File tempStorageFile = this.getTempStorageFile();
        tempStorageFile.delete();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tempStorageFile)));
        this.index.save(out);
        out.close();
        storageFile.delete();
        tempStorageFile.renameTo(storageFile);
    }

    public void restoreIndex() throws IOException {
        Logger.debug("Restoring geospatial index from disk");
        this.index = new RTreeWithCoords();
        Properties prop = new Properties();
        prop.put("MaxNodeEntries", "10");
        prop.put("MinNodeEntries", "5");
        this.index.init(prop);
        try (FilterInputStream in = null;){
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getStorageFile())));
            this.index.load((DataInputStream)in);
        }
        Logger.debug("Geospatial index restored from disk");
    }

    private StatementIterator handleNearBy(long subject, long predicate, long[] objects, long context, Statements statements, Entities entities) {
        return this.createIterator(subject, predicate, objects, context, statements, entities, false);
    }

    private StatementIterator handleWithin(long subject, long predicate, long[] objects, long context, Statements statements, Entities entities) {
        return this.createIterator(subject, predicate, objects, context, statements, entities, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StatementIterator createIterator(long subject, long predicate, long[] objects, long context, Statements statements, final Entities entities, boolean isWithinFlag) {
        GeoStatBase stat;
        this.indexGuard.readLock().lock();
        boolean haveValidStat = false;
        Polygon poly = null;
        boolean badPoly = false;
        try {
            if (this.index == null) {
                StatementIterator statementIterator = StatementIterator.EMPTY;
                return statementIterator;
            }
            Rectangle[] result = new Rectangle[2];
            if (!isWithinFlag) {
                float latV = this.getVarAsDouble(entities, objects[0]);
                float longV = this.getVarAsDouble(entities, objects[1]);
                if (Double.isInfinite(latV) || Double.isNaN(latV) || Double.isInfinite(longV) || Double.isNaN(longV)) {
                    StatementIterator statementIterator = StatementIterator.EMPTY;
                    return statementIterator;
                }
                float radians = (float)Utils.distanceKmToAngular(this.getVarAsDouble(entities, objects[2]));
                float distancekm = this.getVarAsDouble(entities, objects[2]);
                GeoSpatialPlugin.boundingCoordinates(result, latV, longV, distancekm);
                stat = new GeoStatNearBy(latV, longV, radians);
                haveValidStat = true;
            } else if (objects.length == 4) {
                float latMin = this.getVarAsDouble(entities, objects[0]);
                float longMin = this.getVarAsDouble(entities, objects[1]);
                float latMax = this.getVarAsDouble(entities, objects[2]);
                float longMax = this.getVarAsDouble(entities, objects[3]);
                result[0] = new Rectangle(latMin, longMin, latMax, longMax);
                result[1] = null;
                stat = new GeoStatWithin();
                haveValidStat = true;
            } else {
                if (objects.length % 2 != 0) {
                    Logger.error("odd number of coordinate arguments passed to geo:within");
                    StatementIterator latMin = StatementIterator.EMPTY;
                    return latMin;
                }
                if (poly == null) {
                    poly = new Polygon(objects.length / 2);
                    for (int pt = 0; pt < objects.length; pt += 2) {
                        float lat = this.getVarAsDouble(entities, objects[pt]);
                        float lon = this.getVarAsDouble(entities, objects[pt + 1]);
                        if (Float.isNaN(lat) || Float.isNaN(lon)) {
                            badPoly = true;
                            break;
                        }
                        poly.add(lat, lon);
                    }
                }
                if (poly == null || badPoly || !poly.isReady()) {
                    StatementIterator pt = StatementIterator.EMPTY;
                    return pt;
                }
                if (subject != 0L) {
                    block40: {
                        long entry = subject;
                        try (StatementIterator iter = statements.get(entry, this.getLatitudeId(), 0L, context);){
                            if (!iter.next()) break block40;
                            float latLoc = this.getIdAsFloat(entities, iter.object);
                            if (Float.isNaN(latLoc)) {
                                StatementIterator statementIterator = StatementIterator.EMPTY;
                                return statementIterator;
                            }
                            try (StatementIterator iterLong = statements.get(entry, this.getLongtitudeId(), 0L, context);){
                                if (iterLong.next()) {
                                    float lonLoc = this.getIdAsFloat(entities, iterLong.object);
                                    if (Float.isNaN(latLoc)) {
                                        StatementIterator statementIterator = StatementIterator.EMPTY;
                                        return statementIterator;
                                    }
                                    if (poly.contains(latLoc, lonLoc)) {
                                        StatementIterator statementIterator = StatementIterator.create((long)subject, (long)-1L, (long)-1L, (long)-1L);
                                        return statementIterator;
                                    }
                                }
                            }
                        }
                    }
                    StatementIterator latLoc = StatementIterator.EMPTY;
                    return latLoc;
                }
                result[0] = new Rectangle(poly.getMinLat(), poly.getMinLong(), poly.getMaxLat(), poly.getMaxLong());
                result[1] = null;
                stat = new GeoStatWithinPoly(poly);
                haveValidStat = true;
            }
            for (Rectangle element : result) {
                if (element == null) continue;
                if (stat instanceof TLongProcedure) {
                    this.index.intersects(element, (TLongProcedure)stat);
                    continue;
                }
                this.index.intersects(element, (TLongObjectProcedure<Rectangle>)((TLongObjectProcedure)stat));
            }
        }
        finally {
            this.indexGuard.readLock().unlock();
        }
        if (!haveValidStat) {
            return StatementIterator.EMPTY;
        }
        if (subject == 0L) return new StatementIterator(subject, predicate, objects[0], context){
            int current;
            {
                super(arg0, arg1, arg2, arg3);
                this.current = -1;
            }

            public boolean next() {
                if (++this.current >= stat.size()) {
                    return false;
                }
                this.subject = entities.getClass(stat.fromIndex(this.current));
                return true;
            }

            public void close() {
                this.current = stat.size();
            }
        };
        if (stat.subjects.contains(subject)) return StatementIterator.create((long)subject, (long)-1L, (long)-1L, (long)-1L);
        return StatementIterator.EMPTY;
    }

    private float getIdAsFloat(Entities entities, long id) {
        Value val = entities.get(id);
        if (val == null) {
            return Float.NaN;
        }
        if (!(val instanceof Literal)) {
            return Float.NaN;
        }
        try {
            return Float.parseFloat(((Literal)val).getLabel());
        }
        catch (NumberFormatException nfe) {
            return Float.NaN;
        }
    }

    private float getVarAsDouble(Entities entities, long id) {
        String value = com.ontotext.trree.sdk.Utils.getString((Entities)entities, (long)id);
        if (value == null) {
            return Float.NaN;
        }
        double factor = 1.0;
        if (Utils.isKilometres(value)) {
            value = value.substring(0, value.length() - "km".length());
        } else if (Utils.isMiles(value)) {
            value = value.substring(0, value.length() - "mi".length());
            factor = 1.609344;
        }
        try {
            return (float)(Double.parseDouble(value) * factor);
        }
        catch (NumberFormatException nfe) {
            return Float.NaN;
        }
    }

    public double estimate(long subject, long predicate, long[] objects, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        for (long object : objects) {
            if (0L != object) continue;
            return Double.POSITIVE_INFINITY;
        }
        if (subject == 0L) {
            return 1.5;
        }
        return 1.0;
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        return 1.0;
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.idCreateIndex};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        this.createIndex(pluginConnection.getStatements(), pluginConnection.getEntities());
        return true;
    }

    static {
        FunctionLoader.loadFunctionsInPackage("com.ontotext.trree.plugin.geo");
        Logger = LoggerFactory.getLogger(GeoSpatialPlugin.class);
    }

    private static class GeoStatWithinPoly
    extends GeoStatBase
    implements TLongObjectProcedure<Rectangle> {
        private Polygon polygon;

        public GeoStatWithinPoly(Polygon poly) {
            this.polygon = poly;
        }

        public boolean execute(long id, Rectangle match) {
            if (this.polygon.contains(match.maxX, match.maxY)) {
                this.subjects.add(id);
            }
            return true;
        }
    }

    private static class GeoStatNearBy
    extends GeoStatBase
    implements TLongObjectProcedure<Rectangle> {
        private float aroundLat = 0.0f;
        private float aroundLon = 0.0f;
        private float distance = 0.0f;

        public GeoStatNearBy(float lat, float lon, float dist) {
            this.aroundLat = lat;
            this.aroundLon = lon;
            this.distance = dist;
        }

        public boolean execute(long id, Rectangle match) {
            if (Utils.angularDistance(this.aroundLat, this.aroundLon, match.maxX, match.maxY) < (double)this.distance) {
                this.subjects.add(id);
            }
            return true;
        }
    }

    private static class GeoStatWithin
    extends GeoStatBase
    implements TLongProcedure {
        private GeoStatWithin() {
        }

        public boolean execute(long id) {
            this.subjects.add(id);
            return true;
        }
    }

    private static class GeoStatBase {
        final LongArrayList subjects = new LongArrayList(16);

        private GeoStatBase() {
        }

        public int size() {
            return this.subjects.size();
        }

        public long fromIndex(int index) {
            return this.subjects.get(index);
        }
    }
}

