/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi;

import gnu.trove.TFloatArrayList;
import gnu.trove.TLongArrayList;

public class PriorityQueue {
    public static final boolean SORT_ORDER_ASCENDING = true;
    public static final boolean SORT_ORDER_DESCENDING = false;
    private TLongArrayList values = null;
    private TFloatArrayList priorities = null;
    private boolean sortOrder = true;
    private static boolean INTERNAL_CONSISTENCY_CHECKING = false;

    public PriorityQueue(boolean sortOrder) {
        this(sortOrder, 10);
    }

    public PriorityQueue(boolean sortOrder, int initialCapacity) {
        this.sortOrder = sortOrder;
        this.values = new TLongArrayList(initialCapacity);
        this.priorities = new TFloatArrayList(initialCapacity);
    }

    private boolean sortsEarlierThan(float p1, float p2) {
        if (this.sortOrder) {
            return p1 < p2;
        }
        return p2 < p1;
    }

    public void insert(long value, float priority) {
        this.values.add(value);
        this.priorities.add(priority);
        this.promote(this.values.size() - 1, value, priority);
    }

    private void promote(int index, long value, float priority) {
        int parentIndex;
        float parentPriority;
        while (index > 0 && !this.sortsEarlierThan(parentPriority = this.priorities.get(parentIndex = (index - 1) / 2), priority)) {
            this.values.set(index, this.values.get(parentIndex));
            this.priorities.set(index, parentPriority);
            index = parentIndex;
        }
        this.values.set(index, value);
        this.priorities.set(index, priority);
        if (INTERNAL_CONSISTENCY_CHECKING) {
            this.check();
        }
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
        this.priorities.clear();
    }

    public void reset() {
        this.values.reset();
        this.priorities.reset();
    }

    public long getValue() {
        return this.values.get(0);
    }

    public float getPriority() {
        return this.priorities.get(0);
    }

    private void demote(int index, long value, float priority) {
        int childIndex = index * 2 + 1;
        while (childIndex < this.values.size()) {
            float rightPriority;
            float childPriority = this.priorities.get(childIndex);
            if (childIndex + 1 < this.values.size() && this.sortsEarlierThan(rightPriority = this.priorities.get(childIndex + 1), childPriority)) {
                childPriority = rightPriority;
                ++childIndex;
            }
            if (!this.sortsEarlierThan(childPriority, priority)) break;
            this.priorities.set(index, childPriority);
            this.values.set(index, this.values.get(childIndex));
            index = childIndex;
            childIndex = index * 2 + 1;
        }
        this.values.set(index, value);
        this.priorities.set(index, priority);
    }

    public long pop() {
        long ret = this.values.get(0);
        int lastIndex = this.values.size() - 1;
        long tempValue = this.values.get(lastIndex);
        float tempPriority = this.priorities.get(lastIndex);
        this.values.remove(lastIndex);
        this.priorities.remove(lastIndex);
        if (lastIndex > 0) {
            this.demote(0, tempValue, tempPriority);
        }
        if (INTERNAL_CONSISTENCY_CHECKING) {
            this.check();
        }
        return ret;
    }

    public void setSortOrder(boolean sortOrder) {
        if (this.sortOrder != sortOrder) {
            this.sortOrder = sortOrder;
            for (int i = this.values.size() / 2 - 1; i >= 0; --i) {
                this.demote(i, this.values.get(i), this.priorities.get(i));
            }
        }
        if (INTERNAL_CONSISTENCY_CHECKING) {
            this.check();
        }
    }

    private void check() {
        int lastIndex = this.values.size() - 1;
        for (int i = 0; i < this.values.size() / 2; ++i) {
            float rightPriority;
            int rightIndex;
            float leftPriority;
            float currentPriority = this.priorities.get(i);
            int leftIndex = i * 2 + 1;
            if (leftIndex <= lastIndex && this.sortsEarlierThan(leftPriority = this.priorities.get(leftIndex), currentPriority)) {
                System.err.println("Internal error in PriorityQueue");
            }
            if ((rightIndex = i * 2 + 2) > lastIndex || !this.sortsEarlierThan(rightPriority = this.priorities.get(rightIndex), currentPriority)) continue;
            System.err.println("Internal error in PriorityQueue");
        }
    }
}

