/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.mustache;

import com.github.mustachejava.Code;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.codes.CommentCode;
import com.github.mustachejava.codes.IterableCode;
import com.ontotext.models.templates.BasicTemplate;
import com.ontotext.models.templates.Template;
import com.ontotext.models.templates.TemplateArgs;
import com.ontotext.models.templates.TemplateParseException;
import com.ontotext.models.templates.TemplateParser;
import com.ontotext.soaas.mustache.CustomCode;
import com.ontotext.soaas.mustache.OntoMustacheFactory;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MustacheTemplatesParser
implements TemplateParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MustacheTemplatesParser.class);
    private final MustacheFactory mf = new OntoMustacheFactory();

    public boolean isApplicable(String query) {
        try {
            Mustache mustache = this.mf.compile((Reader)new StringReader(query), "example");
            return mustache != null && this.hasArguments(mustache);
        }
        catch (MustacheException me) {
            return false;
        }
    }

    private boolean hasArguments(Mustache mustache) {
        return Arrays.stream(mustache.getCodes()).anyMatch(code -> code.getName() != null);
    }

    public Optional<Template> parse(String name, String template) {
        if (template == null) {
            return Optional.empty();
        }
        try {
            Mustache mustache = new OntoMustacheFactory().compile(new StringReader(template), name);
            if (this.hasArguments(mustache)) {
                return Optional.of(new MustacheTemplate(name, template, mustache, this));
            }
        }
        catch (MustacheException me) {
            throw new TemplateParseException(String.format("Template with name %s failed to parse with %s", name, me.getMessage()), (Throwable)me);
        }
        return Optional.empty();
    }

    static {
        LOGGER.info("Loaded Mustache template processing.");
    }

    private static class MustacheTemplate
    extends BasicTemplate {
        private static final Pattern NAME_ESCAPE = Pattern.compile("[-/`~!@#$%^&*()+=,<>;?'|\"\\[\\]\\\\]");
        private final Mustache mustache;
        private final TemplateParser parser;
        private Map<String, TemplateArgs> keys;

        private MustacheTemplate(String name, String template, Mustache mustache, TemplateParser parser) {
            super(name, template);
            this.mustache = mustache;
            this.parser = parser;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MustacheTemplate)) {
                return false;
            }
            MustacheTemplate that = (MustacheTemplate)((Object)obj);
            return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.get(), that.get()) && this.getKeys().equals(that.getKeys());
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getKeys());
        }

        public Map<String, TemplateArgs> getKeys() {
            if (this.keys == null) {
                this.keys = this.readKeys(this.mustache.getCodes(), new LinkedHashMap<String, TemplateArgs>());
            }
            return this.keys;
        }

        private Map<String, TemplateArgs> readKeys(Code[] codes, Map<String, TemplateArgs> result) {
            if (codes == null) {
                return result;
            }
            for (Code code : codes) {
                if (code.getName() == null || code instanceof CommentCode) continue;
                String name = code.getName();
                String[] nameTypeDefaultValue = this.parser.splitToNameAndType(name);
                String cleanName = NAME_ESCAPE.matcher(nameTypeDefaultValue[0]).replaceAll("");
                boolean isCollection = code instanceof IterableCode;
                String userType = this.parser.resolveType(name, isCollection);
                String defaultValue = this.parser.resolveDefaultValue(name);
                String customType = code instanceof CustomCode && "object".equals(userType) ? "string" : userType;
                String[] names = this.parser.splitNameInParts(cleanName);
                if (names.length == 1) {
                    TemplateArgs value = result.computeIfAbsent(names[0], s -> new TemplateArgs(name, customType, defaultValue, isCollection));
                    if (!(code instanceof IterableCode)) continue;
                    this.readKeys(code.getCodes(), value.getArgsMap());
                    continue;
                }
                this.processPathTemplateKeys(name, isCollection, result);
            }
            return result;
        }

        private void processPathTemplateKeys(String name, boolean isCollection, Map<String, TemplateArgs> result) {
            Map current = result;
            LinkedList<String> stack = new LinkedList<String>(Arrays.asList(this.parser.splitNameInParts(name)));
            while (!stack.isEmpty()) {
                String top = (String)stack.removeFirst();
                String subType = stack.isEmpty() ? this.parser.resolveType(top, isCollection) : "object";
                String defaultValue = this.parser.resolveDefaultValue(top);
                String propName = this.parser.splitToNameAndType(top)[0];
                current = current.computeIfAbsent((String)propName, s -> new TemplateArgs(top, subType, defaultValue, isCollection)).getArgsMap();
            }
        }

        public String apply(Object context) {
            StringWriter writer = new StringWriter();
            if (context instanceof Map) {
                context = MustacheTemplate.reWriteKeys(context, this.getKeys());
            }
            this.mustache.execute((Writer)writer, context == null ? Collections.emptyMap() : context);
            writer.flush();
            return writer.toString();
        }

        private static Map<String, Object> reWriteKeys(Map<String, Object> userData, Map<String, TemplateArgs> argsMap) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, TemplateArgs> entry : argsMap.entrySet()) {
                String key = entry.getKey();
                Map<String, Object> value = userData.get(key);
                TemplateArgs templateArgs = entry.getValue();
                if (value == null) {
                    if (templateArgs.isCollection()) {
                        result.put(templateArgs.getName(), Boolean.FALSE);
                        continue;
                    }
                    if (templateArgs.getDefaultValue() == null) continue;
                    result.put(templateArgs.getName(), MustacheTemplate.convertDefaultValue(templateArgs));
                    continue;
                }
                Map<String, Object> newValue = value;
                if (value instanceof Collection) {
                    newValue = MustacheTemplate.rewriteCollection(templateArgs, (Collection)((Object)value));
                } else if (!templateArgs.getArgsMap().isEmpty() && value instanceof Map) {
                    newValue = MustacheTemplate.reWriteKeys(value, templateArgs.getArgsMap());
                }
                result.put(templateArgs.getName(), newValue);
            }
            return result;
        }

        private static String convertDefaultValue(TemplateArgs templateArgs) {
            String type = templateArgs.getType();
            String defaultValue = templateArgs.getDefaultValue();
            if ("sparql".equals(type)) {
                return defaultValue;
            }
            if ("iri".equals(type)) {
                if (defaultValue.startsWith("http") || !defaultValue.contains(":")) {
                    return "<" + defaultValue + ">";
                }
                return defaultValue;
            }
            if ("string".equals(type)) {
                return "\"" + defaultValue + "\"";
            }
            return "\"" + defaultValue + "\"^^xsd:" + type;
        }

        private static Object rewriteCollection(TemplateArgs templateArgs, Collection<Object> value) {
            ArrayList<Object> newValues = new ArrayList<Object>(value.size());
            for (Object item : value) {
                if (item instanceof Map) {
                    newValues.add(MustacheTemplate.reWriteKeys((Map)item, templateArgs.getArgsMap()));
                    continue;
                }
                newValues.add(item);
            }
            ArrayList<Object> newValue = newValues;
            return newValue;
        }
    }
}

