/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import java.util.Map;
import java.util.Objects;

public class OpenAiChatRequestParameters
extends DefaultChatRequestParameters {
    public static final OpenAiChatRequestParameters EMPTY = OpenAiChatRequestParameters.builder().build();
    private final Integer maxCompletionTokens;
    private final Map<String, Integer> logitBias;
    private final Boolean parallelToolCalls;
    private final Integer seed;
    private final String user;
    private final Boolean store;
    private final Map<String, String> metadata;
    private final String serviceTier;
    private final String reasoningEffort;
    private final Map<String, Object> customParameters;

    private OpenAiChatRequestParameters(Builder builder) {
        super(builder);
        this.maxCompletionTokens = builder.maxCompletionTokens;
        this.logitBias = Utils.copy(builder.logitBias);
        this.parallelToolCalls = builder.parallelToolCalls;
        this.seed = builder.seed;
        this.user = builder.user;
        this.store = builder.store;
        this.metadata = Utils.copy(builder.metadata);
        this.serviceTier = builder.serviceTier;
        this.reasoningEffort = builder.reasoningEffort;
        this.customParameters = Utils.copy(builder.customParameters);
    }

    public Integer maxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    public Boolean parallelToolCalls() {
        return this.parallelToolCalls;
    }

    public Integer seed() {
        return this.seed;
    }

    public String user() {
        return this.user;
    }

    public Boolean store() {
        return this.store;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public String serviceTier() {
        return this.serviceTier;
    }

    public String reasoningEffort() {
        return this.reasoningEffort;
    }

    public Map<String, Object> customParameters() {
        return this.customParameters;
    }

    @Override
    public OpenAiChatRequestParameters overrideWith(ChatRequestParameters that) {
        return OpenAiChatRequestParameters.builder().overrideWith(this).overrideWith(that).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenAiChatRequestParameters that = (OpenAiChatRequestParameters)o;
        return Objects.equals(this.maxCompletionTokens, that.maxCompletionTokens) && Objects.equals(this.logitBias, that.logitBias) && Objects.equals(this.parallelToolCalls, that.parallelToolCalls) && Objects.equals(this.seed, that.seed) && Objects.equals(this.user, that.user) && Objects.equals(this.store, that.store) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.serviceTier, that.serviceTier) && Objects.equals(this.reasoningEffort, that.reasoningEffort) && Objects.equals(this.customParameters, that.customParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxCompletionTokens, this.logitBias, this.parallelToolCalls, this.seed, this.user, this.store, this.metadata, this.serviceTier, this.reasoningEffort, this.customParameters);
    }

    @Override
    public String toString() {
        return "OpenAiChatRequestParameters{modelName=" + Utils.quoted(this.modelName()) + ", temperature=" + this.temperature() + ", topP=" + this.topP() + ", topK=" + this.topK() + ", frequencyPenalty=" + this.frequencyPenalty() + ", presencePenalty=" + this.presencePenalty() + ", maxOutputTokens=" + this.maxOutputTokens() + ", stopSequences=" + String.valueOf(this.stopSequences()) + ", toolSpecifications=" + String.valueOf(this.toolSpecifications()) + ", toolChoice=" + String.valueOf((Object)this.toolChoice()) + ", responseFormat=" + String.valueOf(this.responseFormat()) + ", maxCompletionTokens=" + this.maxCompletionTokens + ", logitBias=" + String.valueOf(this.logitBias) + ", parallelToolCalls=" + this.parallelToolCalls + ", seed=" + this.seed + ", user=" + Utils.quoted(this.user) + ", store=" + this.store + ", metadata=" + String.valueOf(this.metadata) + ", serviceTier=" + Utils.quoted(this.serviceTier) + ", reasoningEffort=" + Utils.quoted(this.reasoningEffort) + ", customParameters=" + String.valueOf(this.customParameters) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private Integer maxCompletionTokens;
        private Map<String, Integer> logitBias;
        private Boolean parallelToolCalls;
        private Integer seed;
        private String user;
        private Boolean store;
        private Map<String, String> metadata;
        private String serviceTier;
        private String reasoningEffort;
        private Map<String, Object> customParameters;

        @Override
        public Builder overrideWith(ChatRequestParameters parameters) {
            super.overrideWith(parameters);
            if (parameters instanceof OpenAiChatRequestParameters) {
                OpenAiChatRequestParameters openAiParameters = (OpenAiChatRequestParameters)parameters;
                this.maxCompletionTokens(Utils.getOrDefault(openAiParameters.maxCompletionTokens(), this.maxCompletionTokens));
                this.logitBias(Utils.getOrDefault(openAiParameters.logitBias(), this.logitBias));
                this.parallelToolCalls(Utils.getOrDefault(openAiParameters.parallelToolCalls(), this.parallelToolCalls));
                this.seed(Utils.getOrDefault(openAiParameters.seed(), this.seed));
                this.user(Utils.getOrDefault(openAiParameters.user(), this.user));
                this.store(Utils.getOrDefault(openAiParameters.store(), this.store));
                this.metadata(Utils.getOrDefault(openAiParameters.metadata(), this.metadata));
                this.serviceTier(Utils.getOrDefault(openAiParameters.serviceTier(), this.serviceTier));
                this.reasoningEffort(Utils.getOrDefault(openAiParameters.reasoningEffort(), this.reasoningEffort));
                this.customParameters(Utils.getOrDefault(openAiParameters.customParameters(), this.customParameters));
            }
            return this;
        }

        public Builder modelName(OpenAiChatModelName modelName) {
            return (Builder)super.modelName(modelName == null ? null : modelName.toString());
        }

        public Builder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder store(Boolean store) {
            this.store = store;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        public Builder reasoningEffort(String reasoningEffort) {
            this.reasoningEffort = reasoningEffort;
            return this;
        }

        public Builder customParameters(Map<String, Object> customParameters) {
            this.customParameters = customParameters;
            return this;
        }

        @Override
        public OpenAiChatRequestParameters build() {
            return new OpenAiChatRequestParameters(this);
        }
    }
}

