/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.filter;

import com.ontotext.trree.plugin.externalsync.filter.Operand;
import com.ontotext.trree.plugin.externalsync.filter.ValueIterator;
import com.ontotext.trree.plugin.externalsync.filter.ValueProvider;
import org.eclipse.rdf4j.model.Value;

public abstract class AbstractValueIterator
implements ValueIterator {
    protected final ValueProvider valueProvider;
    protected final boolean isLang;
    protected final boolean isGraph;
    private long value;

    public AbstractValueIterator(Operand operand, ValueProvider valueProvider, boolean terminal) {
        this.valueProvider = valueProvider;
        this.isLang = operand.isLang && (terminal || operand.nexthopId == 0L);
        this.isGraph = operand.isGraph && (terminal || operand.nexthopId == 0L);
    }

    protected final void setNextValue(long value, long valueGraph) {
        this.value = this.isGraph ? valueGraph : value;
    }

    @Override
    public long id() {
        if (this.isLang) {
            return this.valueProvider.resolveValue(this.value());
        }
        return this.value;
    }

    @Override
    public Value value() {
        if (this.isLang) {
            return this.valueProvider.resolveIdToLanguage(this.value);
        }
        return this.valueProvider.resolveId(this.value);
    }
}

