/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.config;

import com.ontotext.trree.plugin.externalsync.config.OptionType;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Option<T>
implements Cloneable {
    private static final String OPTION_TYPE = "__type";
    private static final String CHILD_OPTIONS = "__childOptions";
    private static final String OPTION_HINT = "__hint";
    private static final String OPTION_LABEL = "__label";
    private static final String OPTION_DEFAULT_VALUE = "__defaultValue";
    private static final String OPTION_REQUIRED = "__required";
    private static final String OPTION_DESCRIPTION = "__description";
    private static final String OPTION_NAME = "__name";
    private static final String OPTION_HIDDEN = "__hidden";
    private static final String OPTION_DEPRECATED = "__deprecated";
    private final String name;
    private final OptionType type;
    private final List<Option<?>> childOptions;
    private String description;
    private boolean required;
    private boolean hidden;
    private boolean deprecated;
    private boolean updatable;
    private boolean unsaved;
    private T defaultValue;
    private List<Validator<T>> validator = new ArrayList<Validator<T>>();
    private String hint;
    private String label;

    Option(String name, OptionType type) {
        this.name = name;
        this.type = type;
        this.label = name;
        this.childOptions = new LinkedList();
    }

    public OptionType getType() {
        return this.type;
    }

    public String getHint() {
        return this.hint;
    }

    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public List<Option<?>> getChildOptions() {
        return this.childOptions;
    }

    public static OptionBuilder<List<String>> stringList(@Nonnull String name, ResourceBundle resourceBundle) {
        return new OptionBuilder<List<String>>(name, OptionType.StringArray, resourceBundle);
    }

    public static OptionBuilder<List<String>> stringList(@Nonnull String name) {
        return new OptionBuilder<List<String>>(name, OptionType.StringArray);
    }

    public static OptionBuilder<List<Option<?>>> optionList(@Nonnull String name, ResourceBundle resourceBundle) {
        return new OptionBuilder(name, OptionType.OptionArray, resourceBundle);
    }

    public static OptionBuilder<Map<String, Object>> optionMap(@Nonnull String name, ResourceBundle resourceBundle) {
        return new OptionBuilder<Map<String, Object>>(name, OptionType.Map, resourceBundle);
    }

    public static OptionBuilder<List<Option<?>>> optionList(@Nonnull String name) {
        return new OptionBuilder(name, OptionType.OptionArray);
    }

    public static <T> OptionBuilder<Option<T>> option(@Nonnull String name) {
        return new OptionBuilder<Option<T>>(name, OptionType.Option);
    }

    public static OptionBuilder<String> string(@Nonnull String name, ResourceBundle resourceBundle) {
        return new OptionBuilder<String>(name, OptionType.String, resourceBundle);
    }

    public static OptionBuilder<String> string(@Nonnull String name) {
        return new OptionBuilder<String>(name, OptionType.String);
    }

    public static OptionBuilder<String> bigString(@Nonnull String name, ResourceBundle resourceBundle) {
        return new OptionBuilder<String>(name, OptionType.BigString, resourceBundle);
    }

    public static OptionBuilder<String> bigString(@Nonnull String name) {
        return new OptionBuilder<String>(name, OptionType.BigString);
    }

    public static OptionBuilder<Map<String, Object>> jsonString(@Nonnull String name, ResourceBundle resourceBundle) {
        return new OptionBuilder<Map<String, Object>>(name, OptionType.JsonString, resourceBundle);
    }

    public static OptionBuilder<Map<String, Object>> jsonString(@Nonnull String name) {
        return new OptionBuilder<Map<String, Object>>(name, OptionType.JsonString);
    }

    public static OptionBuilder<Boolean> flag(@Nonnull String name, ResourceBundle resourceBundle) {
        return new OptionBuilder<Boolean>(name, OptionType.Boolean, resourceBundle);
    }

    public static OptionBuilder<Boolean> flag(@Nonnull String name) {
        return new OptionBuilder<Boolean>(name, OptionType.Boolean);
    }

    public static OptionBuilder<Long> longNumber(@Nonnull String name, ResourceBundle resourceBundle) {
        return new OptionBuilder<Long>(name, OptionType.Long, resourceBundle);
    }

    public static OptionBuilder<Long> longNumber(@Nonnull String name) {
        return new OptionBuilder<Long>(name, OptionType.Long);
    }

    @Nullable
    public T getDefault() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public boolean isUnsaved() {
        return this.unsaved;
    }

    public List<Validator<T>> getValidator() {
        return this.validator;
    }

    public static Option<?> fromJSON(JSONObject jsonOption) {
        Option o = new Option(jsonOption.get((Object)OPTION_NAME).toString(), OptionType.valueOf(jsonOption.get((Object)OPTION_TYPE).toString()));
        if (jsonOption.containsKey((Object)OPTION_DESCRIPTION)) {
            o.description = jsonOption.get((Object)OPTION_DESCRIPTION).toString();
        }
        if (jsonOption.containsKey((Object)OPTION_HINT)) {
            o.hint = jsonOption.get((Object)OPTION_HINT).toString();
        }
        if (jsonOption.containsKey((Object)OPTION_LABEL)) {
            o.label = jsonOption.get((Object)OPTION_LABEL).toString();
        }
        if (jsonOption.containsKey((Object)OPTION_REQUIRED)) {
            o.required = Boolean.parseBoolean(jsonOption.get((Object)OPTION_REQUIRED).toString());
        }
        if (jsonOption.containsKey((Object)OPTION_HIDDEN)) {
            o.hidden = Boolean.parseBoolean(jsonOption.get((Object)OPTION_HIDDEN).toString());
        }
        if (jsonOption.containsKey((Object)OPTION_DEPRECATED)) {
            o.deprecated = Boolean.parseBoolean(jsonOption.get((Object)OPTION_DEPRECATED).toString());
        }
        if (OptionType.OptionArray.equals((Object)o.type) || OptionType.Option.equals((Object)o.type)) {
            for (Object value : (JSONArray)jsonOption.get((Object)CHILD_OPTIONS)) {
                JSONObject option = (JSONObject)value;
                o.childOptions.add(Option.fromJSON(option));
            }
        }
        return o;
    }

    public JSONObject toJSONObject() {
        JSONObject optJSON = new JSONObject();
        optJSON.put((Object)OPTION_NAME, (Object)this.name);
        optJSON.put((Object)OPTION_DESCRIPTION, (Object)(this.description != null ? this.description : ""));
        if (this.defaultValue != null) {
            optJSON.put((Object)OPTION_DEFAULT_VALUE, this.defaultValue);
        }
        if (this.label != null) {
            optJSON.put((Object)OPTION_LABEL, (Object)this.label);
        }
        if (this.hint != null) {
            optJSON.put((Object)OPTION_HINT, (Object)this.hint);
        }
        optJSON.put((Object)OPTION_HIDDEN, (Object)this.hidden);
        if (this.deprecated) {
            optJSON.put((Object)OPTION_DEPRECATED, (Object)this.deprecated);
        }
        optJSON.put((Object)OPTION_REQUIRED, (Object)this.required);
        if (OptionType.OptionArray.equals((Object)this.type) || OptionType.Option.equals((Object)this.type)) {
            JSONArray jsonArr = new JSONArray();
            for (Option<?> child : this.childOptions) {
                jsonArr.add((Object)child.toJSONObject());
            }
            optJSON.put((Object)CHILD_OPTIONS, (Object)jsonArr);
        }
        optJSON.put((Object)OPTION_TYPE, (Object)this.type.name());
        return optJSON;
    }

    public Option<T> appendValidator(Validator<?> validator) {
        try {
            Option option = (Option)this.clone();
            option.validator = new ArrayList<Validator<T>>(this.validator);
            option.validator.add(validator);
            return option;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class OptionBuilder<T> {
        final Option<T> option;

        private OptionBuilder(String name, OptionType typeToken) {
            this(name, typeToken, null);
        }

        private OptionBuilder(String name, OptionType typeToken, @Nullable ResourceBundle resourceBundle) {
            this.option = new Option(name, typeToken);
            if (resourceBundle != null) {
                if (resourceBundle.containsKey(name + ".message")) {
                    this.option.description = resourceBundle.getString(name + ".message");
                }
                if (resourceBundle.containsKey(name + ".placeholders")) {
                    this.option.hint = resourceBundle.getString(name + ".placeholders");
                }
                if (resourceBundle.containsKey(name + ".label")) {
                    this.option.label = resourceBundle.getString(name + ".label");
                }
            }
        }

        @Nonnull
        public Option<T> build() {
            return this.option;
        }

        @Nonnull
        public OptionBuilder<T> withValidator(Validator<T> validator) {
            this.option.validator.add(validator);
            return this;
        }

        @Nonnull
        public OptionBuilder<T> required() {
            this.option.required = true;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> hidden() {
            this.option.hidden = true;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> deprecated() {
            this.option.deprecated = true;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> updatable() {
            this.option.updatable = true;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> unsaved() {
            this.option.unsaved = true;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> hint(String hint) {
            this.option.hint = hint;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> label(String label) {
            this.option.label = label;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> description(String description) {
            this.option.description = description;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> defaultValue(@Nonnull T value) {
            this.option.defaultValue = value;
            return this;
        }

        @Nonnull
        public OptionBuilder<T> childOption(Option<?> childOption) {
            this.option.childOptions.add(childOption);
            return this;
        }
    }
}

