/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.api.CloseableIterator;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.ParallelTransactionListener;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.Statements;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TLongProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

final class EntityUpdateListener
implements StatementListener,
ParallelTransactionListener {
    private final ExternalSyncPlugin parent;
    private final TLongObjectHashMap<Set<ExternalStore>> propertyStoreMap;
    private final TLongObjectHashMap<Set<ExternalStore>> inverseStoreMap;
    private final TLongObjectHashMap<Set<ExternalStore>> chainStoreMap;
    private final TLongObjectHashMap<Set<ExternalStore>> inverseChainStoreMap;
    private final TLongObjectHashMap<Set<ExternalStore>> typeStoreMap;
    private final Map<ExternalStore, Callable<Void>> syncAllEntitiesStores;
    private final Set<ExternalStore> affectedStores;
    private final Set<ExternalStore> committedStores;
    private final Set<ExternalStore> allStores;
    private final long rdfTypeId;
    private final long rdfsResourceId;
    private final Logger logger;
    private long lastCompletedTransaction = -1L;
    private final TLongObjectHashMap<TLongHashSet> addedTypes;
    private final TLongObjectHashMap<TLongHashSet> removedTypes;
    private boolean isTestingTransaction;
    private final AtomicBoolean transactionWasAborted = new AtomicBoolean();
    private static final Set<ExternalStore> EMPTY_HANDLER_LIST = new HashSet<ExternalStore>();

    public EntityUpdateListener(ExternalSyncPlugin parent, Collection<ExternalStore> handlers, long rdfTypeId, long rdfsResourceId) {
        this.parent = parent;
        this.logger = parent.getLogger();
        this.propertyStoreMap = new TLongObjectHashMap();
        this.chainStoreMap = new TLongObjectHashMap();
        this.typeStoreMap = new TLongObjectHashMap();
        this.inverseStoreMap = new TLongObjectHashMap();
        this.inverseChainStoreMap = new TLongObjectHashMap();
        this.allStores = new HashSet<ExternalStore>();
        for (ExternalStore handler : handlers) {
            this.addIndexHandler(handler);
        }
        this.affectedStores = Collections.synchronizedSet(new HashSet());
        this.committedStores = new HashSet<ExternalStore>();
        this.syncAllEntitiesStores = new HashMap<ExternalStore, Callable<Void>>();
        this.rdfTypeId = rdfTypeId;
        this.rdfsResourceId = rdfsResourceId;
        this.addedTypes = new TLongObjectHashMap();
        this.removedTypes = new TLongObjectHashMap();
    }

    private boolean isEnabled() {
        return this.propertyStoreMap.size() > 0;
    }

    public void addIndexHandler(ExternalStore handler) {
        this.allStores.add(handler);
        if (!handler.isReadonly()) {
            this.addHandler(this.propertyStoreMap, handler.getTypeAndPropertyKeeper().getDirectProperties(), handler);
            this.addHandler(this.chainStoreMap, handler.getTypeAndPropertyKeeper().getChainProperties(), handler);
            this.addHandler(this.inverseStoreMap, handler.getTypeAndPropertyKeeper().getInverseProperties(), handler);
            this.addHandler(this.inverseChainStoreMap, handler.getTypeAndPropertyKeeper().getInverseChainProperties(), handler);
            this.addHandler(this.propertyStoreMap, handler.getExtraPropertiesToListenFor(), handler);
            this.addHandler(this.typeStoreMap, handler.getTypeAndPropertyKeeper().getTypes(), handler);
        }
    }

    private void addHandler(TLongObjectHashMap<Set<ExternalStore>> map, long[] keys, ExternalStore handler) {
        for (long key : keys) {
            HashSet<ExternalStore> handlers = (HashSet<ExternalStore>)map.get(key);
            if (handlers == null) {
                handlers = new HashSet<ExternalStore>();
                map.put(key, handlers);
            }
            handlers.add(handler);
        }
    }

    public void removeIndexHandler(ExternalStore handler) {
        this.allStores.remove(handler);
        this.removeHandler(this.propertyStoreMap, handler.getTypeAndPropertyKeeper().getDirectProperties(), handler);
        this.removeHandler(this.chainStoreMap, handler.getTypeAndPropertyKeeper().getChainProperties(), handler);
        this.removeHandler(this.inverseStoreMap, handler.getTypeAndPropertyKeeper().getInverseProperties(), handler);
        this.removeHandler(this.inverseChainStoreMap, handler.getTypeAndPropertyKeeper().getInverseChainProperties(), handler);
        this.removeHandler(this.typeStoreMap, handler.getTypeAndPropertyKeeper().getTypes(), handler);
        this.removeHandler(this.propertyStoreMap, handler.getExtraPropertiesToListenFor(), handler);
    }

    private void removeHandler(TLongObjectHashMap<Set<ExternalStore>> map, long[] keys, ExternalStore handler) {
        for (long key : keys) {
            Set handlers = (Set)map.get(key);
            if (handlers == null) continue;
            handlers.remove(handler);
            if (!handlers.isEmpty()) continue;
            map.remove(key);
        }
    }

    private Set<ExternalStore> getStoresForProperty(long property) {
        Set ihp = (Set)this.propertyStoreMap.get(property);
        return ihp == null ? EMPTY_HANDLER_LIST : ihp;
    }

    private Set<ExternalStore> getStoresForInverseProperty(long property) {
        Set ihp = (Set)this.inverseStoreMap.get(property);
        return ihp == null ? EMPTY_HANDLER_LIST : ihp;
    }

    private Set<ExternalStore> getStoresForType(long type) {
        Set ihp = (Set)this.typeStoreMap.get(type);
        return ihp == null ? EMPTY_HANDLER_LIST : ihp;
    }

    public boolean statementAdded(long subject, long property, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        this.handleProperty(subject, property, object, false, pluginConnection);
        return false;
    }

    public boolean statementRemoved(long subject, long property, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        this.handleProperty(subject, property, object, true, pluginConnection);
        return false;
    }

    private void handleProperty(long subject, long property, long object, boolean isRemove, PluginConnection pluginConnection) {
        if (this.isEnabled()) {
            Set<ExternalStore> storesForType;
            if (property == this.rdfTypeId && !(storesForType = this.getStoresForType(object)).isEmpty()) {
                if (isRemove) {
                    TLongHashSet t = (TLongHashSet)this.removedTypes.get(subject);
                    if (t == null) {
                        t = new TLongHashSet();
                        this.removedTypes.put(subject, (Object)t);
                    }
                    t.add(object);
                    TLongHashSet added = (TLongHashSet)this.addedTypes.get(subject);
                    if (added != null) {
                        added.remove(object);
                    }
                    this.logger.debug("Type removed: {} on {}", (Object)object, (Object)subject);
                } else {
                    TLongHashSet t = (TLongHashSet)this.addedTypes.get(subject);
                    if (t == null) {
                        t = new TLongHashSet();
                        this.addedTypes.put(subject, (Object)t);
                    }
                    t.add(object);
                    this.logger.debug("Type added: {} on {}", (Object)object, (Object)subject);
                }
                this.markEntityForRefresh(subject, storesForType);
                return;
            }
            if (pluginConnection.getEntities().getType(object) == Entities.Type.LITERAL) {
                this.markEntityForRefresh(subject, this.getStoresForProperty(Integer.MIN_VALUE));
                this.markEntityForRefresh_chain(subject, Integer.MIN_VALUE, pluginConnection.getEntities(), pluginConnection.getStatements());
            }
            this.markEntityForRefresh(subject, this.getStoresForProperty(property));
            this.markEntityForRefresh(object, this.getStoresForInverseProperty(property));
            this.markEntityForRefresh_chain(subject, property, pluginConnection.getEntities(), pluginConnection.getStatements());
            this.markEntityForRefresh_InverseChain(object, property, pluginConnection.getEntities(), pluginConnection.getStatements());
        }
    }

    private void markEntityForRefresh(long subject, Collection<ExternalStore> handlers) {
        for (ExternalStore handler : handlers) {
            handler.markEntityForRefresh(subject);
        }
    }

    private void markEntityForRefresh_chain(long subject, long property, Entities entities, Statements statements) {
        Set<ExternalStore> handlers = this.getStoresForChainProperty(property);
        this.markEntitiesForChainRefresh(subject, property, entities, statements, handlers);
    }

    private void markEntityForRefresh_InverseChain(long subject, long property, Entities entities, Statements statements) {
        Set<ExternalStore> handlers = this.getStoresForInverseChainProperty(property);
        this.markEntitiesForChainRefresh(subject, property, entities, statements, handlers);
    }

    private void markEntitiesForChainRefresh(long subject, long property, Entities entities, Statements statements, Collection<ExternalStore> handlers) {
        for (ExternalStore handler : handlers) {
            try {
                CloseableIterator<Long> entitiesToUpdate = handler.getEntitiesForChangeUpdate(subject, property, (TLongHashSet)this.removedTypes.get(subject), entities, statements);
                try {
                    while (entitiesToUpdate.hasNext()) {
                        handler.markEntityForRefresh((Long)entitiesToUpdate.next());
                    }
                }
                finally {
                    if (entitiesToUpdate == null) continue;
                    entitiesToUpdate.close();
                }
            }
            catch (Exception e) {
                throw new ConnectorServerException("Unexpected exception", e);
            }
        }
    }

    private Set<ExternalStore> getStoresForChainProperty(long property) {
        Set ihp = (Set)this.chainStoreMap.get(property);
        return ihp == null ? EMPTY_HANDLER_LIST : ihp;
    }

    private Set<ExternalStore> getStoresForInverseChainProperty(long property) {
        Set ihp = (Set)this.inverseChainStoreMap.get(property);
        return ihp == null ? EMPTY_HANDLER_LIST : ihp;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        this.isTestingTransaction = pluginConnection.isTesting();
        this.logger.debug("transactionStarted() start (testing = {})", (Object)this.isTestingTransaction);
        this.lastCompletedTransaction = -1L;
        for (ExternalStore handler : this.allStores) {
            handler.transactionStarted(pluginConnection);
        }
        this.transactionWasAborted.set(false);
        this.logger.debug("transactionStarted() end");
        this.parent.storesManager.beginTransaction();
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        this.transactionCleanup();
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        this.logger.debug("transactionCompleted() start");
        this.lastCompletedTransaction = pluginConnection.getTransactionId();
        try {
            this.refreshTransactionEntities(pluginConnection);
            this.parent.commitExternalTransaction();
        }
        catch (Exception e) {
            try {
                this.transactionAborted(pluginConnection);
            }
            catch (Exception e2) {
                this.logger.warn("Error while aborting transaction internally, continuing anyway.", (Throwable)e);
            }
            if (e instanceof PluginException) {
                throw e;
            }
            throw new PluginException("Connector failed in commit()", (Throwable)e);
        }
        finally {
            this.parent.closeTemporaryGraph();
        }
        final TLongObjectHashMap typeMap = new TLongObjectHashMap();
        this.removedTypes.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TLongHashSet>(){

            public boolean execute(long subject, TLongHashSet oldTypes) {
                final TLongHashSet newTypes = (TLongHashSet)EntityUpdateListener.this.addedTypes.get(subject);
                oldTypes.forEach(new TLongProcedure(){

                    public boolean execute(long oldType) {
                        TLongHashSet mappedTypes = (TLongHashSet)typeMap.get(oldType);
                        if (mappedTypes == null) {
                            mappedTypes = new TLongHashSet();
                            if (newTypes == null || !newTypes.contains(oldType)) {
                                typeMap.put(oldType, (Object)mappedTypes);
                            }
                        }
                        if (newTypes != null) {
                            mappedTypes.addAll(newTypes.toArray());
                        } else {
                            mappedTypes.add(EntityUpdateListener.this.rdfsResourceId);
                        }
                        return true;
                    }
                });
                return true;
            }
        });
        for (ExternalStore handler : this.allStores) {
            try {
                handler.notifyTypeChanges((TLongObjectHashMap<TLongHashSet>)typeMap);
                if (!handler.transactionCompleted(pluginConnection)) continue;
                this.committedStores.add(handler);
            }
            catch (Exception e) {
                if (e instanceof PluginException) {
                    throw e;
                }
                throw new PluginException("Connector failed in commit()", (Throwable)e);
            }
        }
        this.parent.storesManager.commitTransaction();
        this.logger.debug("transactionCompleted() end");
    }

    private void refreshTransactionEntities(PluginConnection pluginConnection) {
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        tasks.addAll(this.syncAllEntitiesStores.values());
        for (ExternalStore store : this.allStores) {
            Callable<Void> task = () -> {
                try {
                    if (store.refreshMarkedEntities(pluginConnection)) {
                        this.affectedStores.add(store);
                    }
                }
                catch (Exception e) {
                    this.affectedStores.add(store);
                    for (ExternalStore otherStore : this.allStores) {
                        otherStore.notifyErrorInAnotherThread();
                    }
                    throw e;
                }
                return null;
            };
            tasks.add(task);
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        try {
            List futures = this.parent.executorService.invokeAll(tasks);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    exceptions.add(e.getCause());
                    this.logger.error("Connector instance failed in commit()", e.getCause());
                }
            }
            if (!exceptions.isEmpty()) {
                Throwable firstError = (Throwable)exceptions.get(0);
                if (firstError instanceof RuntimeException) {
                    throw (RuntimeException)firstError;
                }
                throw new ConnectorServerException("Indexing failed", firstError);
            }
        }
        catch (InterruptedException e) {
            throw new ConnectorServerException("Indexing failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionAborted(PluginConnection pluginConnection) {
        if (this.transactionWasAborted.compareAndSet(false, true)) {
            try {
                this.logger.debug("transactionAborted() start");
                this.parent.closeTemporaryGraph();
                this.parent.storesManager.abortTransaction();
                for (ExternalStore handler : this.affectedStores) {
                    try {
                        if (handler.wasJustCreated()) {
                            this.parent.removeStore(handler, true, pluginConnection.getEntities());
                            continue;
                        }
                        if (pluginConnection.getTransactionId() == this.lastCompletedTransaction && this.committedStores.contains(handler)) {
                            handler.rollbackLastCommitted(pluginConnection);
                            continue;
                        }
                        handler.rollbackCurrent(pluginConnection);
                    }
                    catch (Exception e) {
                        this.logger.warn("Rollback of transaction {} failed with {}", (Object)pluginConnection.getTransactionId(), (Object)e.getMessage());
                    }
                }
                this.parent.storesManager.cleanupAbortedTransaction();
                this.logger.debug("transactionAborted() end");
            }
            finally {
                this.transactionCleanup();
            }
        }
    }

    public void transactionCleanup() {
        this.affectedStores.clear();
        this.committedStores.clear();
        this.syncAllEntitiesStores.clear();
        this.addedTypes.clear();
        this.removedTypes.clear();
    }

    public boolean isTestingTransaction() {
        return this.isTestingTransaction;
    }

    public void scheduleSyncAllEntities(ExternalStore store, PluginConnection pluginConnection, Entities entitiesForIndexing, Statements statementsForIndexing, boolean repair) {
        this.syncAllEntitiesStores.put(store, () -> {
            store.syncAllEntities(pluginConnection, entitiesForIndexing, statementsForIndexing, repair);
            return null;
        });
    }
}

