/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.subscriptions;

import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.graphql.responder.EndpointInvokerResolver;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.QueryExecution;
import com.ontotext.graphql.responder.QueryExecutionRequest;
import com.ontotext.graphql.responder.RequestPreProcessor;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.OperationType;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Query;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.models.subscriptions.SubscriptionOp;
import com.ontotext.models.subscriptions.SubscriptionRequest;
import com.ontotext.platform.plugins.DatabaseRequestInvoker;
import com.ontotext.platform.plugins.PluginRuntimeException;
import com.ontotext.platform.plugins.entitychange.EntityChangePluginManager;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.subscriptions.PropertyChain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionRequestPreProcessor
implements RequestPreProcessor {
    private Map<SparqlEndpoint, EntityChangePluginManager> pluginManagerCache = new HashMap<SparqlEndpoint, EntityChangePluginManager>();

    public <E extends EndpointExecution> void processRequest(ExecutionRequest<E> executionContext, EndpointInvokerResolver invokerResolver) {
        if (!(executionContext instanceof QueryExecutionRequest)) {
            return;
        }
        QueryExecutionRequest queryExecution = (QueryExecutionRequest)executionContext;
        for (QueryExecution execution : queryExecution.getExecutions()) {
            this.processExecution(invokerResolver, queryExecution, execution);
        }
    }

    private void processExecution(EndpointInvokerResolver invokerResolver, QueryExecutionRequest queryExecution, QueryExecution execution) {
        if (SubscriptionRequestPreProcessor.isApplicableSubscriptionRequest(execution)) {
            Query query = execution.getGraphQuery();
            SubscriptionRequest subscriptionRequest = ((Subscription)query).getSubscriptionRequest();
            EntityChangePluginManager pluginManager = this.getPluginManager(invokerResolver, execution);
            String pluginName = subscriptionRequest.getPluginInstanceName();
            if (query.getArguments().getSubscriptionOp() == SubscriptionOp.CREATE) {
                try {
                    pluginManager.ensureCreated(pluginName, subscriptionRequest.getSubscriptionType(), () -> PropertyChain.fromSubscription((Subscription)query), (ExpressionValue<Object>)((ExpressionValue)query.getArguments().getWhere().orElse(null)));
                }
                catch (PluginRuntimeException re) {
                    queryExecution.addErrors(Collections.singletonList(re.getMessage()));
                }
            } else if (!pluginManager.exists(pluginName)) {
                queryExecution.addErrors(Collections.singletonList(ErrorMessages.get((String)"subscription.missing")));
            } else if (query.getArguments().getSubscriptionOp() == SubscriptionOp.DELETE) {
                pluginManager.remove(pluginName);
                String shortPluginName = pluginManager.getPluginShortName(pluginName);
                queryExecution.addWarnings(Collections.singletonList(ErrorMessages.get((String)"subscription.deleted", (Object[])new Object[]{shortPluginName})));
            }
        }
    }

    public static boolean isApplicableSubscriptionRequest(QueryExecution execution) {
        return execution.getGraphQuery().getOperationType() == OperationType.SUBSCRIPTION && execution.getEndpoint() instanceof SparqlEndpoint;
    }

    private EntityChangePluginManager getPluginManager(EndpointInvokerResolver invokerResolver, QueryExecution execution) {
        return this.pluginManagerCache.computeIfAbsent((SparqlEndpoint)execution.getEndpoint(), sparqlEndpoint -> new EntityChangePluginManager(new DatabaseRequestInvoker(invokerResolver, (SparqlEndpoint)sparqlEndpoint)));
    }
}

