/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.subscriptions;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.Shape;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.models.subscriptions.SubscriptionRequest;
import com.ontotext.platform.plugins.entitychange.EntityChangePluginGenerator;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.subscriptions.Utils;

@Order(value=50)
public class SubscriptionParsePostProcessor
implements OperationPostProcessor {
    public void postProcess(Operation operation, SecurityContext securityContext) {
        if (!(operation instanceof Subscription)) {
            return;
        }
        Subscription subscription = (Subscription)operation;
        SubscriptionRequest subscriptionRequest = subscription.getSubscriptionRequest();
        String returnType = subscription.getReturnType();
        String baseSubscriptionType = Utils.toSubscriptionType(returnType);
        String typeName = operation.getSchema().getPrefixes().nameToShortIri(baseSubscriptionType);
        Shape subscriptionType = (Shape)operation.getSchema().getObjects().get((Object)typeName);
        subscriptionRequest.setSubscriptionType(subscriptionType);
        subscriptionRequest.setPluginInstanceName(EntityChangePluginGenerator.getPluginInstanceName(subscriptionType, (ExpressionValue<Object>)((ExpressionValue)operation.getArguments().getWhere().orElse(null))));
    }
}

